package eu.dnetlib.repo.manager.client.getimpact;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.gwtbootstrap3.client.ui.constants.Toggle;

/**
 * Created by stefania on 12/19/16.
 */
public class EnableMetricsWidget implements IsWidget {

    private FlowPanel enableMetricsPanel = new FlowPanel();
    private Alert errorAlert = new Alert();

    private FlowPanel modal = new FlowPanel();

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    public EnableMetricsWidget(final Repository repository) {

        errorAlert.setDismissable(false);
        errorAlert.setType(AlertType.DANGER);
        errorAlert.setVisible(false);
        enableMetricsPanel.add(errorAlert);

        HTML enableMetricsText = new HTML("<h4>You don't have metrics enabled for this repository yet. Would you like to " +
                "enable them?</h4>" +
                "<p><img src=\"./img/metricsWorkflow-new.svg\" style=\"display:block; margin: 0 auto;\" width=\"50%\"></p>" +

                "<p>Once you select to enable metrics for your repository, the following steps need to be performed:</p>" +
                "<p><i>On your side</i> <br>" +
                "1. Download the tracking code for your repository platform <br>" +
                "2. Configure the tracking code according to the instructions <br>" +
                "3. Deploy the tracking code in your repository platform</p>" +

                "<p><i>On the OpenAIRE's side</i> <br>" +
                "4. Validate the installation of the tracking code and inform the repository manager accordingly</p>" +

//                "<p>Usage Statistics about items and content providers support the assessment of their popularity and use. " +
//                "They are an important complement to other kinds of metrics.</p>" +
//                "<p>OpenAIRE Usage Statistics aims to gather usage events (metadata views and downloads) of items from " +
//                "participating content providers. By utilizing open standards and protocols reliable, consolidated and " +
//                "comparable usage reports are generated that are conformant to the COUNTER Code of Practice.</p>" +
//                "<p>To participate in this service Content Provider Managers need to install platform specific patches or " +
//                "plugins that enable the tracking of usage events to the OpenAIRE Usage Statistics Service.</p>" +
//                "<p>Usage statistics are presented in the Content Provider Dashboard, in the OpenAIRE portal and can be " +
//                "retrieved by the OpenAIRE API.</p>" +

                "<div class=\"uk-alert uk-alert-info\">For more details about the workflows and tools please consult the <a target=\"_blank\" " +
                "href=\"./pdf/OpenAIRE_usage_stats_Guidelinesv1.pdf\">“Guidelines for Collecting Usage Events and Provision " +
                "of Usage Statistics”</a>.</div>");

        enableMetricsPanel.add(enableMetricsText);

        final Button enableMetricsButton = new Button();
        enableMetricsButton.setType(ButtonType.PRIMARY);
        enableMetricsButton.setText("Enable Metrics");
        enableMetricsButton.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {

                errorAlert.setVisible(false);
                enableMetrics(repository);
            }
        });
        enableMetricsPanel.add(enableMetricsButton);

//        UsageStatisticsGuidelinesWidget usageStatisticsGuidelinesWidget = new UsageStatisticsGuidelinesWidget();
//        enableMetricsPanel.add(usageStatisticsGuidelinesWidget.asWidget());
    }

    @Override
    public Widget asWidget() {
        return enableMetricsPanel;
    }

    private void enableMetrics(final Repository repository) {

        final Modal enableMetricsConfirmationPopup = new Modal();
        enableMetricsConfirmationPopup.setDataBackdrop(ModalBackdrop.STATIC);
//        enableMetricsConfirmationPopup.removeStyleName("modal");

        FlowPanel modalContent = new FlowPanel();

        HTML description = new HTML("<h2 class=\"uk-modal-title\">Confirmation</h2>\n" +
                "<p>Are you sure you want to enable metrics for this repository?</p>");
        modalContent.add(description);

        FlowPanel actionButtons = new FlowPanel();
        actionButtons.addStyleName("uk-text-right");
        modalContent.add(actionButtons);

        Button no = new Button("Cancel");
        no.setType(ButtonType.DEFAULT);
        no.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                enableMetricsConfirmationPopup.hide();
                enableMetricsConfirmationPopup.removeFromParent();
            }
        });
        actionButtons.add(no);

        Button yes = new Button("Yes, enable them");
        yes.setType(ButtonType.PRIMARY);
        yes.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                enableMetricsConfirmationPopup.hide();
                enableMetricsConfirmationPopup.removeFromParent();

                final HTML loadingWheel = new HTML("<div class=\"loader-big\"></div><div class=\"whiteFilm\"></div>");
                enableMetricsPanel.addStyleName("loading-big");
                enableMetricsPanel.add(loadingWheel);

                repositoryService.enableMetricsForRepository(repository, RepositoryManager.currentUser, new AsyncCallback<Void>() {

                    @Override
                    public void onFailure(Throwable caught) {

                        enableMetricsPanel.removeStyleName("loading-big");
                        enableMetricsPanel.remove(loadingWheel);

                        errorAlert.setText("System error enabling metrics for this repository.");
                        errorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(Void result) {

                        enableMetricsPanel.removeStyleName("loading-big");
                        enableMetricsPanel.remove(loadingWheel);

                        History.newItem("getImpact/instructions/" + repository.getId());
                    }
                });
            }
        });
        actionButtons.add(yes);

        ModalBody modalBody = new ModalBody();
        modalBody.add(modalContent);
        enableMetricsConfirmationPopup.add(modalBody);
        enableMetricsConfirmationPopup.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();

        enableMetricsConfirmationPopup.show();
    }
}
