package eu.dnetlib.repo.manager.client.getimpact;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.TokenController;

/**
 * Created by stefania on 4/4/16.
 */
public class GetImpactController extends TokenController {

    private GetImpactWidget getImpactWidget = new GetImpactWidget();
    private MetricsForDatasourceWidget metricsForDatasourceWidget = new MetricsForDatasourceWidget();
    private InstructionsForMetricsWidget instructionsForMetricsWidget = new InstructionsForMetricsWidget();

    private static GetImpactController instance = null;

    public static GetImpactController getInstance() {
        if (instance == null)
            instance = new GetImpactController();

        return instance;
    }

    @Override
    public void showWidget(FlowPanel contentPanel, String parent, String rest) {

        if (rest == null)
            redrawWidget(contentPanel, getImpactWidget, parent, rest);
        else {
            if(rest.contains("/") && (rest.indexOf("/") < rest.length())) {
                redrawWidget(contentPanel, instructionsForMetricsWidget, parent, rest);
            } else {
                redrawWidget(contentPanel, metricsForDatasourceWidget, parent, rest);
            }
        }
    }

//    @Override
//    public void drawHeader(String rest) {
//
//        RootPanel.get("pageHeader").addStyleName("row wrapper border-bottom white-bg page-heading");
//        if (rest == null) {
//            RepositoryManager.pageHeader.clear();
//            RepositoryManager.pageHeader.add(new HTML("<div class=\"col-sm-9\"><h2>Metrics</h2><ol class=\"breadcrumb\">" +
//                    "<li><a href=\"#dashboard\">Home</a></li><li class=\"active\"><strong>Metrics</strong></li></ol></div>"));
//        }
//    }

    @Override
    public String[] getMenuPath(String parent, String rest) {
        return new String[] {"getImpact"};
    }
}
