package eu.dnetlib.repo.manager.client.getimpact;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.shared.MetricsInfo;
import eu.dnetlib.domain.data.PiwikInfo;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.constants.AlertType;

/**
 * Created by stefania on 12/15/16.
 */
public class MetricsForDatasourceWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private FlowPanel metricsForDatasourceBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);
    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    public MetricsForDatasourceWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Metrics</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        metricsForDatasourceBoxContent.add(errorAlert);

        contentPanel.add(metricsForDatasourceBoxContent);
    }

    @Override
    public void clear() {

        metricsForDatasourceBoxContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        metricsForDatasourceBoxContent.add(errorAlert);

        helpService.getHelpById(parentToken + "_forDatasource", new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repository information...</div>" +
                "<div class=\"whiteFilm\"></div>");
        metricsForDatasourceBoxContent.addStyleName("loading-big");
        metricsForDatasourceBoxContent.add(loadingWheel);

        repositoryService.getRepository(restToken, new AsyncCallback<Repository>() {

            @Override
            public void onFailure(Throwable caught) {

                metricsForDatasourceBoxContent.removeStyleName("loading-big");
                metricsForDatasourceBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving repository info");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(final Repository repository) {

                if(repository.getPiwikInfo()==null) {

                    metricsForDatasourceBoxContent.removeStyleName("loading-big");
                    metricsForDatasourceBoxContent.remove(loadingWheel);

                    EnableMetricsWidget enableMetricsWidget = new EnableMetricsWidget(repository);
                    metricsForDatasourceBoxContent.add(enableMetricsWidget.asWidget());

                } else if(!repository.getPiwikInfo().isValidated()) {

                    History.replaceItem("getImpact/instructions/" + repository.getId());

                } else {

                    repositoryService.getMetricsInfoForRepository(repository.getId(), new AsyncCallback<MetricsInfo>() {

                        @Override
                        public void onFailure(Throwable throwable) {
                            metricsForDatasourceBoxContent.removeStyleName("loading-big");
                            metricsForDatasourceBoxContent.remove(loadingWheel);

                            errorAlert.setText("System error retrieving metrics info");
                            errorAlert.setVisible(true);
                        }

                        @Override
                        public void onSuccess(MetricsInfo metricsInfo) {

                            metricsForDatasourceBoxContent.removeStyleName("loading-big");
                            metricsForDatasourceBoxContent.remove(loadingWheel);

                            metricsForDatasourceBoxContent.add(createMetricsPanel(metricsInfo, repository.getPiwikInfo()));
                        }
                    });
                }
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private FlowPanel createMetricsPanel(MetricsInfo metricsInfo, PiwikInfo piwikInfo) {

        FlowPanel metricsPanel = new FlowPanel();

        FlowPanel numbersPanel = new FlowPanel();
        numbersPanel.addStyleName("uk-margin-medium-bottom");

        String numbers = "<div class=\"uk-child-width-1-3@m uk-grid-small uk-grid-match uk-grid\" uk-grid=\"\">" +
                "<div class=\"metrics-openaire uk-first-column\">" +
                "<div class=\"uk-tile uk-tile-default uk-padding-small\">";

        if(metricsInfo.getMetricsNumbers()!=null && metricsInfo.getMetricsNumbers().getPageViews()!=null
                && !metricsInfo.getMetricsNumbers().getPageViews().trim().equals(""))
            numbers += "<div class=\"uk-text-center\">   " + metricsInfo.getMetricsNumbers().getPageViews() + "</div>";
        else
            numbers += "<div class=\"uk-text-center\">--</div>";

        numbers += "<div class=\"uk-text-center\"> views in OpenAIRE</div>" +
                "</div></div>" +
                "<div class=\"metrics-views\">" +
                "<div class=\"uk-tile uk-tile-muted uk-padding-small\">";

        if(metricsInfo.getMetricsNumbers()!=null && metricsInfo.getMetricsNumbers().getTotalViews()!=null
                && !metricsInfo.getMetricsNumbers().getTotalViews().trim().equals(""))
            numbers += "<div class=\"uk-text-center\">  " + metricsInfo.getMetricsNumbers().getTotalViews();
        else
            numbers += "<div class=\"uk-text-center\">  --";

        if(metricsInfo.getMetricsNumbers()!=null && metricsInfo.getMetricsNumbers().getTotalOpenAIREViews()!=null
                && !metricsInfo.getMetricsNumbers().getTotalOpenAIREViews().trim().equals(""))
            numbers += "<span>( " + metricsInfo.getMetricsNumbers().getTotalOpenAIREViews() + " from OpenAIRE )</span>";
        else
            numbers += "<span>( -- from OpenAIRE )</span>";

        numbers += "</div>" +
                "<div class=\"uk-text-center\">views in local repository</div>" +
                "</div></div>" +
                "<div class=\"metrics-downloads\">" +
                "<div class=\"uk-tile uk-tile-primary uk-padding-small\">";

        if(metricsInfo.getMetricsNumbers()!=null && metricsInfo.getMetricsNumbers().getTotalDownloads()!=null
                && !metricsInfo.getMetricsNumbers().getTotalDownloads().trim().equals(""))
            numbers += "<div class=\"uk-text-center\">  " + metricsInfo.getMetricsNumbers().getTotalDownloads();
        else
            numbers += "<div class=\"uk-text-center\">  --";

        if(metricsInfo.getMetricsNumbers()!=null && metricsInfo.getMetricsNumbers().getTotalOpenAIREDownloads()!=null
                && !metricsInfo.getMetricsNumbers().getTotalOpenAIREDownloads().trim().equals(""))
            numbers += "<span>( " + metricsInfo.getMetricsNumbers().getTotalOpenAIREDownloads() + " from OpenAIRE )</span>";
        else
            numbers += "<span>( -- from OpenAIRE )</span>";

        numbers += "</div>" +
                "<div class=\"uk-text-center\">downloads in local repository</div>" +
                "</div>" +
                "</div>" +
                "</div>";

        numbersPanel.add(new HTML(numbers));
        metricsPanel.add(numbersPanel);

        String datasourcesMonthlyViewsURL = metricsInfo.getDiagramsBaseURL() + "merge.php?com=query&data=[{\"query\":\"dtsrcRepoViews\"," +
                "\"dtsrcName\":\"" + piwikInfo.getOpenaireId() + "\",\"table\":\"\",\"fields\":[{\"fld\":\"sum\",\"agg\":\"sum\"," +
                "\"type\":\"chart\",\"yaxis\":1,\"c\":false}],\"xaxis\":{\"name\":\"month\",\"agg\":\"sum\"},\"group\":\"\",\"color\":\"\"," +
                "\"type\":\"chart\",\"size\":30,\"sort\":\"xaxis\",\"xStyle\":{\"r\":-30,\"s\":\"0\",\"l\":\"-\",\"ft\":\"-\",\"wt\":\"-\"}," +
                "\"title\":\"\",\"subtitle\":\"\",\"xaxistitle\":\"\",\"yaxisheaders\":[\"Monthly views\"],\"generalxaxis\":\"\"," +
                "\"theme\":0,\"in\":[]}]&info_types=[\"spline\"]&stacking=&steps=false&fontFamily=Courier&spacing=[5,0,0,0]&" +
                "style=[{\"color\":\"rgba(0, 0, 0, 1)\",\"size\":\"18\"},{\"color\":\"rgba(0, 0, 0, 1)\",\"size\":\"18\"}," +
                "{\"color\":\"000000\",\"size\":\"\"},{\"color\":\"000000\",\"size\":\"\"}]&backgroundColor=rgba(255,255,255,1)&colors[]=rgba(124,\n" +
                "181, 236, 1)&colors[]=rgba(67, 67, 72, 1)&colors[]=rgba(144, 237, 125,\n" +
                "1)&colors[]=rgba(247, 163, 92, 1)&colors[]=rgba(128, 133, 233,\n" +
                "1)&colors[]=rgba(241, 92, 128, 1)&colors[]=rgba(228, 211, 84,\n" +
                "1)&colors[]=rgba(43, 144, 143, 1)&colors[]=rgba(244, 91, 91,\n" +
                "1)&colors[]=rgba(145, 232, 225,\n" +
                "1)&xlinew=0&ylinew=1&legends=true&tooltips=true&persistent=false";

        Frame datasourcesMonthlyViews = new Frame(datasourcesMonthlyViewsURL);
        datasourcesMonthlyViews.setStyleName("statsFrame");

        FlowPanel monthlyViewsPanel = new FlowPanel();
        monthlyViewsPanel.addStyleName("uk-text-center uk-card uk-card-default uk-card-hover uk-scrollspy-inview " +
                "uk-animation-slide-top-medium uk-margin-bottom uk-padding");
        monthlyViewsPanel.add(datasourcesMonthlyViews);
        metricsPanel.add(monthlyViewsPanel);

        String datasourcesMonthlyDownloadsURL = metricsInfo.getDiagramsBaseURL() + "merge.php?com=query&data=[{\"query\":\"dtsrcRepoDownloads\"," +
                "\"dtsrcName\":\"" + piwikInfo.getOpenaireId() + "\",\"table\":\"\",\"fields\":[{\"fld\":\"sum\"," +
                "\"agg\":\"sum\",\"type\":\"chart\",\"yaxis\":1,\"c\":false}],\"xaxis\":{\"name\":\"month\",\"agg\":\"sum\"}," +
                "\"group\":\"\",\"color\":\"\",\"type\":\"chart\",\"size\":30,\"sort\":\"xaxis\",\"xStyle\":{\"r\":-30,\"s\":\"0\",\"l\":\"-\"," +
                "\"ft\":\"-\",\"wt\":\"-\"},\"title\":\"\",\"subtitle\":\"\",\"xaxistitle\":\"\",\"yaxisheaders\":[\"Monthly\n" +
                "downloads\"],\"generalxaxis\":\"\",\"theme\":0,\"in\":[]}]&info_types=[\"spline\"]&stacking=&steps=false&fontFamily=Courier&" +
                "spacing=[5,0,0,0]&style=[{\"color\":\"rgba(0, 0, 0, 1)\",\"size\":\"18\"},{\"color\":\"rgba(0, 0, 0,\n" +
                "1)\",\"size\":\"18\"},{\"color\":\"000000\",\"size\":\"\"},{\"color\":\"000000\",\"size\":\"\"}]&backgroundColor=" +
                "rgba(255,255,255,1)&colors[]=rgba(124, 181, 236, 1)&colors[]=rgba(67, 67, 72, 1)&colors[]=rgba(144, 237, 125,\n" +
                "1)&colors[]=rgba(247, 163, 92, 1)&colors[]=rgba(128, 133, 233,\n" +
                "1)&colors[]=rgba(241, 92, 128, 1)&colors[]=rgba(228, 211, 84,\n" +
                "1)&colors[]=rgba(43, 144, 143, 1)&colors[]=rgba(244, 91, 91,\n" +
                "1)&colors[]=rgba(145, 232, 225,\n" +
                "1)&xlinew=0&ylinew=1&legends=true&tooltips=true&persistent=false";

        Frame datasourcesMonthlyDownloads = new Frame(datasourcesMonthlyDownloadsURL);
        datasourcesMonthlyDownloads.setStyleName("statsFrame");

        FlowPanel monthlyDownloadsPanel = new FlowPanel();
        monthlyDownloadsPanel.addStyleName("uk-text-center uk-card uk-card-default uk-card-hover uk-scrollspy-inview " +
                "uk-animation-slide-top-medium uk-margin-bottom uk-padding");
        monthlyDownloadsPanel.add(datasourcesMonthlyDownloads);
        metricsPanel.add(monthlyDownloadsPanel);

        return metricsPanel;
    }
}
