package eu.dnetlib.repo.manager.client.monitor;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.shared.AggregationDetails;

import java.util.List;

/**
 * Created by stefania on 1/16/18.
 */
public class AggregationHistoryTimeline implements IsWidget {

    private FlowPanel aggregationHistoryPanel = new FlowPanel();

    private DateTimeFormat dtf = DateTimeFormat.getFormat("yyyy-MM-dd");

    public AggregationHistoryTimeline(List<AggregationDetails> aggregationHistory) {

        aggregationHistoryPanel.addStyleName("uk-width-1-1@m");

        FlowPanel section = new FlowPanel();
        section.addStyleName("section md-bg-blue-grey-700");
        aggregationHistoryPanel.add(section);

        FlowPanel container = new FlowPanel();
        container.addStyleName("uk-container uk-container-center");
        section.add(container);

        FlowPanel timeline = new FlowPanel();
        timeline.addStyleName("al_timeline");
        container.add(timeline);

        for(AggregationDetails aggregationDetails: aggregationHistory) {

            FlowPanel timelineBlock = new FlowPanel();
            timelineBlock.addStyleName("al_timeline_block versionChange");

            FlowPanel timelineImage = new FlowPanel();
            timelineImage.addStyleName("al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up");
            timelineBlock.add(timelineImage);

            FlowPanel timelineContent = new FlowPanel();
            timelineContent.addStyleName("al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-left");
            timelineBlock.add(timelineContent);

            String content = "";

            if(aggregationDetails.getDate()!=null)
                content += "<h3>" + dtf.format(aggregationDetails.getDate()) + "</h3>";

            if(aggregationDetails.getAggregationStage()!=null)
                content += "<p>Aggregation stage - " + aggregationDetails.getAggregationStage() + "</p>";

            if(aggregationDetails.getCollectionMode()!=null)
                content += "<p>Collection mode - " + aggregationDetails.getCollectionMode() + "</p>";

            content += "<p>Number of records - " + aggregationDetails.getNumberOfRecords() + "</p>";
//                    "<a class=\"md-btn md-btn-primary\" href=\"#\">View version details</a>" ;
            timelineContent.add(new HTML(content));

            timeline.add(timelineBlock);
        }

//        String timelineContent = "<div _ngcontent-c5=\"\" class=\"uk-width-1-1@m\">\n" +
//                "<section _ngcontent-c5=\"\" class=\"section md-bg-blue-grey-700\">\n" +
//                "                                        <div _ngcontent-c5=\"\" class=\"uk-container uk-container-center\">\n" +
//                "                                            <div _ngcontent-c5=\"\" class=\"al_timeline\">\n" +
//                "                                                <div _ngcontent-c5=\"\" class=\"al_timeline_block versionChange\">\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up\">\n" +
//                "                                                    </div>\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-left\">\n" +
//                "                                                        <h3 _ngcontent-c5=\"\">Version 3</h3>\n" +
//                "                                                        <p _ngcontent-c5=\"\">Updated to this version on 08/08/17 by Antonis Lempesis</p>\n" +
//                "                                                        <a _ngcontent-c5=\"\" class=\"md-btn md-btn-primary\" href=\"#\">View version details</a>\n" +
//                "                                                    </div>\n" +
//                "                                                </div>\n" +
//                "                                                <div _ngcontent-c5=\"\" class=\"al_timeline_block update\">\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up\">\n" +
//                "                                                    </div>\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-right\">\n" +
//                "                                                        <h3 _ngcontent-c5=\"\">Updated</h3>\n" +
//                "                                                        <p _ngcontent-c5=\"\">on 07/06/17 by George Papastefanatos</p>\n" +
//                "                                                    </div>\n" +
//                "                                                </div>\n" +
//                "                                                <div _ngcontent-c5=\"\" class=\"al_timeline_block update\">\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up\">\n" +
//                "                                                    </div>\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-right\">\n" +
//                "                                                        <h3 _ngcontent-c5=\"\">Updated</h3>\n" +
//                "                                                        <p _ngcontent-c5=\"\">on 05/06/17 by Antonis Lempesis</p>\n" +
//                "                                                    </div>\n" +
//                "                                                </div>\n" +
//                "                                                <div _ngcontent-c5=\"\" class=\"al_timeline_block versionChange\">\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up\">\n" +
//                "                                                    </div>\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-right\">\n" +
//                "                                                        <h3 _ngcontent-c5=\"\">Version 2</h3>\n" +
//                "                                                        <p _ngcontent-c5=\"\">Updated to this version by Stefania Martziou</p>\n" +
//                "                                                        <a _ngcontent-c5=\"\" class=\"md-btn md-btn-primary\" href=\"#\">View version details</a>\n" +
//                "                                                    </div>\n" +
//                "                                                </div>\n" +
//                "                                                <div _ngcontent-c5=\"\" class=\"al_timeline_block update\">\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up\">\n" +
//                "                                                    </div>\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-right\">\n" +
//                "                                                        <h3 _ngcontent-c5=\"\">Updated</h3>\n" +
//                "                                                        <p _ngcontent-c5=\"\">on 07/06/17 by George Papastefanatos</p>\n" +
//                "                                                    </div>\n" +
//                "                                                </div>\n" +
//                "                                                <div _ngcontent-c5=\"\" class=\"al_timeline_block update\">\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up\">\n" +
//                "                                                    </div>\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-right\">\n" +
//                "                                                        <h3 _ngcontent-c5=\"\">Updated</h3>\n" +
//                "                                                        <p _ngcontent-c5=\"\">on 07/06/17 by Panagiotis Lampropoulos</p>\n" +
//                "                                                    </div>\n" +
//                "                                                </div>\n" +
//                "                                                <div _ngcontent-c5=\"\" class=\"al_timeline_block update\">\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up\">\n" +
//                "                                                    </div>\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-left\">\n" +
//                "                                                        <h3 _ngcontent-c5=\"\">Updated</h3>\n" +
//                "                                                        <p _ngcontent-c5=\"\">on 07/06/17 by Stefania Martziou</p>\n" +
//                "                                                    </div>\n" +
//                "                                                </div>\n" +
//                "                                                <div _ngcontent-c5=\"\" class=\"al_timeline_block versionChange\">\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_image\">\n" +
//                "                                                    </div>\n" +
//                "                                                    <div _ngcontent-c5=\"\" class=\"al_timeline_content\">\n" +
//                "                                                        <h3 _ngcontent-c5=\"\">Version 1</h3>\n" +
//                "                                                        <p _ngcontent-c5=\"\">Updated to this version on 01/01/2017 by George Papastefanatos</p>\n" +
//                "                                                        <a _ngcontent-c5=\"\" class=\"md-btn md-btn-primary\" href=\"#\">View version details</a>\n" +
//                "                                                    </div>\n" +
//                "                                                </div>\n" +
//                "                                            </div>\n" +
//                "                                        </div>\n" +
//                "                                    </section>\n" +
//                "\n" +
//                "\n" +
//                "                                </div>";
//
//        HTML timeline = new HTML(timelineContent);
//
//        aggregationHistoryPanel.add(timeline);

    }

    @Override
    public Widget asWidget() {
        return aggregationHistoryPanel;
    }
}
