package eu.dnetlib.repo.manager.client.monitor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.shared.Aggregations;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

/**
 * Created by stefania on 1/16/18.
 */
public class CollectionMonitorWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private Alert errorAlert = new Alert();

    private HTML title = new HTML();
    private FlowPanel monitorContent = new FlowPanel();

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);
    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    public CollectionMonitorWidget() {

        super();

        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        contentPanel.add(errorAlert);

        contentPanel.add(monitorContent);
    }

    @Override
    public void clear() {

        monitorContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        errorAlert.setVisible(false);

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");

        helpService.getHelpById(parentToken, new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repository info...</div>" +
                "<div class=\"whiteFilm\"></div>");
        monitorContent.addStyleName("loading-big");
        monitorContent.add(loadingWheel);

        repositoryService.getRepository(restToken, new AsyncCallback<Repository>() {

            @Override
            public void onFailure(Throwable throwable) {

                monitorContent.removeStyleName("loading-big");
                monitorContent.remove(loadingWheel);

                Alert errorAlert = new Alert();
                errorAlert.setType(AlertType.DANGER);
                errorAlert.setText("System error retrieving repository info.");
                errorAlert.setDismissable(false);
                monitorContent.add(errorAlert);
            }

            @Override
            public void onSuccess(Repository repository) {

                title.setHTML("<h1 class=\"uk-article-title\">Aggregation history for " + repository.getOfficialName() + "</h1>");

                repositoryService.getRepositoryAggregations(restToken, new AsyncCallback<Aggregations>() {

                    @Override
                    public void onFailure(Throwable throwable) {

                        monitorContent.removeStyleName("loading-big");
                        monitorContent.remove(loadingWheel);

                        Alert errorAlert = new Alert();
                        errorAlert.setType(AlertType.DANGER);
                        errorAlert.setText("System error retrieving repository aggregation history.");
                        errorAlert.setDismissable(false);
                        monitorContent.add(errorAlert);
                    }

                    @Override
                    public void onSuccess(Aggregations aggregations) {

                        monitorContent.removeStyleName("loading-big");
                        monitorContent.remove(loadingWheel);

                        if(aggregations==null || aggregations.getAggregationHistory()==null
                                || aggregations.getAggregationHistory().isEmpty()) {
                            HTML message = new HTML("<div>There is no aggregation history for this repository at the moment</div>");
                            monitorContent.add(message);
                        } else {
                            AggregationHistoryTimeline aggregationHistoryTimeline = new AggregationHistoryTimeline(aggregations.getAggregationHistory());
                            monitorContent.add(aggregationHistoryTimeline.asWidget());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }
}
