package eu.dnetlib.repo.manager.client.monitor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.ListOrGridViewOfDatasourcesWidget;
import eu.dnetlib.repo.manager.client.widgets.OpenAIRECompliantLogoDownloadWidget;
import eu.dnetlib.repo.manager.shared.DatasourcesCollection;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

/**
 * Created by stefania on 11/30/17.
 */
public class MonitorWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private Alert errorAlert = new Alert();

    private FlowPanel monitorContent = new FlowPanel();

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);
    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    public MonitorWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Monitor</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        contentPanel.add(errorAlert);

        contentPanel.add(monitorContent);
    }

    @Override
    public void clear() {
        monitorContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        errorAlert.setVisible(false);

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");

        helpService.getHelpById(parentToken, new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repositories...</div>" +
                "<div class=\"whiteFilm\"></div>");
        monitorContent.addStyleName("loading-big");
        monitorContent.add(loadingWheel);

        repositoryService.getRepositoriesOfUser(RepositoryManager.currentUser.getEmail(), true, false,
                new AsyncCallback<DatasourcesCollection>() {

                    @Override
                    public void onFailure(Throwable caught) {

                        monitorContent.removeStyleName("loading-big");
                        monitorContent.remove(loadingWheel);

                        Alert errorAlert = new Alert();
                        errorAlert.setType(AlertType.DANGER);
                        errorAlert.setText("System error retrieving repositories.");
                        errorAlert.setDismissable(false);
                        monitorContent.add(errorAlert);
                    }

                    @Override
                    public void onSuccess(DatasourcesCollection datasourcesCollection) {

                        monitorContent.removeStyleName("loading-big");
                        monitorContent.remove(loadingWheel);

                        ListOrGridViewOfDatasourcesWidget listOrGridViewOfDatasourcesWidget =
                                new ListOrGridViewOfDatasourcesWidget(datasourcesCollection, "Choose the Datasource you would like to manage",
                                        parentToken, "<i class=\"fa fa-pencil\" aria-hidden=\"true\"></i>", false);

                        monitorContent.add(listOrGridViewOfDatasourcesWidget.asWidget());
                    }
                });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }
}
