package eu.dnetlib.repo.manager.client.services;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import eu.dnetlib.repo.manager.shared.BrokerException;
import eu.dnetlib.repo.manager.shared.Term;
import eu.dnetlib.repo.manager.shared.broker.*;
import org.json.JSONException;

import java.util.List;
import java.util.Map;

/**
 * Created by stefania on 10/26/16.
 */
@RemoteServiceRelativePath("springGwtServices/brokerService")
public interface BrokerService extends RemoteService {

    List<BrowseEntry> getTopicsForDatasource(String datasourceName) throws BrokerException;

    EventsPage showEvents(String datasourceName, String topic, long page) throws BrokerException;

    EventsPage advancedShowEvents(AdvQueryObject advQueryObject, long page, long pageSize) throws BrokerException;

    DatasourcesBroker getDatasourcesOfUser(String userEmail, boolean includeShared, boolean includeByOthers) throws BrokerException;

    Map<String, List<SimpleSubscriptionDesc>> getSimpleSubscriptionsOfUser(String userEmail) throws BrokerException;

    Map<String, List<Subscription>> getSubscriptionsOfUser(String userEmail) throws BrokerException;

    Subscription subscribe(OpenaireSubscription obj) throws BrokerException;

    void unsubscribe(String subscriptionId) throws BrokerException;

    void unsubscribe(List<String> subscriptionIds) throws BrokerException;

    Subscription getSubscription(String subscriptionId) throws BrokerException;

    Map<String,Term> getDnetTopics() throws BrokerException;

    EventsPage getNotificationsBySubscriptionId(String subscriptionId, String page, String size) throws BrokerException;
}
