package eu.dnetlib.repo.manager.client.services;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.repo.manager.shared.*;
import org.json.JSONException;

import java.util.List;
import java.util.Map;

/**
 * Created by stefania on 12/8/15.
 */
@RemoteServiceRelativePath("springGwtServices/repositoryService")
public interface RepositoryService extends RemoteService {

    Tuple<List<Repository>, List<Repository>> getRepositoriesByCountry(String country, String mode, boolean includeUnknownCountries) throws RepositoryServiceException;

    List<String> getRepositoryUrlsOfUser(String userEmail, boolean includeShared, boolean includeByOthers) throws RepositoryServiceException;

    Repository getRepository(String repoId) throws RepositoryServiceException;

    Map<String, String> getCountries(Boolean existingOnly, String mode) throws RepositoryServiceException;

    Map<String, String> getCountries() throws RepositoryServiceException;

    List<Timezone> getTimezones() throws RepositoryServiceException;

    List<String> getTypologies() throws RepositoryServiceException;

    Map<String, String> getDatasourceClasses(String mode) throws RepositoryServiceException;

    Map<String, String> getCompatibilityClasses(String mode) throws RepositoryServiceException;

    void storeRepository(Repository repo, String mode) throws RepositoryServiceException;

    void updateRepositoryInformation(Repository repo) throws RepositoryServiceException;

    RepositoryInterface updateInterface(RepositoryInterface iFace, String repoId, String datatype) throws RepositoryServiceException;

    RepositoryInterface insertInterface(RepositoryInterface iFace, String repoId, String datatype) throws RepositoryServiceException;

    void deleteInterface(String repoId, RepositoryInterface iFace, String datatype) throws RepositoryServiceException;

    void deleteInterfaces(String repoId, List<RepositoryInterface> iFaces, String datatype) throws RepositoryServiceException;

    DatasourceVocabularies getDatasourceVocabularies(String mode) throws RepositoryServiceException;

    List<Repository> getRepositoriesByCountry(String country, String mode) throws RepositoryServiceException;

    DatasourcesCollection getRepositoriesOfUser(String userEmail, boolean includeShared, boolean includeByOthers) throws RepositoryServiceException;

    String getLatestUpdateDateOfList(String mode) throws RepositoryServiceException;

    eu.dnetlib.domain.data.PiwikInfo getPiwikSiteForRepository(String repoId) throws RepositoryServiceException;

    void enableMetricsForRepository(Repository repository, UserProfile requestor) throws RepositoryServiceException;

    String getPiwikScriptForRepository(String repoId) throws RepositoryServiceException;

    List<PiwikInfo> getPiwikSitesForRepositories() throws RepositoryServiceException;

    void markPiwikSiteAsValidated(String repositoryId) throws RepositoryServiceException;

    MetricsInfo getMetricsInfoForRepository(String repoId) throws RepositoryServiceException;


    Aggregations getRepositoryAggregations(String repoId) throws Exception;
}
