package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.TokenController;

/**
 * Created by stefania on 2/10/16.
 */
public class RunCompatibilityTestController extends TokenController {

    private static RunCompatibilityTestController instance = null;
    private SelectRepositoryTypeWidget selectRepositoryTypeWidget = SelectRepositoryTypeWidget.getInstance();

    public static RunCompatibilityTestController getInstance() {
        if (instance == null)
            instance = new RunCompatibilityTestController();

        return instance;
    }

    private RunCompatibilityTestController() {
        this.subControllers.put("literature", LiteratureController.getInstance());
        this.subControllers.put("data", DataController.getInstance());
        this.subControllers.put("cris", CrisController.getInstance());
    }

    @Override
    public void showWidget(FlowPanel contentPanel, String parent, String rest) {

        if (rest == null)
            redrawWidget(contentPanel, selectRepositoryTypeWidget, parent, rest);
        else {
            super.showWidget(contentPanel, parent, rest);
        }
    }

//    @Override
//    public void drawHeader(String token) {
//
//        RootPanel.get("pageHeader").addStyleName("row wrapper border-bottom white-bg page-heading");
//        if (token == null) {
//            RepositoryManager.pageHeader.clear();
//            RepositoryManager.pageHeader.add(new HTML("<div class=\"col-sm-9\"><h2>Validate your datasource</h2><ol class=\"breadcrumb\">" +
//                    "<li><a href=\"#dashboard\">Home</a></li><li class=\"active\"><strong>Run Compatibility Test</strong></li></ol></div>"));
//        } else {
//            super.drawHeader(token);
//        }
//    }

    @Override
    public String[] getMenuPath(String parent, String rest) {
        return new String[] {"validate"};
    }
}
