package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.*;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import eu.dnetlib.repo.manager.shared.Triple;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.RadioButton;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;

import java.util.List;

/**
 * Created by stefania on 2/18/16.
 */
public class SelectParametersWidget implements IsWidget {

    private FlowPanel selectParametersWidgetPanel = new FlowPanel();

    private Alert errorLabel = new Alert();

    private FlowPanel recordsPanel = new FlowPanel();
    private HTML recordsLabel = new HTML();
    private Form recordsForm = new Form();
    private RadioButton allRecordsRadio = new RadioButton("records", "All", false);
    private RadioButton customRecordsRadio = new RadioButton("records", "Custom", false);
    private TextBox customRecordsTextBox = new TextBox();

    private FlowPanel setsPanel = new FlowPanel();
    private HTML setsLabel = new HTML();
    private Form setsForm = new Form();
    private ListBox setsListBox = new ListBox();

    private FlowPanel xPathPanel = new FlowPanel();
    private HTML xPathLabel = new HTML();
    private Form xPathForm = new Form();
    private RadioButton noXPathRadio = new RadioButton("xPath", "No", false);
    private RadioButton yesXPathRadio = new RadioButton("xPath", "Yes", false);
    private TextBox xPathTextBox = new TextBox();
    private HTML xPathComment = new HTML();

    public SelectParametersWidget() {

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setDismissable(false);
        errorLabel.setVisible(false);

        selectParametersWidgetPanel.add(errorLabel);
        selectParametersWidgetPanel.add(recordsPanel);
        selectParametersWidgetPanel.add(setsPanel);
        selectParametersWidgetPanel.add(xPathPanel);

        selectParametersWidgetPanel.addStyleName("uk-margin-top");

        // RECORDS
        recordsLabel.setHTML("<label>Number of records to validate</label>");

        recordsPanel.addStyleName("marginBottom20");
        recordsPanel.add(recordsLabel);
        recordsPanel.add(recordsForm);

        recordsForm.addStyleName("uk-margin uk-grid");

        allRecordsRadio.setType(ButtonType.LINK);
        allRecordsRadio.setValue(true);
        allRecordsRadio.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                if(allRecordsRadio.getValue())
                    customRecordsTextBox.setEnabled(false);
            }
        });
        FlowPanel allRecordsRadioWrapper = new FlowPanel();
        allRecordsRadioWrapper.addStyleName("uk-width-1-4@s");
        allRecordsRadioWrapper.add(allRecordsRadio);
        recordsForm.add(allRecordsRadioWrapper);

        customRecordsRadio.setType(ButtonType.LINK);
        customRecordsRadio.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                if(customRecordsRadio.getValue())
                    customRecordsTextBox.setEnabled(true);
            }
        });
        FlowPanel customRecordsRadioWrapper = new FlowPanel();
        customRecordsRadioWrapper.addStyleName("uk-width-1-4@s");
        customRecordsRadioWrapper.add(customRecordsRadio);
        recordsForm.add(customRecordsRadioWrapper);

        customRecordsTextBox.setValue("10");
        customRecordsTextBox.setEnabled(false);
        FlowPanel customRecordsTextBoxWrapper = new FlowPanel();
        customRecordsTextBoxWrapper.addStyleName("uk-width-1-2@s");
        customRecordsTextBoxWrapper.add(customRecordsTextBox);
        recordsForm.add(customRecordsTextBoxWrapper);

        // VALIDATION SET
        setsLabel.setHTML("<label>Validation Set</label>");

        setsPanel.addStyleName("marginBottom20");
        setsPanel.add(setsLabel);
        setsPanel.add(setsForm);

        setsListBox.addItem("All Sets", "all");
        setsForm.add(setsListBox);

        // XPATH
        xPathLabel.setHTML("<label>Would you like to group your results by a specific field?</label>");

        xPathPanel.addStyleName("xPathPanel marginBottom20");
        xPathPanel.add(xPathLabel);
        xPathPanel.add(xPathForm);
        xPathPanel.add(xPathComment);

        xPathForm.addStyleName("uk-grid");

        noXPathRadio.setType(ButtonType.LINK);
        noXPathRadio.setValue(true);
        noXPathRadio.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                if(noXPathRadio.getValue())
                    xPathTextBox.setEnabled(false);
            }
        });
        FlowPanel noXPathRadioWrapper = new FlowPanel();
        noXPathRadioWrapper.addStyleName("uk-width-1-4@s");
        noXPathRadioWrapper.add(noXPathRadio);
        xPathForm.add(noXPathRadioWrapper);

        yesXPathRadio.setType(ButtonType.LINK);
        yesXPathRadio.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                if(yesXPathRadio.getValue())
                    xPathTextBox.setEnabled(true);
            }
        });
        FlowPanel yesXPathRadioWrapper = new FlowPanel();
        yesXPathRadioWrapper.addStyleName("uk-width-1-4@s");
        yesXPathRadioWrapper.add(yesXPathRadio);
        xPathForm.add(yesXPathRadioWrapper);

        xPathTextBox.setPlaceholder("-XPATH-");
        xPathTextBox.setEnabled(false);
        FlowPanel xPathTextBoxWrapper = new FlowPanel();
        xPathTextBoxWrapper.addStyleName("uk-width-1-2@s");
        xPathTextBoxWrapper.add(xPathTextBox);
        xPathForm.add(xPathTextBoxWrapper);

        xPathComment.setHTML("<strong>XPath Examples:</strong> 1. //header/setSpec 2. //record/metadata//*[name()='dc:language'] ");
        xPathComment.addStyleName("comment fontItalic marginTop10");
    }

    @Override
    public Widget asWidget() {
        return selectParametersWidgetPanel;
    }

    public void loadSets(List<String> sets) {
        for(String set : sets)
            setsListBox.addItem(set, set);
    }

    public Triple<Integer, String, String> getParameters() {

        errorLabel.setVisible(false);

        Triple<Integer, String, String> parameters = new Triple<Integer, String, String>();

        if(allRecordsRadio.getValue())
            parameters.setFirst(-1);
        else {
            if(isPositiveInteger(customRecordsTextBox.getValue().trim()))
                parameters.setFirst(Integer.parseInt(customRecordsTextBox.getValue().trim()));
            else {
                errorLabel.setText("Number of records must be a positive integer");
                errorLabel.setVisible(true);
                parameters.setFirst(null);
            }
        }

        if(setsListBox.getSelectedValue().equals("all"))
            parameters.setSecond("none");
        else
            parameters.setSecond(setsListBox.getSelectedValue());

        if(noXPathRadio.getValue())
            parameters.setThird(null);
        else {
            if(xPathTextBox.getValue()==null || xPathTextBox.getValue().trim().isEmpty())
                parameters.setThird(null);
            else
                parameters.setThird(xPathTextBox.getValue().trim());
        }

        return parameters;
    }

    private boolean isPositiveInteger(String value) {

        if(value.length()!=0) {

            try {

                int intValue = Integer.parseInt(value);
                return intValue>0;

            } catch (NumberFormatException nfe) {
                return false;
            }
        }

        return false;
    }
}
