package eu.dnetlib.repo.manager.client.validator.test.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardWidget;
import eu.dnetlib.repo.manager.shared.ValidationState;

import java.util.List;

/**
 * Created by stefania on 2/10/16.
 */
public class RunCompatibilityTestWizard extends WizardWidget {

    private ValidationServiceAsync validationService = GWT.create(ValidationService.class);

    public RunCompatibilityTestWizard(final List<WizardStepWidget> wizardStepWidgets) {

        super(wizardStepWidgets, new ValidationState(), "Run compatibility test");

        for(WizardStepWidget wizardStepWidget : wizardStepWidgets) {

            WizardStepWidget.WizardStepCompletedListener wizardStepCompletedListener =
                    new WizardStepWidget.WizardStepCompletedListener() {

                        @Override
                        public void setStepCompleted() {

                            final ValidationState state = (ValidationState) wizardState;

                            wizardStepWidgets.get(currentActiveStep).updateState(state);

                            if(newActiveStep == wizardStepWidgets.size()-1) {

                                final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                                        "color: rgb(47, 64, 80); font-weight: bold;\">Starting validation test...</div>" +
                                        "<div class=\"whiteFilm\"></div>");
                                innerWizardContentPanel.addStyleName("loading-big");
                                innerWizardContentPanel.add(loadingWheel);

                                validationService.submitValidationJob(state.getJobForValidation(), new AsyncCallback<Void>() {

                                    @Override
                                    public void onFailure(Throwable caught) {

                                        innerWizardContentPanel.removeStyleName("loading-big");
                                        innerWizardContentPanel.remove(loadingWheel);

                                        errorLabel.setText("System error submitting validation job");
                                        errorLabel.setVisible(true);
                                    }

                                    @Override
                                    public void onSuccess(Void result) {

                                        innerWizardContentPanel.removeStyleName("loading-big");
                                        innerWizardContentPanel.remove(loadingWheel);

                                        setActiveStep(newActiveStep);
                                    }
                                });

                            } else {
                                if (newActiveStep < wizardStepWidgets.size())
                                    setActiveStep(newActiveStep);
                            }
                        }
                    };
            wizardStepWidget.setWizardStepCompletedListener(wizardStepCompletedListener);
        }
    }
}
