package eu.dnetlib.repo.manager.client.validator.test.wizard;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.repo.manager.client.validator.test.SelectCrisParametersWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.shared.ValidationState;
import eu.dnetlib.repo.manager.shared.WizardState;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by stefania on 3/8/16.
 */
public class SelectCrisParametersStepWidget extends WizardStepWidget {

    private FlowPanel selectParametersStepPanel = new FlowPanel();

    private Alert errorAlert = new Alert();

    private SelectCrisParametersWidget selectCrisParametersWidget;

    public SelectCrisParametersStepWidget(String id, String title, String mode) {

        super(id, title, mode);

        errorAlert.addStyleName("stepContent");
        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);

        selectParametersStepPanel.add(errorAlert);

//        selectParametersStepPanel.addStyleName("animated fadeInRight stepContent");

        List<String> crisEntities = new ArrayList<String>();
        crisEntities.add("Funding");
        crisEntities.add("Organisation");
        crisEntities.add("Person");
        crisEntities.add("Project");
        crisEntities.add("Publication");
        crisEntities.add("Product");
        crisEntities.add("Service");

        selectCrisParametersWidget = new SelectCrisParametersWidget(crisEntities);
        selectParametersStepPanel.add(selectCrisParametersWidget.asWidget());
    }

    @Override
    public void clear() {

    }

    @Override
    public void updateState(WizardState wizardState) {

        ValidationState validationState = (ValidationState) wizardState;
        JobForValidation jobForValidation = validationState.getJobForValidation();

        jobForValidation.setCrisReferentialChecks(selectCrisParametersWidget.getParameters().getSecond());
        jobForValidation.setRecords(-1);
        jobForValidation.setValidationSet("none");
        jobForValidation.setSelectedCrisEntities(selectCrisParametersWidget.getParameters().getFirst());
    }

    @Override
    public void loadContent(WizardState wizardState) {

    }

    @Override
    public void completeStep() {

        if(selectCrisParametersWidget !=null && selectCrisParametersWidget.getParameters()!=null
                && selectCrisParametersWidget.getParameters().getFirst()!=null) {

            if(getWizardStepCompletedListener()!=null)
                getWizardStepCompletedListener().setStepCompleted();
        }
    }

    @Override
    public Widget asWidget() {
        return selectParametersStepPanel;
    }
}
