package eu.dnetlib.repo.manager.client.validator.test.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import eu.dnetlib.repo.manager.client.validator.test.SelectGuidelinesWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.shared.ValidationState;
import eu.dnetlib.repo.manager.shared.WizardState;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.List;

/**
 * Created by stefania on 2/12/16.
 */
public class SelectGuidelinesStepWidget extends WizardStepWidget {

    private FlowPanel selectGuidelinesStepPanel = new FlowPanel();

    private Alert errorAlert = new Alert();

    private SelectGuidelinesWidget selectGuidelinesWidget;

    private ValidationServiceAsync validationService = GWT.create(ValidationService.class);

    public SelectGuidelinesStepWidget(String id, String title, String mode) {

        super(id, title, mode);

        errorAlert.addStyleName("stepContent");
        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);

        selectGuidelinesStepPanel.add(errorAlert);

//        selectGuidelinesStepPanel.addStyleName("animated fadeInRight stepContent");

        validationService.getRuleSets(mode, new AsyncCallback<List<RuleSet>>() {

            @Override
            public void onFailure(Throwable caught) {

                errorAlert.setText("System error retrieving rule sets");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(List<RuleSet> ruleSets) {

                selectGuidelinesWidget = new SelectGuidelinesWidget(ruleSets);
                selectGuidelinesStepPanel.add(selectGuidelinesWidget.asWidget());
            }
        });
    }

    @Override
    public void clear() {

    }

    @Override
    public void updateState(WizardState wizardState) {

        ValidationState validationState = (ValidationState) wizardState;
        JobForValidation jobForValidation = validationState.getJobForValidation();

        jobForValidation.setDesiredCompatibilityLevel(selectGuidelinesWidget.getDesiredCompatibilityLevel());
        jobForValidation.setSelectedContentRules(selectGuidelinesWidget.getSelectedRules().getFirst());
        jobForValidation.setSelectedUsageRules(selectGuidelinesWidget.getSelectedRules().getSecond());
    }

    @Override
    public void loadContent(WizardState wizardState) {

    }

    @Override
    public void completeStep() {

        if(selectGuidelinesWidget!=null &&
                (!selectGuidelinesWidget.getSelectedRules().getFirst().isEmpty()
                        || !selectGuidelinesWidget.getSelectedRules().getSecond().isEmpty())) {

            if(getWizardStepCompletedListener()!=null)
                getWizardStepCompletedListener().setStepCompleted();

        }
    }

    @Override
    public Widget asWidget() {
        return selectGuidelinesStepPanel;
    }
}
