package eu.dnetlib.repo.manager.client.validator.test.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import eu.dnetlib.repo.manager.client.validator.test.SelectParametersWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.shared.ValidationState;
import eu.dnetlib.repo.manager.shared.WizardState;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.List;

/**
 * Created by stefania on 2/18/16.
 */
public class SelectParametersStepWidget extends WizardStepWidget {

    private FlowPanel selectParametersStepPanel = new FlowPanel();

    private Alert errorAlert = new Alert();

    private SelectParametersWidget selectParametersWidget = new SelectParametersWidget();

    private ValidationServiceAsync validationService = GWT.create(ValidationService.class);

    public SelectParametersStepWidget(String id, String title, String mode) {

        super(id, title, mode);

        errorAlert.addStyleName("stepContent");
        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);

        selectParametersStepPanel.add(errorAlert);

//        selectParametersStepPanel.addStyleName("animated fadeInRight stepContent");
        selectParametersStepPanel.add(selectParametersWidget.asWidget());
    }

    @Override
    public void clear() {

    }

    @Override
    public void updateState(WizardState wizardState) {

        ValidationState validationState = (ValidationState) wizardState;
        JobForValidation jobForValidation = validationState.getJobForValidation();

        jobForValidation.setValidationSet(selectParametersWidget.getParameters().getSecond());
        jobForValidation.setRecords(selectParametersWidget.getParameters().getFirst());
        jobForValidation.setGroupByXpath(selectParametersWidget.getParameters().getThird());
    }

    @Override
    public void loadContent(WizardState wizardState) {

        ValidationState validationState = (ValidationState) wizardState;

        validationService.getSets(validationState.getJobForValidation().getBaseUrl(), new AsyncCallback<List<String>>() {

            @Override
            public void onFailure(Throwable caught) {
                errorAlert.setText("System error retrieving sets");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(List<String> sets) {
                selectParametersWidget.loadSets(sets);
            }
        });
    }

    @Override
    public void completeStep() {

        if(selectParametersWidget!=null && selectParametersWidget.getParameters()!=null
                && selectParametersWidget.getParameters().getFirst()!=null) {

            if(getWizardStepCompletedListener()!=null)
                getWizardStepCompletedListener().setStepCompleted();
        }
    }

    @Override
    public Widget asWidget() {
        return selectParametersStepPanel;
    }
}
