package eu.dnetlib.repo.manager.client.validator.test.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import eu.dnetlib.repo.manager.client.validator.test.SelectRepositoryOrJournalWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.shared.Constants;
import eu.dnetlib.repo.manager.shared.ValidationState;
import eu.dnetlib.repo.manager.shared.WizardState;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.List;

/**
 * Created by stefania on 2/10/16.
 */
public class SelectRepositoryOrJournalStepWidget extends WizardStepWidget {

    private FlowPanel selectRepositoryOrJournalStepPanel = new FlowPanel();

    private Alert errorAlert = new Alert();

    private SelectRepositoryOrJournalWidget selectRepositoryOrJournalWidget;

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);
    private ValidationServiceAsync validationService = GWT.create(ValidationService.class);

    public SelectRepositoryOrJournalStepWidget(String id, String title, String mode) {

        super(id, title, mode);

        errorAlert.addStyleName("stepContent");
        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);

        selectRepositoryOrJournalStepPanel.add(errorAlert);

//        selectRepositoryOrJournalStepPanel.addStyleName("animated fadeInRight stepContent");

        repositoryService.getRepositoryUrlsOfUser(RepositoryManager.currentUser.getEmail(), false, false,
                new AsyncCallback<List<String>>() {

            @Override
            public void onFailure(Throwable caught) {

                errorAlert.setText("System error retrieving repository urls");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(List<String> repositoryURLs) {

                selectRepositoryOrJournalWidget = new SelectRepositoryOrJournalWidget(repositoryURLs);
                selectRepositoryOrJournalStepPanel.add(selectRepositoryOrJournalWidget.asWidget());
            }
        });
    }

    @Override
    public void clear() {

    }

    @Override
    public void updateState(WizardState wizardState) {

        ValidationState validationState = (ValidationState) wizardState;
        JobForValidation jobForValidation = validationState.getJobForValidation();

        jobForValidation.setBaseUrl(selectRepositoryOrJournalWidget.getSelectedBaseURL());

        if(this.getMode().equals(Constants.VALIDATION_MODE_CRIS))
            jobForValidation.setCris(true);
        else
            jobForValidation.setCris(false);


        jobForValidation.setUserEmail(RepositoryManager.currentUser.getEmail());
        jobForValidation.setRegistration(false);
    }

    @Override
    public void loadContent(WizardState wizardState) {

    }

    @Override
    public void completeStep() {

        errorAlert.setVisible(false);

        if(selectRepositoryOrJournalWidget!=null && selectRepositoryOrJournalWidget.getSelectedBaseURL()!=null) {

            final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                    "color: rgb(47, 64, 80); font-weight: bold;\">Identifying base URL...</div>" +
                    "<div class=\"whiteFilm\"></div>");
            selectRepositoryOrJournalStepPanel.addStyleName("loading");
            selectRepositoryOrJournalStepPanel.add(loadingWheel);

            validationService.identifyRepository(selectRepositoryOrJournalWidget.getSelectedBaseURL(), new AsyncCallback<Boolean>() {

                @Override
                public void onFailure(Throwable caught) {

                    selectRepositoryOrJournalStepPanel.removeStyleName("loading");
                    selectRepositoryOrJournalStepPanel.remove(loadingWheel);

                    errorAlert.setText("System error identifying base url");
                    errorAlert.setVisible(true);
                }

                @Override
                public void onSuccess(Boolean result) {

                    selectRepositoryOrJournalStepPanel.removeStyleName("loading");
                    selectRepositoryOrJournalStepPanel.remove(loadingWheel);

                    if(result) {
                        if (getWizardStepCompletedListener() != null)
                            getWizardStepCompletedListener().setStepCompleted();
                    } else {
                        errorAlert.setText("System error identifying base url");
                        errorAlert.setVisible(true);
                    }
                }
            });
        }
    }

    @Override
    public Widget asWidget() {
        return selectRepositoryOrJournalStepPanel;
    }
}
