package eu.dnetlib.repo.manager.client.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.repo.manager.shared.DatasourcesCollection;
import org.gwtbootstrap3.client.ui.Anchor;

/**
 * Created by stefania on 12/15/16.
 */
public class ListOrGridViewOfDatasourcesWidget implements IsWidget {

    private FlowPanel listOrGridViewOfDatasourcesPanel = new FlowPanel();

    private String parentToken;
    private String icon;

    private boolean showPiwikInfo;

    public ListOrGridViewOfDatasourcesWidget(DatasourcesCollection datasourcesCollection, String title,
                                             String parentToken, String icon, boolean showPiwikInfo) {

        this.parentToken = parentToken;
        this.icon = icon;
        this.showPiwikInfo = showPiwikInfo;

        listOrGridViewOfDatasourcesPanel.addStyleName("uk-width-1-1 uk-grid");

        FlowPanel titlePanel = new FlowPanel();
        titlePanel.addStyleName("uk-width-1-1 uk-first-column uk-margin-bottom");
        listOrGridViewOfDatasourcesPanel.add(titlePanel);

        //CONTENT

        final FlowPanel contentPanel = new FlowPanel();
        contentPanel.addStyleName("uk-width-1-1");
        listOrGridViewOfDatasourcesPanel.add(contentPanel);

        final FlowPanel reposList = new FlowPanel();
        createReposList(datasourcesCollection, reposList);

        final FlowPanel reposGrid = new FlowPanel();
        createReposGrid(datasourcesCollection, reposGrid);
        contentPanel.add(reposGrid);

        // TITLE

        FlowPanel showOptions = new FlowPanel();
        showOptions.addStyleName("uk-float-right");
        titlePanel.add(showOptions);

        final Anchor gridView = new Anchor();
        final Anchor listView = new Anchor();

        gridView.addStyleName("grid-view active");
        gridView.setHTML("<i class=\"fa fa-th\"></i>");
        gridView.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                listView.removeStyleName("active");
                gridView.addStyleName("active");
                contentPanel.clear();
                contentPanel.add(reposGrid);
            }
        });
        showOptions.add(gridView);

        listView.addStyleName("grid-view");
        listView.setHTML("<i class=\"fa fa-th-list\"></i>");
        listView.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                gridView.removeStyleName("active");
                listView.addStyleName("active");
                contentPanel.clear();
                contentPanel.add(reposList);
            }
        });
        showOptions.add(listView);

//        HTML titleElement = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium uk-heading-line\" " +
//                "uk-scrollspy-class=\"\" data-id=\"page#30\" style=\"\"><span>" + title + "</span></h4>");
//        HTML titleElement = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"" +
//                "uk-scrollspy-class=\"\"><span>  " + "</span></h4>");
//        titleElement.addStyleName("m-b-md");
//        titlePanel.add(titleElement);
    }

    @Override
    public Widget asWidget() {
        return listOrGridViewOfDatasourcesPanel;
    }

    private void createReposList(DatasourcesCollection datasourcesCollection, FlowPanel reposList) {

        reposList.addStyleName("uk-grid-margin uk-grid uk-grid-stack repos-list");

        if(datasourcesCollection.getDatasourcesOfUser().isEmpty()) {

            reposList.add(new HTML("No Datasources are registered under your account"));

        } else {

            FlowPanel colPanel = new FlowPanel();
            colPanel.addStyleName("uk-width-1-1@m uk-first-column");
            reposList.add(colPanel);

            FlowPanel divPanel = new FlowPanel();
            divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
            colPanel.add(divPanel);

            String content = "<table class=\"uk-table uk-table-striped uk-table-middle\">" +
                    "<thead><tr><th>Logo</th><th class=\"uk-text-nowrap\">Name</th>";

            if(this.showPiwikInfo) {
                content += "<th class=\"uk-text-nowrap\">Status</th>";
            }

//            content += "<th class=\"uk-text-nowrap\">Actions</th>" ;
            content += "</tr></thead>";

            content += "<tbody>";

            for(final Repository repository : datasourcesCollection.getDatasourcesOfUser()) {

                content += "<tr class=\"el-item\">" +
                        "<td class=\"uk-table-shrink\">" +
                        "<a href=\"#" + parentToken + "/" + repository.getId() + "\" class=\"el-link\">";

                if(repository.getLogoUrl()==null || repository.getLogoUrl().trim().isEmpty())
                    content += "<img src=\"img/yourLogoHere.jpg\" alt=\"[Repo Logo]\" class=\"el-image uk-preserve-width\" style=\"height: 45px\">";
                else
                    content += "<img src=\"" + repository.getLogoUrl() + "\" alt=\"[Repo Logo]\" class=\"el-image uk-preserve-width\" style=\"height: 45px\">";

                content += "</a></td>" +
                        "<td class=\"uk-text-nowrap uk-table-shrink\">" +
                        "<a href=\"#" + parentToken + "/" + repository.getId() + "\" class=\"el-link\">" +
                        "<div class=\"el-title\">" + repository.getOfficialName() + "</div>" +
                        "</a></td>";

                if(this.showPiwikInfo) {
                    content += "<td class=\"uk-text-nowrap uk-table-shrink\">" +
                    "<a href=\"#" + parentToken + "/" + repository.getId() + "\" class=\"el-link\">";
                    if (repository.getPiwikInfo() == null)
                        content += "<div class=\"uk-badge uk-badge-danger\">not enabled</div>";
                    else if (!repository.getPiwikInfo().isValidated())
                        content += "<div class=\"uk-badge uk-badge-warning\">enabling in progress</div>";
                    else
                        content += "<div class=\"uk-badge uk-badge-success\">enabled</div>";

                    content += "</a></td>";
                }

//                content += "<td class=\"uk-text-nowrap uk-table-shrink\">" +
//                        "<a href=\"#" + parentToken + "/" + repository.getId() + "\" class=\"el-link\">" + icon + "</a>" +
//                        "</td>" +
//                        "</tr>";

                content += "</tr>";
            }

            content += "</tbody></table>";

            HTML reposListHTML = new HTML();
            reposListHTML.setHTML(content);

            divPanel.add(reposListHTML);
        }
    }

    private void createReposGrid(DatasourcesCollection datasourcesCollection, FlowPanel reposGrid) {

        reposGrid.addStyleName("uk-grid-large uk-grid-margin-large uk-grid repos-grid");

        if(datasourcesCollection.getDatasourcesOfUser().isEmpty()) {

            reposGrid.add(new HTML("No Datasources are registered under your account"));

        } else {

            if(datasourcesCollection.getDatasourcesOfUser().size()==1) {

                FlowPanel colPanel = new FlowPanel();
                colPanel.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel);

                FlowPanel divPanel = new FlowPanel();
                divPanel.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel.add(divPanel);

                divPanel.add(createGridItemForRepo(datasourcesCollection.getDatasourcesOfUser().get(0), false));

            } else if(datasourcesCollection.getDatasourcesOfUser().size()==2) {

                FlowPanel colPanel1 = new FlowPanel();
                colPanel1.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel1);

                FlowPanel divPanel1 = new FlowPanel();
                divPanel1.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel1.add(divPanel1);

                divPanel1.add(createGridItemForRepo(datasourcesCollection.getDatasourcesOfUser().get(0), false));

                FlowPanel colPanel2 = new FlowPanel();
                colPanel2.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel2);

                FlowPanel divPanel2 = new FlowPanel();
                divPanel2.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel2.add(divPanel2);

                divPanel2.add(createGridItemForRepo(datasourcesCollection.getDatasourcesOfUser().get(1), false));

            } else {

                FlowPanel colPanel1 = new FlowPanel();
                colPanel1.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel1);

                FlowPanel divPanel1 = new FlowPanel();
                divPanel1.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel1.add(divPanel1);

                FlowPanel colPanel2 = new FlowPanel();
                colPanel2.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel2);

                FlowPanel divPanel2 = new FlowPanel();
                divPanel2.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel2.add(divPanel2);

                FlowPanel colPanel3 = new FlowPanel();
                colPanel3.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel3);

                FlowPanel divPanel3 = new FlowPanel();
                divPanel3.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel3.add(divPanel3);

                for(int i=0; i<datasourcesCollection.getDatasourcesOfUser().size(); i++) {

                    boolean addExtraClass = false;
                    if(i>2)
                        addExtraClass = true;

                    if(i%3 == 0)
                        divPanel1.add(createGridItemForRepo(datasourcesCollection.getDatasourcesOfUser().get(i), addExtraClass));
                    else if(i%3 == 1)
                        divPanel2.add(createGridItemForRepo(datasourcesCollection.getDatasourcesOfUser().get(i), addExtraClass));
                    else
                        divPanel3.add(createGridItemForRepo(datasourcesCollection.getDatasourcesOfUser().get(i), addExtraClass));
                }

            }
        }
    }

    private FlowPanel createGridItemForRepo(Repository repository, boolean addExtraClass) {

        FlowPanel gridItem = new FlowPanel();
        if(addExtraClass)
            gridItem.addStyleName("uk-grid-margin uk-first-column");
        else
            gridItem.addStyleName("uk-first-column");


        String gridItemContent = "<a href=\"#" + parentToken + "/" + repository.getId() + "\" class=\"el-link\">";

        gridItemContent += "<div uk-scrollspy-class=\"\" class=\"el-item uk-panel uk-scrollspy-inview uk-animation-slide-top-medium\" style=\"\">" +
                "<div class=\"uk-child-width-expand uk-grid-medium uk-flex-middle uk-grid\" uk-grid=\"\">";


        gridItemContent += "<div class=\"uk-width-1-3@m uk-first-column\">";

        if(repository.getLogoUrl()==null || repository.getLogoUrl().trim().isEmpty())
            gridItemContent += "<img src=\"img/yourLogoHere.jpg\" class=\"el-image uk-border-rounded\" alt=\"\">";
        else
            gridItemContent += "<img src=\"" + repository.getLogoUrl() + "\" class=\"el-image uk-border-rounded\" alt=\"\">";

        gridItemContent += "</div>";

        gridItemContent += "<div><h3 class=\"el-title uk-margin uk-h5 uk-margin-remove-adjacent uk-margin-small-bottom\">" + repository.getOfficialName()+ "</h3>";

        if(this.showPiwikInfo) {
            if (repository.getPiwikInfo() == null)
                gridItemContent += "<div class=\"uk-badge uk-badge-danger\">not enabled</div>";
            else if (!repository.getPiwikInfo().isValidated())
                gridItemContent += "<div class=\"uk-badge uk-badge-warning\">enabling in progress</div>";
            else
                gridItemContent += "<div class=\"uk-badge uk-badge-success\">enabled</div>";
        }

        gridItemContent += "</div>";

        gridItemContent += "</div></div></a>";

        gridItem.add(new HTML(gridItemContent));

        return gridItem;
    }
}
