package eu.dnetlib.repo.manager.client.widgets;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;

/**
 * Created by stefania on 2/27/15.
 */
public class TextBox extends org.gwtbootstrap3.client.ui.TextBox implements ValueChangeCancelField {

    private String oldValue = "";
    private ValueChangeHandler handler = null;

    public TextBox() {
        super();
        sinkEvents(Event.ONPASTE | Event.ONKEYUP);
    }

    @Override
    public void onBrowserEvent(Event event) {

        super.onBrowserEvent(event);

        switch (event.getTypeInt()) {
            case Event.ONPASTE:
            case Event.ONKEYUP:

                Timer t = new Timer() {

                    @Override
                    public void run() {
                        if (handler != null) {
                            ValueChangeEvent valueChangeEvent = new ValueChangeEvent(TextBox.this, getId(), oldValue, getText());

                            handler.handle(valueChangeEvent);

                            oldValue = getText();
                        }
                    }
                };
                t.schedule(0);

                break;
            default:
        }
    }

    @Override
    public void cancel() {
        this.setText(oldValue);
//        focus();
    }

    public void setValueChangeHandler(ValueChangeHandler handler) {
        this.handler = handler;
    }
}
