package eu.dnetlib.repo.manager.client.widgets.wizard;

import com.google.gwt.user.client.ui.IsWidget;
import eu.dnetlib.repo.manager.shared.WizardState;

/**
 * Created by stefania on 12/17/15.
 */
public abstract class WizardStepWidget implements IsWidget {

    private String id;
    private String title;
    private String mode;

    private WizardStepCompletedListener wizardStepCompletedListener;

    public WizardStepWidget(String id, String title, String mode) {
        this.id = id;
        this.title = title;
        this.mode = mode;
    }

    public String getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }

    public String getMode() {
        return mode;
    }

    public abstract void clear();

    public abstract void updateState(WizardState wizardState);

    public abstract void loadContent(WizardState wizardState);

    public abstract void completeStep();

    public interface WizardStepCompletedListener {
        void setStepCompleted();
    }

    public WizardStepCompletedListener getWizardStepCompletedListener() {
        return wizardStepCompletedListener;
    }

    public void setWizardStepCompletedListener(WizardStepCompletedListener wizardStepCompletedListener) {
        this.wizardStepCompletedListener = wizardStepCompletedListener;
    }
}
