package eu.dnetlib.repo.manager.client.widgets.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.shared.WizardState;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by stefania on 12/17/15.
 */
public class WizardWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String token = "";

    private FlowPanel wizardPanel = new FlowPanel();

    protected Alert errorLabel = new Alert();

    private BreadcrumbWidget breadcrumbWidget;
    private FlowPanel wizardStepPanel = new FlowPanel();
    protected FlowPanel innerWizardContentPanel = new FlowPanel();
    private NavigationWidget navigationWidget = new NavigationWidget();

    private List<WizardStepWidget> wizardStepWidgets = new ArrayList<WizardStepWidget>();
    protected WizardState wizardState;

    protected int currentActiveStep = 0;
    protected int newActiveStep = 0;

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    protected WizardWidget(final List<WizardStepWidget> wizardStepWidgets, WizardState wizardState, String title) {

        this.wizardState = wizardState;

        HTML titleHTML = new HTML("<h1 class=\"uk-article-title\">" + title + "</h1>");
        titleHTML.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(titleHTML);

//        errorLabel.addStyleName("alertLabel");
        errorLabel.setType(AlertType.DANGER);
        errorLabel.setVisible(false);
        errorLabel.setDismissable(false);

        this.wizardStepWidgets.addAll(wizardStepWidgets);
        final List<String> wizardStepNames = new ArrayList<String>();
        for(WizardStepWidget wizardStepWidget : wizardStepWidgets) {
            wizardStepNames.add(wizardStepWidget.getTitle());
        }

        breadcrumbWidget = new BreadcrumbWidget(wizardStepNames);

        wizardPanel.addStyleName("wizard");
        wizardPanel.add(breadcrumbWidget.asWidget());
        wizardPanel.add(wizardStepPanel);
        wizardPanel.add(navigationWidget.asWidget());

        contentPanel.add(wizardPanel);

        wizardStepPanel.addStyleName("content");
        wizardStepPanel.add(errorLabel);
        wizardStepPanel.add(innerWizardContentPanel);

        NavigationWidget.NextButtonListener nextButtonListener =
                new NavigationWidget.NextButtonListener() {

            @Override
            public void nextClicked(int newActiveStep) {

                errorLabel.setVisible(false);

                WizardWidget.this.newActiveStep = newActiveStep;
                Window.scrollTo(0, 0);
                wizardStepWidgets.get(currentActiveStep).completeStep();
            }
        };
        navigationWidget.setNextButtonListener(nextButtonListener);

        NavigationWidget.BackButtonListener backButtonListener =
                new NavigationWidget.BackButtonListener() {
            @Override
            public void backClicked(int newActiveStep) {

                errorLabel.setVisible(false);

                setActiveStep(newActiveStep);
            }
        };
        navigationWidget.setBackButtonListener(backButtonListener);
    }

    protected void setActiveStep(int stepNumber) {

        loadAppropriateHelp(wizardStepWidgets.get(stepNumber).getId());

        currentActiveStep = stepNumber;

        breadcrumbWidget.setActiveStep(stepNumber);
        navigationWidget.setActiveStep(stepNumber);

        if(stepNumber==wizardStepWidgets.size()-1)
            navigationWidget.hideNavigationButtons();

        if(stepNumber==wizardStepWidgets.size()-2) {
            navigationWidget.setNextButtonText("Finish");
        } else {
            navigationWidget.setNextButtonText("Next");
        }

        innerWizardContentPanel.clear();
        Window.scrollTo(0, 0);

        wizardStepWidgets.get(stepNumber).clear();
        wizardStepWidgets.get(stepNumber).loadContent(wizardState);

        innerWizardContentPanel.add(wizardStepWidgets.get(currentActiveStep).asWidget());
    }

    private void loadAppropriateHelp(String stepId) {

        gridPanel.remove(helpPanel);
        helpService.getHelpById(parentToken + "_" + stepId, new HelpCallback(helpPanel, gridPanel));
    }

    @Override
    public void clear() {

    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        setActiveStep(currentActiveStep);
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.token = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }
}
