package eu.dnetlib.repo.manager.server.services;

import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.repo.manager.service.controllers.PiWikApi;
import eu.dnetlib.utils.md5.MD5;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Created by stefania on 12/19/16.
 */
@Component(value = "piwikDAO")
public class PiwikDAO {

    @Autowired
    private PiWikApi piWikApi;

    public PiwikInfo getPiwikSiteForRepo(String repositoryId) {
        return piWikApi.getPiwikSiteForRepo(repositoryId);
    }

    public PiwikInfo savePiwikInfo(PiwikInfo piwikInfo) {
        return piWikApi.savePiwikInfo(piwikInfo);
    }

    public List<PiwikInfo> getPiwikSitesForRepos() {
        return piWikApi.getPiwikSitesForRepos();
    }


    public void markPiwikSiteAsValidated(String repositoryId) {
        piWikApi.approvePiwikSite(repositoryId);
    }

    private String getOpenaireId(String repositoryid) {
        return piWikApi.getOpenaireId(repositoryid);
    }
}