package eu.dnetlib.repo.manager.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RootPanel;
import eu.dnetlib.repo.manager.client.admin.AdminController;
import eu.dnetlib.repo.manager.client.browsehistory.BrowseHistoryController;
import eu.dnetlib.repo.manager.client.dashboard.DashboardController;
import eu.dnetlib.repo.manager.client.datasources.register.DatasourceRegisterController;
import eu.dnetlib.repo.manager.client.datasources.update.DatasourceUpdateController;
import eu.dnetlib.repo.manager.client.enrichcontent.EnrichContentController;
import eu.dnetlib.repo.manager.client.getimpact.GetImpactController;
import eu.dnetlib.repo.manager.client.admin.helptexts.HelpTextsAdminController;
import eu.dnetlib.repo.manager.client.monitor.MonitorController;
import eu.dnetlib.repo.manager.client.validator.test.RunCompatibilityTestController;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 12/17/15.
 */
public class RepositoryManagerController extends TokenController {

    private static RepositoryManagerController instance = null;
    private FlowPanel contentPanel = new FlowPanel();

    public static RepositoryManagerController getInstance() {
        if (instance == null)
            instance = new RepositoryManagerController();

        return instance;
    }

    public RepositoryManagerController() {

        subControllers.put("dashboard", DashboardController.getInstance());
        subControllers.put("registerDatasource", DatasourceRegisterController.getInstance());
        subControllers.put("manageDatasource", DatasourceUpdateController.getInstance());
        subControllers.put("validate", RunCompatibilityTestController.getInstance());
        subControllers.put("browseHistory", BrowseHistoryController.getInstance());
        subControllers.put("monitor", MonitorController.getInstance());
        subControllers.put("helpAdmin", HelpTextsAdminController.getInstance());
        subControllers.put("enrichContent", EnrichContentController.getInstance());
        subControllers.put("getImpact", GetImpactController.getInstance());
        subControllers.put("admin", AdminController.getInstance());

        RootPanel.get("contentWrapper").add(contentPanel);
    }

    public void showWidget(String rest) {

        TokenController subController = this.getSubController(rest);

        updateMenu(getMenuPath(null, rest));

//        subController.drawHeader(splitToken(rest)[1]);
        subController.showWidget(contentPanel, splitToken(rest)[0], splitToken(rest)[1]);
    }

    void updateMenu(final String[] path) {

        $(".menu_level_0").removeClass("active");
        $(".menu_level_1").removeClass("active");

        $(".menu_level_0").each(new Function() {
            @Override
            public void f(Element e) {
                if (!e.getId().equals(path[0]+"_li")) {
                    //TODO add collapsing when closing
                    if($("#" + e.getId() + " > ul")!=null)
                        $("#" + e.getId() + " > ul").removeClass("in");
                } else {
                    $("#" + e.getId()).addClass("active");
                    if($("#" + e.getId() + " > ul")!=null)
                        $("#" + e.getId() + " > ul").addClass("in");
                }
            }
        });

        if(path.length > 1)
            $("#" + path[0] + "_" + path[1] + "_li").addClass("active");
    }
}
