package eu.dnetlib.repo.manager.client.services;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.UserAccessException;

/**
 * Created by stefania on 12/4/15.
 */
@RemoteServiceRelativePath("springGwtServices/userService")
public interface UserService extends RemoteService {

    Tuple<UserProfile, String> login(String email, String password) throws UserAccessException;

    void register(UserProfile userProfile) throws UserAccessException;

    void activateUser(String activationId) throws UserAccessException;

    void updateUser(UserProfile userProfile) throws UserAccessException;

    Tuple<UserProfile, String> getUserByEmail(String email) throws UserAccessException;

    void prepareResetPassword(String email) throws UserAccessException;

    void resetPassword(String securityCode, String password) throws UserAccessException;

    void resendActivation(String email) throws UserAccessException;

}
