package eu.dnetlib.repo.manager.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.gwtbootstrap3.client.ui.constants.IconType;

/**
 * Created by stefania on 1/19/17.
 */
public class OpenAIRECompliantLogoDownloadWidget implements IsWidget {

    private FlowPanel openaireCompliantLogoDownload = new FlowPanel();

    public OpenAIRECompliantLogoDownloadWidget() {

        openaireCompliantLogoDownload.addStyleName("row openAIRECompliantLogoDownload");

        FlowPanel colLg12 = new FlowPanel();
        colLg12.addStyleName("col-lg-12");
        openaireCompliantLogoDownload.add(colLg12);

        FlowPanel colMd12 = new FlowPanel();
        colMd12.addStyleName("col-md-12");
        colLg12.add(colMd12);

        HTML openAIRECompliantLogo = new HTML("<div class=\"openAIRECompliantLogo\">" +
                "<h2 class=\"openAIRECompliantLogoMessage\">Congratulations! Your repository was successfully " +
                "registered in OpenAIRE. You can download this logo to use in your site.</h2>" +
                "<img src=\"./img/3.0 Validated Logo.png\" " +
                "alt=\"OpenAIRECompliant\"></div>");
        colMd12.add(openAIRECompliantLogo);

        Anchor download = new Anchor();
        download.setText("Download");
        download.setIcon(IconType.DOWNLOAD);
        download.setIconPosition(IconPosition.RIGHT);
        download.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                Window.open(GWT.getHostPageBaseURL() + "img/3.0 Validated Logo.png", "_blank", "enabledstatus=0,toolbar=0,menubar=0,location=0");
            }
        });
        colMd12.add(download);
    }

    @Override
    public Widget asWidget() {
        return openaireCompliantLogoDownload;
    }
}
