/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.datasources.utils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.datasources.utils.InterfaceFields;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import eu.dnetlib.repo.manager.client.widgets.ValueChangeHandler;
import java.util.HashMap;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.RadioButton;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;

public class InterfaceFields
implements IsWidget {
    private boolean isValid = true;
    private FlowPanel interfacePanel = new FlowPanel();
    private FlowPanel interfaceBoxPanel = new FlowPanel();
    private FlowPanel interfaceBoxContentPanel = new FlowPanel();
    private FlowPanel interfaceBoxTitlePanel = new FlowPanel();
    private HTML title = new HTML();
    private FlowPanel actionsPanel = new FlowPanel();
    private Anchor deleteIcon = new Anchor();
    private Anchor saveIcon = new Anchor();
    private Form interfaceForm = new Form();
    private Alert interfaceErrorAlert = new Alert();
    private Alert interfaceSuccessAlert = new Alert();
    private TextBox baseURL = new TextBox();
    private MyFormGroup baseURLFormGroup = new MyFormGroup(true, "Base OAI-PMH URL (*)", new Widget[]{this.baseURL});
    private RadioButton addACustomValidationSetRadio = new RadioButton("validationSet", "or a custom one", false);
    private TextBox validationSetTextBox = new TextBox();
    private RadioButton chooseExistingValidationSetRadio = new RadioButton("validationSet", "Choose existing", false);
    private ListBox existingValidationSetsListBox = new ListBox();
    private Map<String, Integer> existingValidationSetsValuesMap = new HashMap();
    private ListBox desiredCompatibilityLevelListBox = new ListBox();
    private MyFormGroup desiredCompatibilityLevelFormGroup = new MyFormGroup(false, "Desired Compatibility Level (*)", new Widget[]{this.desiredCompatibilityLevelListBox});
    private Map<String, Integer> desiredCompatibilityValuesMap = new HashMap();
    private HTML currentCompatibilityLevel = new HTML();
    private RepositoryInterface existingRepositoryInterface;
    private String repositoryId;
    private DeleteInterfaceListener deleteInterfaceListener;
    private ValidationServiceAsync validationService = (ValidationServiceAsync)GWT.create(ValidationService.class);
    private RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
    private String mode;
    private boolean isUpdate;

    public InterfaceFields(boolean hasSave, Map<String, String> compatibilityClasses, String mode, boolean isUpdate) {
        this.mode = mode;
        this.isUpdate = isUpdate;
        this.interfacePanel.add((Widget)this.interfaceBoxPanel);
        this.interfaceBoxPanel.addStyleName("el-item uk-card uk-card-default uk-card-body uk-scrollspy-inview uk-animation-fade");
        this.interfaceBoxPanel.add((Widget)this.interfaceBoxTitlePanel);
        this.interfaceBoxPanel.add((Widget)this.interfaceBoxContentPanel);
        this.interfaceBoxTitlePanel.add((Widget)this.title);
        this.interfaceBoxTitlePanel.add((Widget)this.actionsPanel);
        this.actionsPanel.addStyleName("interfaceActionsPanel");
        this.deleteIcon.setIcon(IconType.REMOVE);
        this.deleteIcon.setIconSize(IconSize.LARGE);
        this.deleteIcon.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.saveIcon.setIcon(IconType.SAVE);
        this.saveIcon.setIconSize(IconSize.LARGE);
        this.saveIcon.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (hasSave) {
            this.actionsPanel.add((Widget)this.saveIcon);
        }
        this.actionsPanel.add((Widget)this.deleteIcon);
        this.interfaceSuccessAlert.setType(AlertType.SUCCESS);
        this.interfaceSuccessAlert.setDismissable(false);
        this.interfaceSuccessAlert.setVisible(false);
        this.interfaceBoxContentPanel.add((Widget)this.interfaceSuccessAlert);
        this.interfaceErrorAlert.setType(AlertType.DANGER);
        this.interfaceErrorAlert.setDismissable(false);
        this.interfaceErrorAlert.setVisible(false);
        this.interfaceBoxContentPanel.add((Widget)this.interfaceErrorAlert);
        this.interfaceBoxContentPanel.add((Widget)this.interfaceForm);
        this.desiredCompatibilityLevelListBox.addItem("-- none selected --", "noneSelected");
        int counter = 1;
        for (String compatibility : compatibilityClasses.keySet()) {
            this.desiredCompatibilityLevelListBox.addItem(compatibilityClasses.get(compatibility), compatibility);
            this.desiredCompatibilityValuesMap.put(compatibility, counter);
            ++counter;
        }
        this.baseURL.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.interfaceForm.add((IsWidget)this.baseURLFormGroup);
        FlowPanel customValidationRadioPanel = new FlowPanel();
        this.addACustomValidationSetRadio.setType(ButtonType.LINK);
        this.addACustomValidationSetRadio.addStyleName("validationSetRadio");
        this.addACustomValidationSetRadio.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addACustomValidationSetRadio.setEnabled(false);
        customValidationRadioPanel.add((Widget)this.addACustomValidationSetRadio);
        this.validationSetTextBox.setEnabled(false);
        FlowPanel chooseExistingValidationRadioPanel = new FlowPanel();
        this.chooseExistingValidationSetRadio.setValue(Boolean.valueOf(true));
        this.chooseExistingValidationSetRadio.setType(ButtonType.LINK);
        this.chooseExistingValidationSetRadio.addStyleName("validationSetRadio");
        this.chooseExistingValidationSetRadio.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.chooseExistingValidationSetRadio.setEnabled(false);
        chooseExistingValidationRadioPanel.add((Widget)this.chooseExistingValidationSetRadio);
        this.existingValidationSetsListBox.addItem("-- none selected --", "noneSelected");
        this.existingValidationSetsListBox.setEnabled(false);
        this.interfaceForm.add((IsWidget)new MyFormGroup(false, "Validation Set", new Widget[]{chooseExistingValidationRadioPanel, this.existingValidationSetsListBox, customValidationRadioPanel, this.validationSetTextBox}));
        this.interfaceForm.add((IsWidget)this.desiredCompatibilityLevelFormGroup);
        this.currentCompatibilityLevel.setText("not available");
        this.interfaceForm.add((IsWidget)new MyFormGroup(false, "Current Compatibility Level", new Widget[]{this.currentCompatibilityLevel}));
        this.addValueChangeHandlersToFormFields();
    }

    public Widget asWidget() {
        return this.interfacePanel;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setDeleteInterfaceListener(DeleteInterfaceListener deleteInterfaceListener) {
        this.deleteInterfaceListener = deleteInterfaceListener;
    }

    public void loadRepositoryInterface(RepositoryInterface repositoryInterface, String repositoryId) {
        this.existingRepositoryInterface = repositoryInterface;
        this.repositoryId = repositoryId;
        if (repositoryInterface != null) {
            if (!repositoryInterface.isRemovable()) {
                if (this.mode.equals("opendoar")) {
                    this.title.setHTML("<h5>OpenDOAR Interface (non-removable)</h5>");
                } else if (this.mode.equals("re3data")) {
                    this.title.setHTML("<h5>Re3data Interface (non-removable)</h5>");
                }
                this.actionsPanel.remove((Widget)this.deleteIcon);
            }
            this.baseURL.setValue((Object)repositoryInterface.getBaseUrl());
            this.getInterfaceInformation(repositoryInterface.getAccessSet());
            if (repositoryInterface.getDesiredCompatibilityLevel() != null && !repositoryInterface.getDesiredCompatibilityLevel().equalsIgnoreCase("UNKNOWN")) {
                this.desiredCompatibilityLevelListBox.setSelectedIndex(((Integer)this.desiredCompatibilityValuesMap.get(repositoryInterface.getDesiredCompatibilityLevel())).intValue());
            }
            if (repositoryInterface.getComplianceName() != null && !repositoryInterface.getComplianceName().isEmpty()) {
                this.currentCompatibilityLevel.setText(repositoryInterface.getComplianceName());
            }
        }
        if (this.existingRepositoryInterface != null && this.existingRepositoryInterface.getId() != null) {
            this.baseURL.setEnabled(false);
            this.addACustomValidationSetRadio.setEnabled(false);
            this.chooseExistingValidationSetRadio.setEnabled(false);
            this.validationSetTextBox.setEnabled(false);
            this.existingValidationSetsListBox.setEnabled(false);
        }
    }

    private void saveInterface() {
        this.interfaceErrorAlert.setVisible(false);
        this.interfaceSuccessAlert.setVisible(false);
        RepositoryInterface repositoryInterface = this.getRepositoryInterface(false);
        if (repositoryInterface != null && this.isValid) {
            HTML loadingWheel = new HTML("<div class=\"loader-small\" style=\"text-align: center; padding-top: 35%; color: rgb(47, 64, 80); font-weight: bold;\">Saving interface information</div><div class=\"whiteFilm\"></div>");
            this.interfaceBoxContentPanel.addStyleName("loading");
            this.interfaceBoxContentPanel.add((Widget)loadingWheel);
            if (repositoryInterface.getId() == null) {
                this.repositoryService.insertInterface(repositoryInterface, this.repositoryId, this.mode, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.repositoryService.updateInterface(repositoryInterface, this.repositoryId, this.mode, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void getInterfaceInformation(String validationSet) {
        this.interfaceErrorAlert.setVisible(false);
        HTML loadingWheel = new HTML("<div class=\"loader-small\" style=\"text-align: center; padding-top: 35%; color: rgb(47, 64, 80); font-weight: bold;\">Fetching interface information</div><div class=\"whiteFilm\"></div>");
        this.interfaceBoxContentPanel.addStyleName("loading");
        this.interfaceBoxContentPanel.add((Widget)loadingWheel);
        this.validationService.getInterfaceInformation(this.baseURL.getValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public RepositoryInterface getRepositoryInterface(boolean forDeletion) {
        if (!forDeletion) {
            this.isValid = true;
            if (this.isEmpty()) {
                return null;
            }
            if (this.isComplete()) {
                if (this.existingRepositoryInterface == null) {
                    this.existingRepositoryInterface = new RepositoryInterface();
                }
                this.existingRepositoryInterface.setCompliance("UNKNOWN");
                this.existingRepositoryInterface.setBaseUrl(this.baseURL.getValue().trim());
                if (this.chooseExistingValidationSetRadio.getValue().booleanValue() && !this.existingValidationSetsListBox.getSelectedValue().equals("noneSelected")) {
                    this.existingRepositoryInterface.setAccessSet(this.existingValidationSetsListBox.getSelectedValue());
                } else if (this.addACustomValidationSetRadio.getValue().booleanValue() && this.validationSetTextBox.getValue() != null && !this.validationSetTextBox.getValue().trim().isEmpty()) {
                    this.existingRepositoryInterface.setAccessSet(this.validationSetTextBox.getValue().trim());
                } else {
                    this.existingRepositoryInterface.setAccessSet("");
                }
                this.existingRepositoryInterface.setDesiredCompatibilityLevel(this.desiredCompatibilityLevelListBox.getSelectedValue());
                return this.existingRepositoryInterface;
            }
            this.isValid = false;
            return new RepositoryInterface();
        }
        if (this.isEmpty()) {
            return null;
        }
        return this.existingRepositoryInterface;
    }

    private boolean isEmpty() {
        return this.chooseExistingValidationSetRadio.getValue() != false ? (this.baseURL.getValue() == null || this.baseURL.getValue().trim().equals("")) && this.existingValidationSetsListBox.getSelectedValue().equals("noneSelected") && this.desiredCompatibilityLevelListBox.getSelectedValue().equals("noneSelected") : !(this.baseURL.getValue() != null && !this.baseURL.getValue().trim().equals("") || this.validationSetTextBox.getValue() != null && !this.validationSetTextBox.getValue().trim().equals("") || !this.desiredCompatibilityLevelListBox.getSelectedValue().equals("noneSelected"));
    }

    private boolean isComplete() {
        boolean isComplete = true;
        this.interfaceErrorAlert.setVisible(false);
        if (this.baseURL.getValue() == null || this.baseURL.getValue().trim().isEmpty()) {
            isComplete = false;
            this.baseURLFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.desiredCompatibilityLevelListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            this.desiredCompatibilityLevelFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (!isComplete) {
            this.interfaceErrorAlert.setText("All fields marked with * are mandatory.");
            this.interfaceErrorAlert.setVisible(true);
        }
        return isComplete;
    }

    private void addValueChangeHandlersToFormFields() {
        this.baseURL.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.desiredCompatibilityLevelListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isValid() {
        return this.isValid;
    }

    static /* synthetic */ DeleteInterfaceListener access$000(InterfaceFields x0) {
        return x0.deleteInterfaceListener;
    }

    static /* synthetic */ void access$100(InterfaceFields x0) {
        x0.saveInterface();
    }

    static /* synthetic */ MyFormGroup access$200(InterfaceFields x0) {
        return x0.baseURLFormGroup;
    }

    static /* synthetic */ void access$300(InterfaceFields x0, String x1) {
        x0.getInterfaceInformation(x1);
    }

    static /* synthetic */ RadioButton access$400(InterfaceFields x0) {
        return x0.addACustomValidationSetRadio;
    }

    static /* synthetic */ TextBox access$500(InterfaceFields x0) {
        return x0.validationSetTextBox;
    }

    static /* synthetic */ ListBox access$600(InterfaceFields x0) {
        return x0.existingValidationSetsListBox;
    }

    static /* synthetic */ FlowPanel access$700(InterfaceFields x0) {
        return x0.interfaceBoxContentPanel;
    }

    static /* synthetic */ Alert access$800(InterfaceFields x0) {
        return x0.interfaceErrorAlert;
    }

    static /* synthetic */ Alert access$900(InterfaceFields x0) {
        return x0.interfaceSuccessAlert;
    }

    static /* synthetic */ RepositoryInterface access$1000(InterfaceFields x0) {
        return x0.existingRepositoryInterface;
    }

    static /* synthetic */ ListBox access$1100(InterfaceFields x0) {
        return x0.desiredCompatibilityLevelListBox;
    }

    static /* synthetic */ HTML access$1200(InterfaceFields x0) {
        return x0.currentCompatibilityLevel;
    }

    static /* synthetic */ TextBox access$1300(InterfaceFields x0) {
        return x0.baseURL;
    }

    static /* synthetic */ RadioButton access$1400(InterfaceFields x0) {
        return x0.chooseExistingValidationSetRadio;
    }

    static /* synthetic */ Map access$1500(InterfaceFields x0) {
        return x0.existingValidationSetsValuesMap;
    }

    static /* synthetic */ MyFormGroup access$1600(InterfaceFields x0) {
        return x0.desiredCompatibilityLevelFormGroup;
    }
}

