package eu.dnetlib.repo.manager.client.services;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.repo.manager.shared.InterfaceInformation;
import eu.dnetlib.repo.manager.shared.JobsOfUser;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.ValidationServiceException;

import java.util.List;

/**
 * Created by nikonas on 22/12/15.
 */
@RemoteServiceRelativePath("springGwtServices/validationService")
public interface ValidationService extends RemoteService {

    List<String> getSets(String baseUrl) throws ValidationServiceException;

    Boolean identifyRepository(String baseUrl) throws ValidationServiceException;

    InterfaceInformation getInterfaceInformation(String baseUrl) throws ValidationServiceException;

    List<RuleSet> getRuleSets(String validationMode) throws ValidationServiceException;

    RuleSet getRuleSet(String acronym) throws ValidationServiceException;

    void submitValidationJob(JobForValidation job) throws ValidationServiceException;

    void reSubmitValidationJob(int jobId)
            throws ValidationServiceException;

    StoredJob getJobSummary(int jobId, String groupBy) throws ValidationServiceException;

    List<StoredJob> getJobsOfUser(String user, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String validationStatus) throws ValidationServiceException;

    int getJobsTotalNumberOfUser(String user, String jobType, String validationStatus) throws ValidationServiceException;

    JobsOfUser getJobsOfUser(String user, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String validationStatus, boolean includeJobsTotal) throws ValidationServiceException;
}
