package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.Rule;
import org.gwtbootstrap3.client.ui.CheckBox;

import java.util.*;
import java.util.HashMap;
import java.util.HashSet;

/**
 * Created by stefania on 2/12/16.
 */
public class SelectRulesWidget implements IsWidget {

    private FlowPanel selectRulesPanel = new FlowPanel();
    private FlowPanel selectRulesInnerPanel = new FlowPanel();

    private CheckBox selectAllCheckBox;
    final private List<CheckBox> rulesCheckBoxes = new ArrayList<CheckBox>();

    private Map<CheckBox, Rule> checkBoxRuleMap = new HashMap<CheckBox, Rule>();

    public SelectRulesWidget(List<Rule> rules, String name) {

        selectRulesPanel.addStyleName("uk-width-expand@m uk-width-1-2@s uk-grid-item-match uk-first-column");
        selectRulesPanel.add(selectRulesInnerPanel);

        selectRulesInnerPanel.addStyleName("margin10");

        selectAllCheckBox = new CheckBox("Select / Deselect All " + name);
        selectAllCheckBox.setValue(true);
        selectAllCheckBox.addStyleName("selectAll");
        selectAllCheckBox.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {

                for(CheckBox checkBox : rulesCheckBoxes)
                    checkBox.setValue(selectAllCheckBox.getValue());
            }
        });
        selectRulesInnerPanel.add(selectAllCheckBox);

        for(Rule rule : rules) {
            CheckBox ruleCheckBox = new CheckBox(rule.getName());
            ruleCheckBox.setValue(true);
            ruleCheckBox.setTitle(rule.getDescription());
            rulesCheckBoxes.add(ruleCheckBox);
            checkBoxRuleMap.put(ruleCheckBox, rule);
            selectRulesInnerPanel.add(ruleCheckBox);
        }
    }

    @Override
    public Widget asWidget() {
        return selectRulesPanel;
    }

    public Set<Integer> getSelectedRules() {

        Set<Integer> selectedRules = new HashSet<Integer>();

        for(CheckBox checkBox : rulesCheckBoxes) {
                if (checkBox.getValue())
                    selectedRules.add(checkBoxRuleMap.get(checkBox).getId());
        }

        return selectedRules;
    }
}
