package eu.dnetlib.repo.manager.client;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by stefania on 12/16/15.
 */
public abstract class TokenController {

    protected Map<String, TokenController> subControllers = new HashMap<String, TokenController>();

    public void showWidget(FlowPanel contentPanel, String parent, String rest) {
        getSubController(rest).showWidget(contentPanel, parent + "/" + splitToken(rest)[0], splitToken(rest)[1]);
    }

    public TokenController getSubController(String rest) {
//        Window.alert("return sub controller for " + rest + " = " + splitToken(rest)[0]);

        return subControllers.get(splitToken(rest)[0]);
    }

    public String[] getMenuPath(String parent, String rest) {

//        Window.alert("returning path for " + parent + ", " + rest + "(" + this.getClass().getName() + ")");
        String[] rests = getSubController(rest).getMenuPath(splitToken(rest)[0], splitToken(rest)[1]);

        if (parent != null) {
            String[] ret = new String[rests.length + 1];

            ret[0] = parent;
            for (int i = 0; i < rests.length; i++)
                ret[i + 1] = rests[i];

            return ret;
        } else
            return rests;
    }

    protected final String[] splitToken(String token) {

        if (token.contains("/"))
            return new String[] {token.substring(0, token.indexOf('/')), token.substring(token.indexOf('/') + 1)};
        else
            return new String[] {token, null};
    }

    protected void redrawWidget(FlowPanel contentPanel, RepositoryManagerWidget widget, String parentToken, String rest) {

        contentPanel.clear();

        widget.setToken(parentToken, rest);
        widget.clear();
        widget.reload();

        contentPanel.add(widget.asWidget());

        Window.scrollTo(0, 0);

        widget.afterAdditionToRootPanel();
    }
}

