package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.client.services.BrokerServiceAsync;
import eu.dnetlib.repo.manager.shared.broker.SimpleSubscriptionDesc;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 3/16/17.
 */
public class BrowseSubscriptionsWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private FlowPanel browseSubscriptionsBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);
    private static BrokerServiceAsync brokerService = GWT.create(BrokerService.class);

    public BrowseSubscriptionsWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Enrich Your Content - Browse Subscriptions</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        browseSubscriptionsBoxContent.add(errorAlert);

        contentPanel.add(browseSubscriptionsBoxContent);
    }

    @Override
    public void clear() {

        browseSubscriptionsBoxContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        browseSubscriptionsBoxContent.add(errorAlert);

        helpService.getHelpById(parentToken, new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving subscriptions...</div>" +
                "<div class=\"whiteFilm\"></div>");
        browseSubscriptionsBoxContent.addStyleName("loading-big");
        browseSubscriptionsBoxContent.add(loadingWheel);

        brokerService.getSimpleSubscriptionsOfUser(RepositoryManager.currentUser.getEmail(),
                new AsyncCallback<Map<String, List<SimpleSubscriptionDesc>>>() {
            @Override
            public void onFailure(Throwable caught) {

                browseSubscriptionsBoxContent.removeStyleName("loading-big");
                browseSubscriptionsBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving subscriptions.");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(Map<String, List<SimpleSubscriptionDesc>> subscriptionsList) {

                browseSubscriptionsBoxContent.removeStyleName("loading-big");
                browseSubscriptionsBoxContent.remove(loadingWheel);

                createSubscriptionsList(subscriptionsList, browseSubscriptionsBoxContent);
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private void addWidgetHandlers() {

        $(".delete").click(new Function() {

            public boolean f(Event e) {

                errorAlert.setVisible(false);

                String[] idParts = $(e).get(0).getId().split("#");
                List<String> subscriptionIds = new ArrayList<String>();
                subscriptionIds.add(idParts[0]);

                deleteSubscriptions(subscriptionIds);

                return true;
            }
        });
    }

    private void createSubscriptionsList(Map<String, List<SimpleSubscriptionDesc>> subscriptionsList, FlowPanel subscriptionsPanel) {

        if(subscriptionsList.isEmpty()) {
            subscriptionsPanel.add(new HTML("No subscriptions found for your account"));
        } else {

            for(String key : subscriptionsList.keySet()) {

                HTML datasourceTitle = new HTML();
                datasourceTitle.setHTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"" +
                        "uk-scrollspy-class=\"\"><span>" + key + "</span></h4>");
                subscriptionsPanel.add(datasourceTitle);

                FlowPanel colPanel = new FlowPanel();
                colPanel.addStyleName("uk-width-1-1@m uk-first-column uk-margin-medium-bottom");
                subscriptionsPanel.add(colPanel);

                FlowPanel divPanel = new FlowPanel();
                divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
                colPanel.add(divPanel);

                String content = "<table class=\"uk-table uk-table-striped uk-table-middle\">" +
                        "<thead><tr><th>Topic</th><th class=\"uk-text-nowrap\"># of notifications</th><th class=\"uk-text-nowrap\">Actions</th></tr></thead>";

                content += "<tbody>";

                for(SimpleSubscriptionDesc simpleSubscriptionDesc : subscriptionsList.get(key)) {

                    content += "<tr class=\"el-item\">" +
                            "<td class=\"uk-table-shrink\">";

                    content += "<div class=\"el-title\">" + simpleSubscriptionDesc.getTopic() + "</div>";

                    content += "</td>" +
                            "<td class=\"uk-text-nowrap uk-table-shrink\">\n" +
                            "<div class=\"el-title\">" + simpleSubscriptionDesc.getCount() + "</div>" +
                            "</td>" +
                            "<td class=\"uk-text-nowrap uk-table-shrink\">" +
                            "<a href=\"javascript:;\" id=\"" + simpleSubscriptionDesc.getId() + "#delete\" class=\"el-link delete\">" +
                            "<i class=\"fa fa-remove\" aria-hidden=\"true\"></i></a>" +
                            "</td>" +
                            "</tr>";
                }

                content += "</tbody></table>";

                HTML reposListHTML = new HTML();
                reposListHTML.setHTML(content);

                divPanel.add(reposListHTML);
            }
        }

        addWidgetHandlers();
    }

    private void deleteSubscriptions(final List<String> subscriptionIds) {

        final Modal deleteSubscriptionsConfirmationPopup = new Modal();
        deleteSubscriptionsConfirmationPopup.setDataBackdrop(ModalBackdrop.STATIC);

        FlowPanel modalContent = new FlowPanel();

        HTML description = new HTML("<h2 class=\"uk-modal-title\">Delete Confirmation</h2>\n" +
                "<p>Are you sure you want to delete the selected subscription(s)?</p>");
        modalContent.add(description);

        FlowPanel actionButtons = new FlowPanel();
        actionButtons.addStyleName("uk-text-right");
        modalContent.add(actionButtons);

        Button no = new Button("Cancel");
        no.setType(ButtonType.DEFAULT);
        no.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                deleteSubscriptionsConfirmationPopup.hide();
                deleteSubscriptionsConfirmationPopup.removeFromParent();
            }
        });
        actionButtons.add(no);

        Button yes = new Button("Yes, delete them");
        yes.setType(ButtonType.PRIMARY);
        yes.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                deleteSubscriptionsConfirmationPopup.hide();
                deleteSubscriptionsConfirmationPopup.removeFromParent();

                final HTML loadingWheel = new HTML("<div class=\"loader-big\"></div><div class=\"whiteFilm\"></div>");
                browseSubscriptionsBoxContent.addStyleName("loading-big");
                browseSubscriptionsBoxContent.add(loadingWheel);

                brokerService.unsubscribe(subscriptionIds.get(0), new AsyncCallback<Void>() {

                    @Override
                    public void onFailure(Throwable caught) {

                        browseSubscriptionsBoxContent.removeStyleName("loading-big");
                        browseSubscriptionsBoxContent.remove(loadingWheel);

                        errorAlert.setText("System error deleting the specified subscription(s)");
                        errorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(Void result) {

                        browseSubscriptionsBoxContent.removeStyleName("loading-big");
                        browseSubscriptionsBoxContent.remove(loadingWheel);

                        clear();
                        reload();

                        Window.scrollTo(0, 0);
                    }
                });
            }
        });
        actionButtons.add(yes);

        ModalBody modalBody = new ModalBody();
        modalBody.add(modalContent);
        deleteSubscriptionsConfirmationPopup.add(modalBody);
        deleteSubscriptionsConfirmationPopup.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();

        deleteSubscriptionsConfirmationPopup.show();
    }
}
