package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;
import com.google.gwt.user.client.ui.Label;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.gwt.shared.Help;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.enrichcontent.advancedsearch.EnrichContentAdvancedSearchForm;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.client.services.BrokerServiceAsync;
import eu.dnetlib.repo.manager.shared.broker.*;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.gwtbootstrap3.client.ui.html.UnorderedList;

import java.util.List;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 11/1/16.
 */
public class ShowEventsWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private String dataSource = "";
    private String topic = "";
    private long pageSize = 10;
    private AdvQueryObject advQueryObject = new AdvQueryObject();

//    private FlowPanel showEventsPanel = new FlowPanel();
//    private FlowPanel showEventsColPanel = new FlowPanel();
//    private FlowPanel showEventsRowPanel = new FlowPanel();
//
//    private FlowPanel showEventsListColPanel = new FlowPanel();
//    private FlowPanel showEventsInnerPanel = new FlowPanel();
//    private FlowPanel showEventsBox = new FlowPanel();
    private HTML title = new HTML();
    private FlowPanel showEventsBoxContent = new FlowPanel();

//    private FlowPanel showAdvancedSearchColPanel = new FlowPanel();
//    private FlowPanel showAdvancedSearchInnerPanel = new FlowPanel();
//    private FlowPanel showAdvancedSearchBox = new FlowPanel();
//    private FlowPanel showAdvancedSearchBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();
    private Alert successAlert = new Alert();

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);
    private static BrokerServiceAsync brokerService = GWT.create(BrokerService.class);

    public ShowEventsWidget() {

        super();

        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

//        showEventsPanel.addStyleName("row");
//
//        showEventsColPanel.addStyleName("col-lg-12");
//        showEventsColPanel.add(showEventsRowPanel);
//
//        showEventsRowPanel.addStyleName("row");
//        showEventsRowPanel.add(showEventsListColPanel);
//        showEventsRowPanel.add(showAdvancedSearchColPanel);
//
//        showEventsListColPanel.addStyleName("col-lg-9");
//        showEventsListColPanel.add(showEventsInnerPanel);
//
//        showEventsInnerPanel.addStyleName("wrapper wrapper-content animated fadeInUp");
//        showEventsInnerPanel.add(showEventsBox);
//
//        showEventsBox.addStyleName("ibox");
//        showEventsBox.add(showEventsBoxContent);
//
//        showEventsBoxContent.addStyleName("ibox-content bigContent");

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        showEventsBoxContent.add(errorAlert);

        successAlert.setType(AlertType.SUCCESS);
        successAlert.setDismissable(false);
        successAlert.setVisible(false);
        showEventsBoxContent.add(successAlert);

        contentPanel.add(showEventsBoxContent);

//        showAdvancedSearchColPanel.addStyleName("col-lg-3");
//        showAdvancedSearchColPanel.add(showAdvancedSearchInnerPanel);
//
//        showAdvancedSearchInnerPanel.addStyleName("wrapper wrapper-content animated fadeInUp");
//        showAdvancedSearchInnerPanel.add(showAdvancedSearchBox);
//
//        showAdvancedSearchBox.addStyleName("ibox");
//        showAdvancedSearchBox.add(showAdvancedSearchBoxContent);
//
//        showAdvancedSearchBoxContent.addStyleName("ibox-content bigContent");
//
//        showEventsPanel.add(showEventsColPanel);
    }

    @Override
    public void clear() {

        showEventsBoxContent.clear();
        errorAlert.setVisible(false);
        successAlert.setVisible(false);
        gridPanel.remove(helpPanel);

//        showAdvancedSearchBoxContent.clear();

        advQueryObject = new AdvQueryObject();
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");

        title.setHTML("<h1 class=\"uk-article-title\">" + dataSource + "</h1><div class=\"uk-text uk-text-small uk-text-secondary\">" +
                topic.replace("/", "  |  ") + "</div>");

        advQueryObject.setDatasource(dataSource);
        advQueryObject.setTopic(topic);

        showEvents(0);
//        showAdvancedSearch();

        helpService.getHelpById(parentToken + "_showEvents", new HelpCallback(helpPanel, gridPanel) {

            @Override
            public void onSuccess(Help help) {

                gridPanel.add(helpPanel);

//                Window.alert("Run successfully!!!");

                if (help != null && help.getText()!=null && !help.getText().trim().isEmpty()) {
                    String content = "<div class=\"uk-card uk-card-body uk-card-default sidemenu\">" + help.getText() + "</div>";
                    HTML html = new HTML();
                    html.setHTML(content);

                    helpPanel.clear();
                    helpPanel.add(showAdvancedSearch());
                    helpPanel.add(html);
//                    gridPanel.add(helpPanel);

                } else {
                    helpPanel.clear();
                    helpPanel.add(showAdvancedSearch());

                }
            }
        });

//        RepositoryManager.pageHeader.clear();
//        String header = "<div class=\"col-sm-9\"><h2>Events for " + topic + "</h2><ol class=\"breadcrumb\">" +
//                "<li><a href=\"#dashboard\">Home</a></li><li><a href=\"#enrichContent/events\">Enrich Content</a></li>" +
//                "<li><a href=\"#enrichContent/events/" + dataSource +"\">" + dataSource + "</a></li>" +
//                "<li class=\"active\"><strong>" + topic + "</strong></li></ol></div><div class=\"col-sm-3\"><div class=\"nav " +
//                "navbar-top-links navbar-right\"><button id=\"subscribe\" style=\"margin-top: 30px; margin-right: 20px\" " +
//                "type=\"button\" class=\"btn btn-w-m btn-success\">Subscribe to these events</button></div></div>";
//        RepositoryManager.pageHeader.add(new HTML(header));


    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;

        String[] tokenSplit = restToken.split("/", 2);
        dataSource = tokenSplit[0];
        topic = tokenSplit[1];
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private FlowPanel showAdvancedSearch() {

        EnrichContentAdvancedSearchForm enrichContentAdvancedSearchForm = new EnrichContentAdvancedSearchForm(dataSource, topic);
        EnrichContentAdvancedSearchForm.AdvancedSearchFormSelectionListener advancedSearchFormSelectionListener =
                new EnrichContentAdvancedSearchForm.AdvancedSearchFormSelectionListener() {
                    @Override
                    public void criteriaSelected(AdvQueryObject advQueryObject) {
                        ShowEventsWidget.this.advQueryObject = advQueryObject;
                        showEvents(0);
                    }

                    @Override
                    public void criteriaCleared(AdvQueryObject advQueryObject) {
                        ShowEventsWidget.this.advQueryObject = advQueryObject;
                        showEvents(0);
                    }
                };
        enrichContentAdvancedSearchForm.setAdvancedSearchFormSelectionListener(advancedSearchFormSelectionListener);

        final FlowPanel advancedSearch = new FlowPanel();
        advancedSearch.addStyleName("enrichContentAdvancedSearch uk-card uk-card-body uk-card-default sidemenu");
        advancedSearch.add(new HTML("<h6 class=\"uk-h6 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"" +
                "uk-scrollspy-class=\"\"><span>Tweak and refine events</span></h4>"));
        advancedSearch.add(enrichContentAdvancedSearchForm.asWidget());

        return advancedSearch;
    }

    private void showEvents(long currentPage) {

        showEventsBoxContent.clear();
        showEventsBoxContent.add(errorAlert);
        showEventsBoxContent.add(successAlert);

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving events...</div>" +
                "<div class=\"whiteFilm\"></div>");
        showEventsBoxContent.addStyleName("loading-big");
        showEventsBoxContent.add(loadingWheel);

        brokerService.advancedShowEvents(advQueryObject, currentPage, pageSize, new AsyncCallback<EventsPage>() {

            @Override
            public void onFailure(Throwable caught) {

                showEventsBoxContent.removeStyleName("loading-big");
                showEventsBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving events for the selected topic.");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(EventsPage eventsPage) {

                showEventsBoxContent.removeStyleName("loading-big");
                showEventsBoxContent.remove(loadingWheel);

                final FlowPanel eventsList = new FlowPanel();
                eventsList.addStyleName("events-results");
                createEventsList(eventsPage, eventsList);
                showEventsBoxContent.add(eventsList);

                addSubscribeHandler();

                //                final FlowPanel advancedSearch = new FlowPanel();
//                advancedSearch.addStyleName("col-md-3 enrichContentAdvancedSearch");
//                contentColPanel.add(advancedSearch);
//                advancedSearch.add(new HTML("<h3>Advanced Search</h3>"));
//                advancedSearch.add(new EnrichContentAdvancedSearchForm());

//                FlowPanel contentRowPanel = new FlowPanel();
//                contentRowPanel.addStyleName("row");
//                showEventsBoxContent.add(contentRowPanel);
//
//                final FlowPanel contentColPanel = new FlowPanel();
//                contentColPanel.addStyleName("col-lg-12");
//                contentRowPanel.add(contentColPanel);



//                final FlowPanel eventsList = new FlowPanel();
//                eventsList.addStyleName("col-md-12 topics-list");
//                createEventsList(eventsPage, eventsList);
//                contentColPanel.add(eventsList);
            }
        });
    }

    private void createEventsList(EventsPage eventsPage, FlowPanel eventsList) {

        if(eventsPage == null || eventsPage.getTotal() == 0) {

            eventsList.add(new HTML("<div class=\"alert alert-warning\">No events were found for this topic.</div>"));

        } else {

            long from = eventsPage.getCurrPage() * pageSize + 1;
            long to = (eventsPage.getCurrPage() + 1) * pageSize;
            if(to>eventsPage.getTotal())
                to = eventsPage.getTotal();

            HTML numberOfResultsLabel = new HTML("<span>Showing " + from + "-" + to + " of " + eventsPage.getTotal() + " results</span>" +
                    "<span class=\"uk-float-right\"><button id=\"subscribe\" style=\"\" type=\"button\" class=\"uk-button " +
                    "uk-button-primary uk-button-small\">Subscribe to these events</button></span>");
            numberOfResultsLabel.addStyleName("numberOfEventsLabel");
            eventsList.add(numberOfResultsLabel);

            FlowPanel topPagerPanel = new FlowPanel();
            drawPager(topPagerPanel, eventsPage);
            eventsList.add(topPagerPanel);

            String content = "";

            for(OpenAireEventPayload payload : eventsPage.getValues()) {
                content += returnPayloadContent(payload);
            }

            HTML eventsListHTML = new HTML();
            eventsListHTML.addStyleName("events-list");
            eventsListHTML.setHTML(content);

            eventsList.add(eventsListHTML);

            FlowPanel bottomPagerPanel = new FlowPanel();
            drawPager(bottomPagerPanel, eventsPage);
            eventsList.add(bottomPagerPanel);
        }
    }

    private void drawPager(FlowPanel pagerPanel, final EventsPage eventsPage) {

        UnorderedList pager = new UnorderedList();
        pager.addStyleName("uk-pagination");

        final ListItem listItemPrevious = new ListItem();
        Anchor previous = new Anchor();
        previous.setHTML("<span class=\"uk-margin-small-right\" uk-pagination-previous></span> Previous");
        previous.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                showEvents(eventsPage.getCurrPage() - 1);
            }
        });
        listItemPrevious.add(previous);
        pager.add(listItemPrevious);

        ListItem listItemNext = new ListItem();
        listItemNext.addStyleName("uk-margin-auto-left");
        Anchor next = new Anchor();
        next.setHTML("Next <span class=\"uk-margin-small-left\" uk-pagination-next></span>");
        next.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                showEvents(eventsPage.getCurrPage() + 1);
            }
        });
        listItemNext.add(next);
        pager.add(listItemNext);


        if(eventsPage.getCurrPage()==0) {
            previous.setEnabled(false);
            listItemPrevious.addStyleName("uk-disabled");
        } else {
            previous.setEnabled(true);
            listItemPrevious.removeStyleName("uk-disabled");
        }

        if(eventsPage.getCurrPage()==(eventsPage.getTotalPages()-1)) {
            next.setEnabled(false);
            listItemNext.addStyleName("uk-disabled");
        } else {
            next.setEnabled(true);
            listItemNext.removeStyleName("uk-disabled");
        }

        pagerPanel.add(pager);

        Label pageNumber = new Label();

        pageNumber.setText("page " + (eventsPage.getCurrPage() + 1) + " of " + eventsPage.getTotalPages());
        pageNumber.addStyleName("resultsPageLabel");
        pagerPanel.add(pageNumber);
    }
    
    private String returnPayloadContent(OpenAireEventPayload openAireEventPayload) {
        
        String payloadContent = "";
        
        payloadContent += "<div class=\"uk-card uk-card-default well uk-scrollspy-inview uk-animation-slide-top-medium\">" +
                "<div class=\"uk-grid-margin uk-grid uk-grid-stack\" uk-grid=\"\">" +
                "<div class=\"uk-width-1-1@m uk-first-column\">" +
                "<p class=\"text-right\"><span class=\"uk-label\">Trust: </b>" + openAireEventPayload.getTrust() + "</span></p>";


        payloadContent += "<div class=\"uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium\">" +
                "<table class=\"uk-table uk-table-striped uk-table-middle\"><tbody>";


        // ID
        payloadContent += "<tr class=\"el-item\">" +
                "<td class=\"uk-table-shrink uk-width-1-4\">" +
                "<strong class=\"el-title uk-display-block\">ID</strong>" +
                "</td>" +
                "<td class=\"uk-table-shrink\">\n" +
                "<div class=\"el-title\">" + openAireEventPayload.getPublication().getOriginalId() + "</div>" +
                "</td>" +
                "</tr>";


        // TITLES
        payloadContent += "<tr class=\"el-item\"><td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                "Title(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";

        for(int i=0; i<openAireEventPayload.getPublication().getTitles().size(); i++) {
            if(i!=0)
                payloadContent += "<br>";
            payloadContent += "<span>" + openAireEventPayload.getPublication().getTitles().get(i) + "</span>";
        }
        payloadContent += "</div></td></tr>";


        // AUTHORS
        payloadContent += "<tr class=\"el-item\"><td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                "Author(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";

        for(int i=0; i<openAireEventPayload.getPublication().getCreators().size(); i++) {
            if(i!=0)
                payloadContent += " | ";
            payloadContent += "<span>" + openAireEventPayload.getPublication().getCreators().get(i) + "</span>";
        }
        payloadContent += "</div></td></tr>";


        // PIDs
        if(openAireEventPayload.getHighlight().getPids()!=null && !openAireEventPayload.getHighlight().getPids().isEmpty()) {
            payloadContent += "<tr class=\"el-item success\">";
        } else {
            payloadContent += "<tr class=\"el-item\">";
        }

        payloadContent += "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                "PID(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";

        for(Pid pid : openAireEventPayload.getPublication().getPids()) {
            payloadContent += "<span>" + pid.getValue() + "<b>&nbsp;&nbsp;(" + pid.getType() + ")&nbsp;&nbsp;</b> ";
            if(isPidHighlighted(pid, openAireEventPayload.getHighlight().getPids())) {
                payloadContent += "<span>";

                payloadContent += "<span class=\"uk-label uk-label-success\">added</span>";

                if(openAireEventPayload.getProvenance()!=null) {

                    payloadContent += "<span class=\"pull-right\">" +
                            "<b>from: </b>";
                    if (openAireEventPayload.getProvenance().getUrl() != null) {
                        payloadContent += "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" +
                                openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
                    }
                    if (openAireEventPayload.getProvenance().getId() != null) {
                        payloadContent += "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
                    }

                    payloadContent += "</span>";
                }

                payloadContent += "</span>";
            }
            payloadContent += "</span>";
        }
        payloadContent += "</div></td></tr>";


        // ABSTRACTS
        if(openAireEventPayload.getHighlight().getAbstracts()!=null && !openAireEventPayload.getHighlight().getAbstracts().isEmpty()) {
            payloadContent += "<tr class=\"el-item success\">";
        } else {
            payloadContent += "<tr class=\"el-item\">";
        }

        payloadContent += "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                "Abstract(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";

        for(int i=0; i<openAireEventPayload.getPublication().getAbstracts().size(); i++) {
            if(i!=0)
                payloadContent += "<br>";
            payloadContent += "<span>" + openAireEventPayload.getPublication().getAbstracts().get(i) + "</span>";

            if(openAireEventPayload.getHighlight().getAbstracts()!=null && !openAireEventPayload.getHighlight().getAbstracts().isEmpty()
                    && openAireEventPayload.getProvenance()!=null) {

                payloadContent += "<span class=\"pull-right\">" +
                        "<b>from: </b>";
                if (openAireEventPayload.getProvenance().getUrl() != null) {
                    payloadContent += "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" +
                            openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
                }
                if (openAireEventPayload.getProvenance().getId() != null) {
                    payloadContent += "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
                }

                payloadContent += "</span>";
            }
        }
        payloadContent += "</div></td></tr>";


        // PROJECTS
        if(openAireEventPayload.getHighlight().getProjects()!=null && !openAireEventPayload.getHighlight().getProjects().isEmpty()) {
            payloadContent += "<tr class=\"el-item success\">";
        } else {
            payloadContent += "<tr class=\"el-item\">";
        }

        payloadContent += "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                "Project(s)/Relation(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";

        for(int i=0; i<openAireEventPayload.getPublication().getProjects().size(); i++) {
            if(i!=0)
                payloadContent += "<br>";
            if(openAireEventPayload.getPublication().getProjects().get(i).getAcronym()!=null && !openAireEventPayload.getPublication().getProjects().get(i).getAcronym().trim().equals(""))
                payloadContent += "<span>" + openAireEventPayload.getPublication().getProjects().get(i).getAcronym() + "</span>";
            else
                payloadContent += "<span>" + openAireEventPayload.getPublication().getProjects().get(i).getTitle() + "</span>";

            if(openAireEventPayload.getHighlight().getProjects()!=null && !openAireEventPayload.getHighlight().getProjects().isEmpty()
                    && openAireEventPayload.getProvenance()!=null) {

                payloadContent += "<span class=\"pull-right\">" +
                        "<b>from: </b>";
                if (openAireEventPayload.getProvenance().getUrl() != null) {
                    payloadContent += "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" +
                            openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
                }
                if (openAireEventPayload.getProvenance().getId() != null) {
                    payloadContent += "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
                }

                payloadContent += "</span>";
            }
        }
        payloadContent += "</div></td></tr>";


        // SUBJECTS
        if(openAireEventPayload.getHighlight().getSubjects()!=null && !openAireEventPayload.getHighlight().getSubjects().isEmpty()) {

            payloadContent += "<tr class=\"el-item success\">";

            payloadContent += "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                    "Subject(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";

            for(int i=0; i<openAireEventPayload.getPublication().getSubjects().size(); i++) {
                if(i!=0)
                    payloadContent += "<br>";
                payloadContent += "<span>" + openAireEventPayload.getPublication().getSubjects().get(i) + "</span>";

                if(openAireEventPayload.getHighlight().getSubjects()!=null && !openAireEventPayload.getHighlight().getSubjects().isEmpty()
                        && openAireEventPayload.getProvenance()!=null) {

                    payloadContent += "<span class=\"pull-right\">" +
                            "<b>from: </b>";
                    if (openAireEventPayload.getProvenance().getUrl() != null) {
                        payloadContent += "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" +
                                openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
                    }
                    if (openAireEventPayload.getProvenance().getId() != null) {
                        payloadContent += "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
                    }

                    payloadContent += "</span>";
                }
            }
            payloadContent += "</div></td></tr>";

        } else {

            payloadContent += "<tr class=\"el-item\">";

            payloadContent += "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                    "Subject(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";

            for(int i=0; i<openAireEventPayload.getPublication().getSubjects().size(); i++) {
                if(i!=0)
                    payloadContent += ", ";
                payloadContent += "<span>" + openAireEventPayload.getPublication().getSubjects().get(i) + "</span>";

            }
            payloadContent += "</div></td></tr>";
        }


        // PUBLICATION DATE
        if(openAireEventPayload.getHighlight().getPublicationdate()!=null &&
                !openAireEventPayload.getHighlight().getPublicationdate().isEmpty()) {
            payloadContent += "<tr class=\"el-item success\">";
        } else {
            payloadContent += "<tr class=\"el-item\">";
        }

        payloadContent += "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                "Publication date</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" +
                openAireEventPayload.getPublication().getPublicationdate() +
                "</div></td></tr>";


        // RIGHTS
        if(openAireEventPayload.getHighlight().getInstances()!=null &&
                !openAireEventPayload.getHighlight().getInstances().isEmpty()) {
            payloadContent += "<tr class=\"el-item success\">";
        } else {
            payloadContent += "<tr class=\"el-item\">";
        }

        payloadContent += "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">" +
                "Rights</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";

        for(int i=0; i<openAireEventPayload.getPublication().getInstances().size(); i++) {

            if(i!=0)
                payloadContent += "<br>";

            payloadContent += "<span>";
            payloadContent += openAireEventPayload.getPublication().getInstances().get(i).getLicense() +
                    "&nbsp;&nbsp;<b>" + openAireEventPayload.getPublication().getInstances().get(i).getHostedby() + "</b>";
            payloadContent += "<br>";
            payloadContent += "<a href=\"" + openAireEventPayload.getPublication().getInstances().get(i).getUrl() +
                    "\" target=\"_blank\">" + openAireEventPayload.getPublication().getInstances().get(i).getUrl() + "</a>&nbsp;&nbsp;";
            payloadContent += "</span>";

            if(isInstanceHighlighted(openAireEventPayload.getPublication().getInstances().get(i), openAireEventPayload.getHighlight().getInstances())) {
                payloadContent += "<span>";

                payloadContent += "<span class=\"uk-label uk-label-success\">added</span>";

                if(openAireEventPayload.getProvenance()!=null) {

                    payloadContent += "<span class=\"pull-right\">" +
                            "<b>from: </b>";
                    if (openAireEventPayload.getProvenance().getUrl() != null) {
                        payloadContent += "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" +
                                openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
                    }
                    if (openAireEventPayload.getProvenance().getId() != null) {
                        payloadContent += "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
                    }

                    payloadContent += "</span>";
                }

                payloadContent += "</span>";
            }
        }
        payloadContent += "</div></td></tr>";


        payloadContent += "</tbody></table></div></div></div></div>";
        
        return payloadContent;
    }

    private boolean isPidHighlighted(Pid pid, List<Pid> highlightedPIDs) {

        for(Pid highlightedPid : highlightedPIDs) {
            if(highlightedPid.getType().equals(pid.getType()) && highlightedPid.getValue().equals(pid.getValue()))
                return true;
        }

        return false;
    }

    private boolean isInstanceHighlighted(Instance instance, List<Instance> highlightedInstances) {

        for(Instance highlightedInstance : highlightedInstances) {
            if(highlightedInstance.getUrl().equals(instance.getUrl())
                    && highlightedInstance.getHostedby().equals(instance.getHostedby())
                    && highlightedInstance.getInstancetype().equals(instance.getInstancetype())
                    && highlightedInstance.getLicense().equals(instance.getLicense()))
                return true;
        }

        return false;
    }

    private void addSubscribeHandler() {

        $("#subscribe").click(new Function() {

            public boolean f(Event e) {

                errorAlert.setVisible(false);
                successAlert.setVisible(false);

                final Modal subscribeToEvents = new Modal();
                subscribeToEvents.setDataBackdrop(ModalBackdrop.STATIC);

                FlowPanel modalContent = new FlowPanel();

                HTML title = new HTML("<h2 class=\"uk-modal-title\">Create subscription for</h2>\n");
                modalContent.add(title);

                final EventsSubscriptionForm eventsSubscriptionForm = new EventsSubscriptionForm(advQueryObject);
                modalContent.add(eventsSubscriptionForm.asWidget());

                FlowPanel actionButtons = new FlowPanel();
                actionButtons.addStyleName("uk-text-right uk-margin-bottom");
                modalContent.add(actionButtons);

                Button no = new Button("Cancel");
                no.addStyleName("uk-button uk-button-default");
                no.addClickHandler(new ClickHandler() {
                    @Override
                    public void onClick(ClickEvent event) {
                        subscribeToEvents.hide();
                        subscribeToEvents.removeFromParent();
                    }
                });
                actionButtons.add(no);

                Button yes = new Button("Subscribe");
                yes.addStyleName("uk-button uk-button-primary");
                yes.addClickHandler(new ClickHandler() {
                    @Override
                    public void onClick(ClickEvent event) {

                        if(eventsSubscriptionForm.validate()) {
                            OpenaireSubscription openaireSubscription = eventsSubscriptionForm.getOpenAIRESubscription();
                            brokerService.subscribe(openaireSubscription, new AsyncCallback<Subscription>() {

                                @Override
                                public void onFailure(Throwable caught) {

                                    errorAlert.setVisible(true);
                                    errorAlert.setText("System error subscribing to these events");

                                    subscribeToEvents.hide();
                                    subscribeToEvents.removeFromParent();
                                }

                                @Override
                                public void onSuccess(Subscription result) {

                                    successAlert.setVisible(true);
                                    successAlert.setText("Your subscription was successful");

                                    subscribeToEvents.hide();
                                    subscribeToEvents.removeFromParent();
                                }
                            });
                        }
                    }
                });
                actionButtons.add(yes);

                ModalBody modalBody = new ModalBody();
                modalBody.add(modalContent);
                subscribeToEvents.add(modalBody);
                subscribeToEvents.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();

                subscribeToEvents.show();

                return true;
            }
        });
    }
}
