package eu.dnetlib.repo.manager.client.getimpact;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.domain.data.PiwikInfo;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

/**
 * Created by stefania on 12/19/16.
 */
public class InstructionsForMetricsWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private String repositoryId = "";

    private FlowPanel instructionsForMetricsBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);
    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    public InstructionsForMetricsWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Metrics Configuration & Software Details</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        instructionsForMetricsBoxContent.add(errorAlert);

        contentPanel.add(instructionsForMetricsBoxContent);
    }

    @Override
    public void clear() {

        instructionsForMetricsBoxContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        instructionsForMetricsBoxContent.add(errorAlert);

        helpService.getHelpById(parentToken + "_forDatasource_instructions", new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repository information...</div>" +
                "<div class=\"whiteFilm\"></div>");
        instructionsForMetricsBoxContent.addStyleName("loading-big");
        instructionsForMetricsBoxContent.add(loadingWheel);

        repositoryService.getRepository(repositoryId, new AsyncCallback<Repository>() {

            @Override
            public void onFailure(Throwable caught) {

                instructionsForMetricsBoxContent.removeStyleName("loading-big");
                instructionsForMetricsBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving repository information");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(final Repository repository) {


                repositoryService.getPiwikSiteForRepository(repository.getId(), new AsyncCallback<PiwikInfo>() {

                    @Override
                    public void onFailure(Throwable throwable) {

                        instructionsForMetricsBoxContent.removeStyleName("loading-big");
                        instructionsForMetricsBoxContent.remove(loadingWheel);

                        errorAlert.setText("System error retrieving the piwik info for this repository");
                        errorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(PiwikInfo piwikInfo) {

                        instructionsForMetricsBoxContent.add(showInstructions(piwikInfo));

                        instructionsForMetricsBoxContent.removeStyleName("loading-big");
                        instructionsForMetricsBoxContent.remove(loadingWheel);

                        Window.moveTo(0,0);
                    }
                });

//                repositoryService.getPiwikScriptForRepository(repositoryId, new AsyncCallback<String>() {
//
//                    @Override
//                    public void onFailure(Throwable caught) {
//
//                        instructionsForMetricsBoxContent.removeStyleName("loading-big");
//                        instructionsForMetricsBoxContent.remove(loadingWheel);
//
//                        errorAlert.setText("System error retrieving piwik script for this repository");
//                        errorAlert.setVisible(true);
//                    }
//
//                    @Override
//                    public void onSuccess(String piwikScript) {
//
////                        RepositoryManager.pageHeader.clear();
////                        String logoURLSource = "";
////                        if(repository.getLogoUrl()==null || repository.getLogoUrl().isEmpty())
////                            logoURLSource = "img/yourLogoHere.jpg";
////                        else
////                            logoURLSource = repository.getLogoUrl();
////
////                        RepositoryManager.pageHeader.add(new HTML("<div class=\"col-sm-9\"><h2><img src=\"" + logoURLSource + "\" alt=[Repo Logo]" +
////                                "width=\"35px\" height=\"35px\" style=\"margin-right: 15px; margin-top:-2px\">Enable metrics for " + repository.getOfficialName() + "</h2>" +
////                                "<ol class=\"breadcrumb\"><li><a href=\"#dashboard\">Home</a></li><li><a href=\"#" + parentToken +
////                                "\">Metrics</a></li><li><a href=\"#" + parentToken + "/" + repositoryId + "\">" + repository.getOfficialName() + "</a>" +
////                                "</li><li class=\"active\"><strong>Instructions</strong></li></ol></div><div class=\"col-sm-3\"></div>"));
//
//                        instructionsForMetricsBoxContent.removeStyleName("loading-big");
//                        instructionsForMetricsBoxContent.remove(loadingWheel);
//
//                        if(piwikScript!=null)
//                            instructionsForMetricsBoxContent.add(showInstructions(piwikScript));
//                        else {
//
//                            Alert infoAlert = new Alert();
//                            infoAlert.setType(AlertType.WARNING);
//                            infoAlert.setDismissable(false);
//                            infoAlert.setText("Metrics have not yet been enabled for this repository.");
//                            instructionsForMetricsBoxContent.add(infoAlert);
//
//                            Button goToEnableMetrics = new Button();
//                            goToEnableMetrics.setText("I would like to enable metrics");
//                            goToEnableMetrics.setType(ButtonType.PRIMARY);
//                            goToEnableMetrics.addClickHandler(new ClickHandler() {
//
//                                @Override
//                                public void onClick(ClickEvent event) {
//                                    History.newItem("getImpact/" + repository.getId());
//                                }
//                            });
//                            instructionsForMetricsBoxContent.add(goToEnableMetrics);
//                        }
//                    }
//                });
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;

        String[] tokenSplit = restToken.split("/", 2);
        repositoryId = tokenSplit[1];
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private FlowPanel showInstructions(PiwikInfo piwikInfo) {

        FlowPanel instructionsPanel = new FlowPanel();

        String instructions = "<p>OpenAIRE’s usage statistic service uses the <i>Piwik Open Source Analytics platform</i> (piwik.org)  " +
                "to track usage activity. When <i>metrics</i> are enabled for a repository, two unique identifiers are generated - " +
                "a piwik-ID that associates the repository with its usage events in Piwik and an authentication-ID that allows " +
                "to track usage activity on the Piwik platform. Metadata views and item downloads are tracked and automatically " +
                "sent to Piwik. Statistics are generated using the COUNTER Code of practice directives.</p>";

        instructions += "OpenAIRE's usage statistics service tracking code exploits Piwik’s API. In order to make the " +
                "tracking of usage events from repositories more robust, it was necessary to implement repository platform " +
                "specific patches and plugins starting with DSpace and EPrints. The code is maintained on Github:";

        instructions += "<ul>" +
                "<li>as a patch for various versions of DSpace (<a target=\"_blank\" " +
                "href=\"https://github.com/openaire/OpenAIRE-Piwik-DSpace\">https://github.com/openaire/OpenAIRE-Piwik-DSpace</a>)</li>" +
                "<li>as an EPrints plugin for version 3 (<a target=\"_blank\" " +
                "href=\"https://github.com/openaire/EPrints-OAPiwik\">https://github.com/openaire/EPrints-OAPiwik</a>)</li>" +
                "</ul>";

        instructions += "<p>To configure your repository to allow tracking in Piwik platform, please change the configuration " +
                "files with the following parameters and values, generated for your site:</p>" +
                "<dl class=\"uk-description-list\">" +
                "    <dt>PiwikID</dt>\n" +
                "    <dd>" + piwikInfo.getSiteId() + "</dd>\n" +
                "    <dt>AuthenticationToken</dt>\n" +
                "    <dd>" + piwikInfo.getAuthenticationToken() + "</dd>\n" +
                "</dl>";

        instructions += "<p>Details for the configuration files are given in the README of the tracking code.</p>";

        instructions += "<div class=\"uk-alert uk-alert-info\"><strong>NOTE</strong> - You will be informed by e-mail that the installation of the tracking code has been validated and when the usage statistics will be available.</div>";

        HTML instructionsHTML = new HTML();
        instructionsHTML.setHTML(instructions);
        instructionsPanel.add(instructionsHTML);

        return  instructionsPanel;
    }
}
