package eu.dnetlib.repo.manager.client.services;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface BrokerServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void getTopicsForDatasource( java.lang.String datasourceName, AsyncCallback<java.util.List<eu.dnetlib.repo.manager.shared.broker.BrowseEntry>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void showEvents( java.lang.String datasourceName, java.lang.String topic, long page, AsyncCallback<eu.dnetlib.repo.manager.shared.broker.EventsPage> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void advancedShowEvents( eu.dnetlib.repo.manager.shared.broker.AdvQueryObject advQueryObject, long page, long pageSize, AsyncCallback<eu.dnetlib.repo.manager.shared.broker.EventsPage> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void getDatasourcesOfUser( java.lang.String userEmail, boolean includeShared, boolean includeByOthers, AsyncCallback<eu.dnetlib.repo.manager.shared.broker.DatasourcesBroker> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void getSimpleSubscriptionsOfUser( java.lang.String userEmail, AsyncCallback<java.util.Map<java.lang.String,java.util.List<eu.dnetlib.repo.manager.shared.broker.SimpleSubscriptionDesc>>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void getSubscriptionsOfUser( java.lang.String userEmail, AsyncCallback<java.util.Map<java.lang.String,java.util.List<eu.dnetlib.repo.manager.shared.broker.Subscription>>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void subscribe( eu.dnetlib.repo.manager.shared.broker.OpenaireSubscription obj, AsyncCallback<eu.dnetlib.repo.manager.shared.broker.Subscription> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void unsubscribe( java.lang.String subscriptionId, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void unsubscribe( java.util.List<java.lang.String> subscriptionIds, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void getSubscription( java.lang.String subscriptionId, AsyncCallback<eu.dnetlib.repo.manager.shared.broker.Subscription> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void getDnetTopics( AsyncCallback<java.util.Map<java.lang.String,eu.dnetlib.repo.manager.shared.Term>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.BrokerService
     */
    void getNotificationsBySubscriptionId( java.lang.String subscriptionId, java.lang.String page, java.lang.String size, AsyncCallback<eu.dnetlib.repo.manager.shared.broker.EventsPage> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static BrokerServiceAsync instance;

        public static final BrokerServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (BrokerServiceAsync) GWT.create( BrokerService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instantiated
        }
    }
}
