package eu.dnetlib.repo.manager.client.services;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface RepositoryServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getRepositoriesByCountry( java.lang.String country, java.lang.String mode, boolean includeUnknownCountries, AsyncCallback<eu.dnetlib.repo.manager.shared.Tuple<java.util.List<eu.dnetlib.domain.data.Repository>,java.util.List<eu.dnetlib.domain.data.Repository>>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getRepositoryUrlsOfUser( java.lang.String userEmail, boolean includeShared, boolean includeByOthers, AsyncCallback<java.util.List<java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getRepository( java.lang.String repoId, AsyncCallback<eu.dnetlib.domain.data.Repository> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getCountries( java.lang.Boolean existingOnly, java.lang.String mode, AsyncCallback<java.util.Map<java.lang.String,java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getCountries( AsyncCallback<java.util.Map<java.lang.String,java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getTimezones( AsyncCallback<java.util.List<eu.dnetlib.repo.manager.shared.Timezone>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getTypologies( AsyncCallback<java.util.List<java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getDatasourceClasses( java.lang.String mode, AsyncCallback<java.util.Map<java.lang.String,java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getCompatibilityClasses( java.lang.String mode, AsyncCallback<java.util.Map<java.lang.String,java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void storeRepository( eu.dnetlib.domain.data.Repository repo, java.lang.String mode, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void updateRepositoryInformation( eu.dnetlib.domain.data.Repository repo, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void updateInterface( eu.dnetlib.domain.data.RepositoryInterface iFace, java.lang.String repoId, java.lang.String datatype, AsyncCallback<eu.dnetlib.domain.data.RepositoryInterface> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void insertInterface( eu.dnetlib.domain.data.RepositoryInterface iFace, java.lang.String repoId, java.lang.String datatype, AsyncCallback<eu.dnetlib.domain.data.RepositoryInterface> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void deleteInterface( java.lang.String repoId, eu.dnetlib.domain.data.RepositoryInterface iFace, java.lang.String datatype, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void deleteInterfaces( java.lang.String repoId, java.util.List<eu.dnetlib.domain.data.RepositoryInterface> iFaces, java.lang.String datatype, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getDatasourceVocabularies( java.lang.String mode, AsyncCallback<eu.dnetlib.repo.manager.shared.DatasourceVocabularies> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getRepositoriesByCountry( java.lang.String country, java.lang.String mode, AsyncCallback<java.util.List<eu.dnetlib.domain.data.Repository>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getRepositoriesOfUser( java.lang.String userEmail, boolean includeShared, boolean includeByOthers, AsyncCallback<eu.dnetlib.repo.manager.shared.DatasourcesCollection> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getLatestUpdateDateOfList( java.lang.String mode, AsyncCallback<java.lang.String> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getPiwikSiteForRepository( java.lang.String repoId, AsyncCallback<eu.dnetlib.domain.data.PiwikInfo> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void enableMetricsForRepository( eu.dnetlib.domain.data.Repository repository, eu.dnetlib.domain.functionality.UserProfile requestor, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getPiwikScriptForRepository( java.lang.String repoId, AsyncCallback<java.lang.String> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getPiwikSitesForRepositories( AsyncCallback<java.util.List<eu.dnetlib.domain.data.PiwikInfo>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void markPiwikSiteAsValidated( java.lang.String repositoryId, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getMetricsInfoForRepository( java.lang.String repoId, AsyncCallback<eu.dnetlib.repo.manager.shared.MetricsInfo> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.repo.manager.client.services.RepositoryService
     */
    void getRepositoryAggregations( java.lang.String repoId, AsyncCallback<eu.dnetlib.repo.manager.shared.Aggregations> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static RepositoryServiceAsync instance;

        public static final RepositoryServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (RepositoryServiceAsync) GWT.create( RepositoryService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instantiated
        }
    }
}
