package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.RadioButton;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;

import java.util.List;

/**
 * Created by stefania on 2/10/16.
 */
public class SelectRepositoryOrJournalWidget implements IsWidget {

    private FlowPanel selectRepositoryOrJournalWidgetPanel = new FlowPanel();

    private Alert errorLabel = new Alert();

    private Form baseURLForm = new Form();

    private RadioButton chooseExistingBaseURLRadio = new RadioButton("baseURLRadio", "Select base URL from one of your registered repositories", false);
    private ListBox existingBaseURLsListBox = new ListBox();
    private RadioButton addManuallyRadio = new RadioButton("baseURLRadio", "or enter new", false);
    private TextBox baseURLTextBox = new TextBox();

    public SelectRepositoryOrJournalWidget(List<String> repositoryURLs) {

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setDismissable(false);
        errorLabel.setVisible(false);

        selectRepositoryOrJournalWidgetPanel.add(errorLabel);
        selectRepositoryOrJournalWidgetPanel.add(baseURLForm);

        chooseExistingBaseURLRadio.setValue(true);
        chooseExistingBaseURLRadio.setType(ButtonType.LINK);
        chooseExistingBaseURLRadio.addStyleName("validationSetRadio");
        chooseExistingBaseURLRadio.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                if(chooseExistingBaseURLRadio.getValue()) {
                    existingBaseURLsListBox.setEnabled(true);
                    baseURLTextBox.setEnabled(false);
                }
            }
        });
        baseURLForm.add(chooseExistingBaseURLRadio);

        existingBaseURLsListBox.addItem("-- none selected --", "noneSelected");
        for(String repositoryURL : repositoryURLs)
            existingBaseURLsListBox.addItem(repositoryURL, repositoryURL);
        baseURLForm.add(existingBaseURLsListBox);

        addManuallyRadio.setType(ButtonType.LINK);
        addManuallyRadio.addStyleName("validationSetRadio");
        addManuallyRadio.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                if(addManuallyRadio.getValue()) {
                    baseURLTextBox.setEnabled(true);
                    existingBaseURLsListBox.setEnabled(false);
                }
            }
        });
        baseURLForm.add(addManuallyRadio);

        baseURLTextBox.setEnabled(false);
        baseURLForm.add(baseURLTextBox);
    }

    @Override
    public Widget asWidget() {
        return selectRepositoryOrJournalWidgetPanel;
    }

    public String getSelectedBaseURL() {

        errorLabel.setVisible(false);

        if(chooseExistingBaseURLRadio.getValue()) {
            if(!existingBaseURLsListBox.getSelectedValue().equals("noneSelected"))
                return existingBaseURLsListBox.getSelectedValue();
            else {
                errorLabel.setText("You need to select a base URL");
                errorLabel.setVisible(true);
            }
        } else {
            if(baseURLTextBox.getValue()!=null && !baseURLTextBox.getValue().trim().isEmpty())
                return baseURLTextBox.getValue().trim();
            else {
                errorLabel.setText("You need to enter a base URL");
                errorLabel.setVisible(true);
            }
        }

        return null;
    }
}
