package eu.dnetlib.repo.manager.server.utils;

import com.google.gwt.user.client.rpc.IsSerializable;
import eu.dnetlib.repo.manager.shared.Timezone;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Configurable;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

@Configurable
public class LocalVocabularies implements IsSerializable {
	
	private static Logger logger = Logger.getLogger(LocalVocabularies.class);

	public static String loggedInField = "LOGGED_IN_FIELD";
	
	public static List<String> typologies;
	public static List<String> countries;
	public static List<Timezone> timezones;

	public static final String MODE_LOCAL = "local";
	public static final String MODE_DNET = "dnet";
	public static final String MODE_LDAP = "ldap";
	
	public static final String ENV_LAREFERENCIA = "lareferencia";
	public static final String ENV_MINCYT = "mincyt";
	public static final String ENV_OPENAIRE_PRODUCTION = "openaire-production";
	public static final String ENV_OPENAIRE_BETA = "openaire-beta";
	public static final String ENV_DEVELOPMENT = "development";

	static {

		typologies = new ArrayList<String>();
		countries = new ArrayList<String>();
		timezones = new ArrayList<Timezone>();
		
		try {
			logger.debug("loading typologies, countries, timezones and other constants");

			BufferedReader br = new BufferedReader(new InputStreamReader(LocalVocabularies.class.getResourceAsStream("/eu/dnetlib/repo/manager/server/utils/typologies.txt")));
			String line;
			while((line = br.readLine()) != null) {
				typologies.add(line.trim());
			}
			br.close();

			br = new BufferedReader(new InputStreamReader(LocalVocabularies.class.getResourceAsStream("/eu/dnetlib/repo/manager/server/utils/countries.txt")));
			while((line = br.readLine()) != null) {
				countries.add(line.trim());
			}
			br.close();
			
			br = new BufferedReader(new InputStreamReader(LocalVocabularies.class.getResourceAsStream("/eu/dnetlib/repo/manager/server/utils/timezones.txt")));
			while((line = br.readLine()) != null) {
				String parts[] = line.split("\t");
				if(parts.length < 2 || parts.length > 2)
					continue;
				String name = parts[1].trim();
				double offset = Double.parseDouble(parts[0].trim());
				Timezone timezone = new Timezone(name, offset);
				timezones.add(timezone);
			}
			br.close();
			
		} catch (Exception e) {
			logger.error("Error loading typologies, countries, timezones and other constants", e);
		}
	}

}

