/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.datasources.utils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repo.manager.client.datasources.utils.InterfaceFields;
import eu.dnetlib.repo.manager.client.datasources.utils.RepositoryInterfacesFormWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.AlertType;

public class RepositoryInterfacesFormWidget
implements IsWidget {
    private boolean hasInvalid = false;
    private FlowPanel contentPanel = new FlowPanel();
    private FlowPanel repositoryInterfacesPanel = new FlowPanel();
    private Alert errorAlert = new Alert();
    private Alert successAlert = new Alert();
    private FlowPanel repositoryInterfacesListPanel = new FlowPanel();
    private List<InterfaceFields> interfaceFieldsList = new ArrayList();
    private FlowPanel addNewInterfacePanel = new FlowPanel();
    private Anchor addNewInterfaceAnchor = new Anchor();
    private boolean hasSave;
    private Map<String, String> compatibilityClasses = new HashMap();
    private String mode;
    private boolean isUpdate;
    private String repositoryId;
    private RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);

    public RepositoryInterfacesFormWidget(String mode, boolean hasSave, Map<String, String> compatibilityClasses, boolean isUpdate) {
        this.hasSave = hasSave;
        this.compatibilityClasses.putAll(compatibilityClasses);
        this.mode = mode;
        this.isUpdate = isUpdate;
        this.contentPanel.addStyleName("uk-grid-margin uk-grid uk-grid-stack");
        this.repositoryInterfacesPanel.addStyleName("uk-width-1-1@m uk-first-column");
        this.successAlert.setType(AlertType.SUCCESS);
        this.successAlert.setDismissable(false);
        this.successAlert.setVisible(false);
        this.repositoryInterfacesPanel.add((Widget)this.successAlert);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.repositoryInterfacesPanel.add((Widget)this.errorAlert);
        this.repositoryInterfacesListPanel.addStyleName("interfacesForm");
        this.repositoryInterfacesListPanel.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-child-width-1-2@m uk-grid-small uk-grid uk-scrollspy-inview uk-animation-fade");
        this.repositoryInterfacesPanel.add((Widget)this.repositoryInterfacesListPanel);
        InterfaceFields interfaceFields = new InterfaceFields(hasSave, compatibilityClasses, mode, isUpdate);
        this.interfaceFieldsList.add(interfaceFields);
        this.repositoryInterfacesListPanel.add(interfaceFields.asWidget());
        1 deleteInterfaceListener = new /* Unavailable Anonymous Inner Class!! */;
        interfaceFields.setDeleteInterfaceListener((InterfaceFields.DeleteInterfaceListener)deleteInterfaceListener);
        FlowPanel addNewInterfaceBox = new FlowPanel();
        addNewInterfaceBox.addStyleName("el-item uk-card uk-card-default uk-card-body uk-scrollspy-inview uk-animation-fade");
        this.addNewInterfacePanel.add((Widget)addNewInterfaceBox);
        FlowPanel addNewInterfaceBoxContent = new FlowPanel();
        addNewInterfaceBoxContent.addStyleName("interface-box new");
        addNewInterfaceBox.add((Widget)addNewInterfaceBoxContent);
        this.addNewInterfaceAnchor.setHTML("<i class=\"fa fa-plus-square-o\"></i><span class=\"info\">Add new Interface</span>");
        this.addNewInterfaceAnchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        addNewInterfaceBoxContent.add((Widget)this.addNewInterfaceAnchor);
        this.repositoryInterfacesListPanel.add((Widget)this.addNewInterfacePanel);
    }

    public Widget asWidget() {
        return this.repositoryInterfacesPanel;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void clear() {
        this.repositoryInterfacesListPanel.clear();
        this.interfaceFieldsList = new ArrayList();
        InterfaceFields interfaceFields = new InterfaceFields(this.hasSave, this.compatibilityClasses, this.mode, this.isUpdate);
        3 deleteInterfaceListener = new /* Unavailable Anonymous Inner Class!! */;
        interfaceFields.setDeleteInterfaceListener((InterfaceFields.DeleteInterfaceListener)deleteInterfaceListener);
        this.interfaceFieldsList.add(interfaceFields);
        this.repositoryInterfacesListPanel.add(interfaceFields.asWidget());
        this.repositoryInterfacesListPanel.add((Widget)this.addNewInterfacePanel);
    }

    public void loadRepositoryInterfaces(List<RepositoryInterface> repositoryInterfaces, String repositoryId) {
        if (repositoryInterfaces != null && !repositoryInterfaces.isEmpty()) {
            this.repositoryInterfacesListPanel.clear();
            this.interfaceFieldsList = new ArrayList();
            for (RepositoryInterface repositoryInterface : repositoryInterfaces) {
                if (repositoryInterface.getContentDescription().equals("file::hybrid") || !repositoryInterface.getAccessProtocol().equalsIgnoreCase("oai")) continue;
                InterfaceFields interfaceFields = new InterfaceFields(this.hasSave, this.compatibilityClasses, this.mode, this.isUpdate);
                4 deleteInterfaceListener = new /* Unavailable Anonymous Inner Class!! */;
                interfaceFields.setDeleteInterfaceListener((InterfaceFields.DeleteInterfaceListener)deleteInterfaceListener);
                interfaceFields.loadRepositoryInterface(repositoryInterface, repositoryId);
                this.interfaceFieldsList.add(interfaceFields);
                this.repositoryInterfacesListPanel.add(interfaceFields.asWidget().asWidget());
            }
            this.repositoryInterfacesListPanel.add((Widget)this.addNewInterfacePanel);
        } else {
            this.clear();
        }
    }

    public List<RepositoryInterface> getRepositoryInterfaces() {
        this.hasInvalid = false;
        this.errorAlert.setVisible(false);
        this.successAlert.setVisible(false);
        ArrayList<RepositoryInterface> repositoryInterfaces = new ArrayList<RepositoryInterface>();
        for (InterfaceFields interfaceFields : this.interfaceFieldsList) {
            RepositoryInterface repositoryInterface = interfaceFields.getRepositoryInterface(false);
            if (repositoryInterface == null) continue;
            if (!interfaceFields.isValid()) {
                this.hasInvalid = true;
            }
            repositoryInterfaces.add(repositoryInterface);
        }
        if (repositoryInterfaces.isEmpty()) {
            this.errorAlert.setText("At least one interface is required");
            this.errorAlert.setVisible(true);
        } else if (this.hasInvalid) {
            this.errorAlert.setText("There are invalid interfaces");
            this.errorAlert.setVisible(true);
        }
        return repositoryInterfaces;
    }

    public boolean hasInvalid() {
        return this.hasInvalid;
    }

    private void deleteSelectedInterface(boolean checkForLastOne, InterfaceFields interfaceFields) {
        this.errorAlert.setVisible(false);
        this.successAlert.setVisible(false);
        if (checkForLastOne && this.interfaceFieldsList.size() == 1) {
            this.errorAlert.setText("You cannot delete the last interface");
            this.errorAlert.setVisible(true);
        } else if (this.isUpdate) {
            HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 35%; color: rgb(47, 64, 80); font-weight: bold;\">Deleting interface</div><div class=\"whiteFilm\"></div>");
            this.repositoryInterfacesPanel.addStyleName("loading-big");
            this.repositoryInterfacesPanel.add((Widget)loadingWheel);
            RepositoryInterface repositoryInterface = interfaceFields.getRepositoryInterface(true);
            if (repositoryInterface != null) {
                this.repositoryService.deleteInterface(this.repositoryId, repositoryInterface, this.mode, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.repositoryInterfacesPanel.removeStyleName("loading-big");
                this.repositoryInterfacesPanel.remove((Widget)loadingWheel);
                this.interfaceFieldsList.remove(interfaceFields);
                this.repositoryInterfacesListPanel.remove(interfaceFields.asWidget());
            }
        } else {
            this.interfaceFieldsList.remove(interfaceFields);
            this.repositoryInterfacesListPanel.remove(interfaceFields.asWidget());
        }
    }

    static /* synthetic */ void access$000(RepositoryInterfacesFormWidget x0, boolean x1, InterfaceFields x2) {
        x0.deleteSelectedInterface(x1, x2);
    }

    static /* synthetic */ String access$100(RepositoryInterfacesFormWidget x0) {
        return x0.repositoryId;
    }

    static /* synthetic */ List access$200(RepositoryInterfacesFormWidget x0) {
        return x0.interfaceFieldsList;
    }

    static /* synthetic */ FlowPanel access$300(RepositoryInterfacesFormWidget x0) {
        return x0.addNewInterfacePanel;
    }

    static /* synthetic */ FlowPanel access$400(RepositoryInterfacesFormWidget x0) {
        return x0.repositoryInterfacesListPanel;
    }

    static /* synthetic */ FlowPanel access$500(RepositoryInterfacesFormWidget x0) {
        return x0.repositoryInterfacesPanel;
    }

    static /* synthetic */ Alert access$600(RepositoryInterfacesFormWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ Alert access$700(RepositoryInterfacesFormWidget x0) {
        return x0.successAlert;
    }
}

