/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.getimpact;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

public class InstructionsForMetricsWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String restToken = "";
    private String repositoryId = "";
    private FlowPanel instructionsForMetricsBoxContent = new FlowPanel();
    private Alert errorAlert = new Alert();
    private RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);

    public InstructionsForMetricsWidget() {
        HTML title = new HTML("<h1 class=\"uk-article-title\">Metrics Configuration & Software Details</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)title);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.instructionsForMetricsBoxContent.add((Widget)this.errorAlert);
        this.contentPanel.add((Widget)this.instructionsForMetricsBoxContent);
    }

    public void clear() {
        this.instructionsForMetricsBoxContent.clear();
        this.errorAlert.setVisible(false);
        this.gridPanel.remove((Widget)this.helpPanel);
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        this.instructionsForMetricsBoxContent.add((Widget)this.errorAlert);
        helpService.getHelpById(this.parentToken + "_forDatasource_instructions", (AsyncCallback)new HelpCallback(this.helpPanel, this.gridPanel));
        HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repository information...</div><div class=\"whiteFilm\"></div>");
        this.instructionsForMetricsBoxContent.addStyleName("loading-big");
        this.instructionsForMetricsBoxContent.add((Widget)loadingWheel);
        this.repositoryService.getRepository(this.repositoryId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
        String[] tokenSplit = this.restToken.split("/", 2);
        this.repositoryId = tokenSplit[1];
    }

    public void afterAdditionToRootPanel() {
    }

    private FlowPanel showInstructions(PiwikInfo piwikInfo) {
        FlowPanel instructionsPanel = new FlowPanel();
        String instructions = "<p>OpenAIRE\u2019s usage statistic service uses the <i>Piwik Open Source Analytics platform</i> (piwik.org)  to track usage activity. When <i>metrics</i> are enabled for a repository, two unique identifiers are generated - a piwik-ID that associates the repository with its usage events in Piwik and an authentication-ID that allows to track usage activity on the Piwik platform. Metadata views and item downloads are tracked and automatically sent to Piwik. Statistics are generated using the COUNTER Code of practice directives.</p>";
        instructions = instructions + "OpenAIRE's usage statistics service tracking code exploits Piwik\u2019s API. In order to make the tracking of usage events from repositories more robust, it was necessary to implement repository platform specific patches and plugins starting with DSpace and EPrints. The code is maintained on Github:";
        instructions = instructions + "<ul><li>as a patch for various versions of DSpace (<a target=\"_blank\" href=\"https://github.com/openaire/OpenAIRE-Piwik-DSpace\">https://github.com/openaire/OpenAIRE-Piwik-DSpace</a>)</li><li>as an EPrints plugin for version 3 (<a target=\"_blank\" href=\"https://github.com/openaire/EPrints-OAPiwik\">https://github.com/openaire/EPrints-OAPiwik</a>)</li></ul>";
        instructions = instructions + "<p>To configure your repository to allow tracking in Piwik platform, please change the configuration files with the following parameters and values, generated for your site:</p><dl class=\"uk-description-list\">    <dt>PiwikID</dt>\n    <dd>" + piwikInfo.getSiteId() + "</dd>\n    <dt>AuthenticationToken</dt>\n    <dd>" + piwikInfo.getAuthenticationToken() + "</dd>\n</dl>";
        instructions = instructions + "<p>Details for the configuration files are given in the README of the tracking code.</p>";
        instructions = instructions + "<div class=\"uk-alert uk-alert-info\"><strong>NOTE</strong> - You will be informed by e-mail that the installation of the tracking code has been validated and when the usage statistics will be available.</div>";
        HTML instructionsHTML = new HTML();
        instructionsHTML.setHTML(instructions);
        instructionsPanel.add((Widget)instructionsHTML);
        return instructionsPanel;
    }

    static /* synthetic */ FlowPanel access$000(InstructionsForMetricsWidget x0) {
        return x0.instructionsForMetricsBoxContent;
    }

    static /* synthetic */ Alert access$100(InstructionsForMetricsWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ FlowPanel access$200(InstructionsForMetricsWidget x0, PiwikInfo x1) {
        return x0.showInstructions(x1);
    }

    static /* synthetic */ RepositoryServiceAsync access$300(InstructionsForMetricsWidget x0) {
        return x0.repositoryService;
    }
}

