/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.server.utils;

import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.repo.manager.server.config.CascadingPropertyLoader;
import eu.dnetlib.repo.manager.server.utils.EmailUtils;
import eu.dnetlib.utils.MailLibrary;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EmailUtilsImpl
implements EmailUtils {
    private static Logger LOGGER = Logger.getLogger(EmailUtilsImpl.class);
    private List<String> specialRecipients = new ArrayList();
    private boolean override = false;
    private boolean logonly = false;
    private String overrideEmail = null;
    private String from = null;
    @Autowired
    private MailLibrary mailLibrary;
    @Autowired
    private CascadingPropertyLoader pLoader;
    @Value(value="${services.repo-manager.baseUrl}")
    private String baseUrl;
    @Value(value="${services.repo-manager.adminEmail}")
    private String adminEmail;
    @Value(value="${services.repomanager.usagestats.adminEmail}")
    private String usageStatsAdminEmail;

    public void sendActivationEmail(UserProfile user, String activationId) throws Exception {
        try {
            this.sendMail(user.getEmail(), this.getEmailProperty("user.registration.mail.subject"), "Dear " + user.getFirstname() + " " + user.getLastname() + ",\n" + this.getEmailProperty("user.registration.mail.message") + ": " + this.baseUrl + "?activationId=" + activationId + "#activateAccount", false, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while sending activation email to user: " + user.getEmail()), (Throwable)e);
            throw e;
        }
    }

    public void sendResetPasswordEmail(String email, String securityCode) throws Exception {
        try {
            this.sendMail(email, this.getEmailProperty("user.forgotPassword.mail.Subject"), this.getEmailProperty("user.forgotPassword.mail.Body1") + ": " + this.baseUrl + "?securityCode=" + securityCode + "#resetPassword\n\n" + this.getEmailProperty("user.forgotPassword.mail.Body2") + ": " + securityCode, false, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while sending activation email to user: " + email), (Throwable)e);
            throw e;
        }
    }

    public void reportException(Exception exception) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        exception.printStackTrace(printWriter);
        ArrayList<String> recipients = new ArrayList<String>();
        try {
            recipients.add(this.adminEmail);
            String message = "An exception has occurred:\n" + ((Object)writer).toString();
            String subject = "Automatic Bug Report";
            this.sendMail(recipients, subject, message, false, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error sending error report", (Throwable)e);
        }
    }

    public void sendAdministratorRequestToEnableMetrics(PiwikInfo piwikInfo) throws Exception {
        try {
            String subject = "[OpenAIRE-Usage Statistics] New request to enable usage statistics";
            String message = "Dear administrator,\n\nwe have received a request to enable the OpenAIRE usage statistics for the following repository \n\nRepository - " + piwikInfo.getRepositoryName() + ", " + piwikInfo.getCountry() + " (" + piwikInfo.getRepositoryId() + ")\nRequestor - " + piwikInfo.getRequestorName() + ", " + piwikInfo.getRequestorEmail() + "\nPiwik ID - " + piwikInfo.getSiteId() + "\nAuthentication token - " + piwikInfo.getAuthenticationToken() + "\n\nFor more information about this request, go here: \n" + this.baseUrl + "/#admin/metrics\n\nBest,\nThe OpenAIRE team";
            this.sendMail(this.usageStatsAdminEmail, subject, message, false, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while sending request to enable metrics email to administrator: " + this.usageStatsAdminEmail), (Throwable)e);
            throw e;
        }
    }

    public void sendUserRequestToEnableMetrics(PiwikInfo piwikInfo) throws Exception {
        try {
            String subject = "[OpenAIRE-Usage Statistics] Your request to enable usage statistics";
            String message = "Dear " + piwikInfo.getRequestorName() + ",\n\nwe have received your request to enable the OpenAIRE usage statistics for your repository\n\nRepository - " + piwikInfo.getRepositoryName() + ", " + piwikInfo.getCountry() + " (" + piwikInfo.getRepositoryId() + ")\nPiwik ID - " + piwikInfo.getSiteId() + "\nAuthentication token - " + piwikInfo.getAuthenticationToken() + "\n\nIn order to enable the usage statistics, you must install the OpenAIRE's tracking code in your repository software. OpenAIRE's usage statistics service tracking code is maintained on Github as a patch for various versions of DSpace (https://github.com/openaire/OpenAIRE-Piwik-DSpace) and as an Eprints plugin for version 3 (https://github.com/openaire/EPrints-OAPiwik). In case the platform is different from DSpace or EPrints please contact the OpenAIRE team in repositoryusagestats@openaire.eu in order to find a solution.\n\nFor more information about your request and configuration details, go here: \n" + this.baseUrl + "/#getImpact/instructions/" + piwikInfo.getRepositoryId() + "\n\nOnce you have finished configuring your repository or if you have any questions, please notify the OpenAIRE team by sending \nan email to repositoryusagestats@openaire.eu\n\nBest,\nThe OpenAIRE team";
            this.sendMail(piwikInfo.getRequestorEmail(), subject, message, false, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while sending request to enable metrics email to user: " + piwikInfo.getRequestorEmail()), (Throwable)e);
            throw e;
        }
    }

    public void sendAdministratorMetricsEnabled(PiwikInfo piwikInfo) throws Exception {
        try {
            String subject = "[OpenAIRE-Usage Statistics] Usage statistics have been enabled";
            String message = "Dear administrator,\n\nThe installation and configuration of OpenAIRE's tracking code for the following repository has been completed and validated and the usage statistics have been enabled in OpenAIRE.\n\nRepository - " + piwikInfo.getRepositoryName() + ", " + piwikInfo.getCountry() + " (" + piwikInfo.getRepositoryId() + ")\nRequestor - " + piwikInfo.getRequestorName() + ", " + piwikInfo.getRequestorEmail() + "\nPiwik ID - " + piwikInfo.getSiteId() + "\nAuthentication token - " + piwikInfo.getAuthenticationToken() + "\n\nBest,\nThe OpenAIRE team";
            this.sendMail(piwikInfo.getRequestorEmail(), subject, message, false, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while sending metrics enabled notification email to administator: " + this.usageStatsAdminEmail), (Throwable)e);
            throw e;
        }
    }

    public void sendUserMetricsEnabled(PiwikInfo piwikInfo) throws Exception {
        try {
            String subject = "[OpenAIRE-Usage Statistics] Usage statistics have been enabled";
            String message = "Dear " + piwikInfo.getRequestorName() + ",\n\nThe installation and configuration of OpenAIRE's tracking code for your repository \"" + piwikInfo.getRepositoryName() + "\" has been completed and validated and the usage statistics have been enabled in OpenAIRE.\n\nYou can preview the statistics in your repository's dashboard: \n" + this.baseUrl + "/#getImpact/" + piwikInfo.getRepositoryId() + "\n\n For more information and questions, you can contact the openaire support team by sending an email to repositoryusagestats@openaire.eu\n\nBest,\nThe OpenAIRE team";
            this.sendMail(piwikInfo.getRequestorEmail(), subject, message, false, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while sending metrics enabled notification email to user: " + piwikInfo.getRequestorEmail()), (Throwable)e);
            throw e;
        }
    }

    private void sendMail(String email, String subject, String message, boolean sendToSpecial, List<String> repoAdminMails) throws Exception {
        ArrayList<String> to = new ArrayList<String>();
        to.add(email);
        this.sendMail(to, subject, message, sendToSpecial, repoAdminMails);
    }

    private void sendMail(List<String> recipients, String subject, String message, boolean sendToSpecial, List<String> repoAdminMails) throws Exception {
    }

    private String getEmailProperty(String key) {
        return this.pLoader.getProperties().getProperty(key);
    }

    public void setSpecialRecipients(String specialRecipients) {
        String[] recps;
        for (String recp : recps = specialRecipients.split(",")) {
            recp = recp.trim();
            this.specialRecipients.add(recp);
        }
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public void setOverrideEmail(String overrideEmail) {
        this.overrideEmail = overrideEmail;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isLogonly() {
        return this.logonly;
    }

    public void setLogonly(boolean logonly) {
        this.logonly = logonly;
    }
}

