package eu.dnetlib.repo.manager.client.admin.helptexts;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.AdminWidget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.gwt.shared.Help;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.IconPosition;

import java.util.List;

/**
 * Created by stefania on 3/9/16.
 */
public class HelpTextsAdminWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

//    private static HelpTextsAdminWidget instance = null;
//
//    private String parentToken = "";
//    private String restToken = "";
//
//    private FlowPanel helpAdminPanel = new FlowPanel();
//
//    private FlowPanel myRepositoriesListPanel = new FlowPanel();
//    private FlowPanel myRepositoriesListInnerPanel = new FlowPanel();
//    private FlowPanel myRepositoriesListBox = new FlowPanel();
//    private FlowPanel myRepositoriesListBoxContent = new FlowPanel();
//
//    private FlowPanel actionButtonsPanel = new FlowPanel();
//
//    private FlowPanel sidePanel = new FlowPanel();
//    private FlowPanel previewPanel = new FlowPanel();
//    private FlowPanel previewPanelContent = new FlowPanel();
//    private FlowPanel helpPanel = new FlowPanel();

    private String parentToken = "";
    private String restToken = "";

    private FlowPanel helpTextsAdminBoxContent = new FlowPanel();

    private FlowPanel actionButtonsPanel = new FlowPanel();

    private Alert errorAlert = new Alert();

//    private FlowPanel helpPanel = new FlowPanel();
    private FlowPanel helpText = new FlowPanel();
    private FlowPanel preview = new FlowPanel();

    private AdminWidget helpTextsAdminWidget = new AdminWidget(preview, false);

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    public HelpTextsAdminWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Help Texts Admin</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        helpTextsAdminBoxContent.add(errorAlert);

        contentPanel.add(helpTextsAdminBoxContent);
        gridPanel.add(helpPanel);

//        helpAdminPanel.addStyleName("row");
//
//        myRepositoriesListPanel.addStyleName("col-lg-9");
//        myRepositoriesListPanel.add(myRepositoriesListInnerPanel);
//
//        myRepositoriesListInnerPanel.addStyleName("wrapper wrapper-content animated fadeInUp");
//        myRepositoriesListInnerPanel.add(myRepositoriesListBox);
//
//        myRepositoriesListBox.addStyleName("ibox");
//        myRepositoriesListBox.add(myRepositoriesListBoxContent);
//
//        myRepositoriesListBoxContent.addStyleName("ibox-content");
//
//        sidePanel.addStyleName("col-lg-3");
//        sidePanel.add(previewPanel);

        HTML tt = new HTML();

        tt.setHTML("<div class=\"previewTitle\">PREVIEW</div>");
        preview.addStyleName("previewPanel");
//        preview.add(new HTML("<div class=\"previewTitle\">PREVIEW</div>"));

        preview.clear();
        preview.add(tt);
        helpPanel.add(preview);

        actionButtonsPanel.addStyleName("helpAdminActionButtons");

        Button preview = new Button();
        Button submit = new Button();

        preview.setText("Preview");
//        preview.addStyleName("btn-grey-light");
//        preview.removeStyleName("btn-default");
        preview.setIconPosition(IconPosition.RIGHT);
        preview.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                helpTextsAdminWidget.previewHelpText();
            }
        });

        submit.setText("Submit Changes");
        preview.addStyleName("uk-button-primary");
//        submit.addStyleName("btn-grey-light");
//        submit.removeStyleName("btn-default");
        submit.setIconPosition(IconPosition.RIGHT);
        submit.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                helpTextsAdminWidget.saveHelpText();
            }
        });

        actionButtonsPanel.add(preview);
        actionButtonsPanel.add(submit);

//        helpAdminPanel.add(myRepositoriesListPanel);
//        helpAdminPanel.add(sidePanel);

        AdminWidget.HelpTextUpdatedListener helpTextUpdatedListener = new AdminWidget.HelpTextUpdatedListener() {

            @Override
            public void helpTextUpdated(Help updatedHelp) {
                if(updatedHelp!=null && updatedHelp.getId().equals(parentToken))
                    helpService.getHelpById(parentToken, new HelpCallback(helpText, helpPanel));
            }
        };
        helpTextsAdminWidget.setHelpTextUpdatedListener(helpTextUpdatedListener);
    }

    @Override
    public void clear() {

        helpTextsAdminBoxContent.clear();
        errorAlert.setVisible(false);
        helpPanel.remove(helpText);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        helpTextsAdminBoxContent.add(errorAlert);

        helpService.getHelpById(parentToken, new HelpCallback(helpText, helpPanel));

        helpTextsAdminWidget.setToken("");
        helpTextsAdminWidget.setEditorUIColor("#d4dee7");
        helpTextsAdminWidget.clear();
        helpTextsAdminWidget.reload();

//        FlowPanel rowPanel = new FlowPanel();
//        rowPanel.addStyleName("row");
//        myRepositoriesListBoxContent.add(rowPanel);
//
//        FlowPanel colPanel = new FlowPanel();
//        colPanel.addStyleName("col-lg-12");
//        rowPanel.add(colPanel);
//
//        HTML title = new HTML("<h1>Monitor Help Texts</h1>");
//        title.addStyleName("m-b-md");
//        colPanel.add(title);
//
//        helpTextsAdminWidget.addStyleName("col-lg-12");
        helpTextsAdminBoxContent.add(helpTextsAdminWidget.asWidget());

        helpTextsAdminBoxContent.add(actionButtonsPanel);

        helpService.getAll(new AsyncCallback<List<Help>>() {

            @Override
            public void onFailure(Throwable caught) {

            }

            @Override
            public void onSuccess(List<Help> helpTexts) {
                helpTextsAdminWidget.setHelpTexts(helpTexts);
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {
        helpTextsAdminWidget.afterAdditionToRootPanel();
    }
}
