package eu.dnetlib.repo.manager.client.datasources.utils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by stefania on 12/23/15.
 */
public class RepositoryInterfacesFormWidget implements IsWidget {

    private boolean hasInvalid = false;

    private FlowPanel contentPanel = new FlowPanel();

    private FlowPanel repositoryInterfacesPanel = new FlowPanel();

    private Alert errorAlert = new Alert();
    private Alert successAlert = new Alert();

    private FlowPanel repositoryInterfacesListPanel = new FlowPanel();

    private List<InterfaceFields> interfaceFieldsList = new ArrayList<InterfaceFields>();

    private FlowPanel addNewInterfacePanel = new FlowPanel();
    private Anchor addNewInterfaceAnchor = new Anchor();

    private boolean hasSave;
    private Map<String, String> compatibilityClasses = new HashMap<String, String>();
    private String mode;
    private boolean isUpdate;

    private String repositoryId;

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    public RepositoryInterfacesFormWidget(final String mode, final boolean hasSave,
                                          final Map<String, String> compatibilityClasses, final boolean isUpdate) {

        this.hasSave = hasSave;
        this.compatibilityClasses.putAll(compatibilityClasses);
        this.mode = mode;
        this.isUpdate = isUpdate;

//        repositoryInterfacesPanel.addStyleName("row");
        contentPanel.addStyleName("uk-grid-margin uk-grid uk-grid-stack");
        repositoryInterfacesPanel.addStyleName("uk-width-1-1@m uk-first-column");

        successAlert.setType(AlertType.SUCCESS);
        successAlert.setDismissable(false);
        successAlert.setVisible(false);
        repositoryInterfacesPanel.add(successAlert);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        repositoryInterfacesPanel.add(errorAlert);

        repositoryInterfacesListPanel.addStyleName("interfacesForm");
        repositoryInterfacesListPanel.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-child-width-1-2@m uk-grid-small uk-grid uk-scrollspy-inview uk-animation-fade");
        repositoryInterfacesPanel.add(repositoryInterfacesListPanel);

        final InterfaceFields interfaceFields = new InterfaceFields(hasSave, compatibilityClasses, mode, isUpdate);
        interfaceFieldsList.add(interfaceFields);
        repositoryInterfacesListPanel.add(interfaceFields.asWidget());

        InterfaceFields.DeleteInterfaceListener deleteInterfaceListener = new InterfaceFields.DeleteInterfaceListener() {
            @Override
            public void deleteInterface(boolean checkForLastOne) {
                deleteSelectedInterface(checkForLastOne, interfaceFields);
            }
        };
        interfaceFields.setDeleteInterfaceListener(deleteInterfaceListener);

//        addNewInterfacePanel.addStyleName("col-md-6");

        FlowPanel addNewInterfaceBox = new FlowPanel();
//        addNewInterfaceBox.addStyleName("ibox");
        addNewInterfaceBox.addStyleName("el-item uk-card uk-card-default uk-card-body uk-scrollspy-inview uk-animation-fade");
        addNewInterfacePanel.add(addNewInterfaceBox);

        FlowPanel addNewInterfaceBoxContent = new FlowPanel();
//        addNewInterfaceBoxContent.addStyleName("ibox-content interface-box new");
        addNewInterfaceBoxContent.addStyleName("interface-box new");
        addNewInterfaceBox.add(addNewInterfaceBoxContent);


        addNewInterfaceAnchor.setHTML("<i class=\"fa fa-plus-square-o\"></i><span class=\"info\">Add new Interface</span>");
        addNewInterfaceAnchor.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                final InterfaceFields interfaceFields = new InterfaceFields(hasSave, compatibilityClasses, mode, isUpdate);
                interfaceFields.setRepositoryId(repositoryId);
                interfaceFieldsList.add(interfaceFields);
                repositoryInterfacesListPanel.insert(interfaceFields.asWidget(),
                        repositoryInterfacesListPanel.getWidgetIndex(addNewInterfacePanel));

                InterfaceFields.DeleteInterfaceListener deleteInterfaceListener = new InterfaceFields.DeleteInterfaceListener() {
                    @Override
                    public void deleteInterface(boolean checkForLastOne) {
                        deleteSelectedInterface(checkForLastOne, interfaceFields);
                    }
                };
                interfaceFields.setDeleteInterfaceListener(deleteInterfaceListener);
            }
        });

        addNewInterfaceBoxContent.add(addNewInterfaceAnchor);

        repositoryInterfacesListPanel.add(addNewInterfacePanel);
    }

    @Override
    public Widget asWidget() {
        return repositoryInterfacesPanel;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void clear() {

        repositoryInterfacesListPanel.clear();
        interfaceFieldsList = new ArrayList<InterfaceFields>();

        final InterfaceFields interfaceFields = new InterfaceFields(hasSave, compatibilityClasses, mode, isUpdate);

        InterfaceFields.DeleteInterfaceListener deleteInterfaceListener = new InterfaceFields.DeleteInterfaceListener() {
            @Override
            public void deleteInterface(boolean checkForLastOne) {
                deleteSelectedInterface(checkForLastOne, interfaceFields);
            }
        };
        interfaceFields.setDeleteInterfaceListener(deleteInterfaceListener);

        interfaceFieldsList.add(interfaceFields);
        repositoryInterfacesListPanel.add(interfaceFields.asWidget());
        repositoryInterfacesListPanel.add(addNewInterfacePanel);
    }

    public void loadRepositoryInterfaces(List<RepositoryInterface> repositoryInterfaces, String repositoryId) {

        if(repositoryInterfaces!=null && !repositoryInterfaces.isEmpty()) {

            repositoryInterfacesListPanel.clear();
            interfaceFieldsList = new ArrayList<InterfaceFields>();

            for (RepositoryInterface repositoryInterface : repositoryInterfaces) {

                if (!repositoryInterface.getContentDescription().equals("file::hybrid")
                        && repositoryInterface.getAccessProtocol().equalsIgnoreCase("oai")) {

                    final InterfaceFields interfaceFields = new InterfaceFields(hasSave, compatibilityClasses, mode, isUpdate);

                    InterfaceFields.DeleteInterfaceListener deleteInterfaceListener = new InterfaceFields.DeleteInterfaceListener() {
                        @Override
                        public void deleteInterface(boolean checkForLastOne) {
                            deleteSelectedInterface(checkForLastOne, interfaceFields);
                        }
                    };
                    interfaceFields.setDeleteInterfaceListener(deleteInterfaceListener);

                    interfaceFields.loadRepositoryInterface(repositoryInterface, repositoryId);
                    interfaceFieldsList.add(interfaceFields);
                    repositoryInterfacesListPanel.add(interfaceFields.asWidget().asWidget());
                }
            }
            repositoryInterfacesListPanel.add(addNewInterfacePanel);

        } else {
            clear();
        }
    }

    public List<RepositoryInterface> getRepositoryInterfaces() {

        hasInvalid = false;

        errorAlert.setVisible(false);
        successAlert.setVisible(false);

        List<RepositoryInterface> repositoryInterfaces = new ArrayList<RepositoryInterface>();

        for(InterfaceFields interfaceFields : interfaceFieldsList) {

            RepositoryInterface repositoryInterface = interfaceFields.getRepositoryInterface(false);
            if(repositoryInterface!=null) {
                if(!interfaceFields.isValid())
                    hasInvalid = true;
                repositoryInterfaces.add(repositoryInterface);
            }
        }

        if(repositoryInterfaces.isEmpty()) {
            errorAlert.setText("At least one interface is required");
            errorAlert.setVisible(true);
        } else if(hasInvalid) {
            errorAlert.setText("There are invalid interfaces");
            errorAlert.setVisible(true);
        }

        return repositoryInterfaces;
    }

    public boolean hasInvalid() {
        return hasInvalid;
    }

    private void deleteSelectedInterface(boolean checkForLastOne, final InterfaceFields interfaceFields) {

        errorAlert.setVisible(false);
        successAlert.setVisible(false);

        if(checkForLastOne && interfaceFieldsList.size()==1) {
            errorAlert.setText("You cannot delete the last interface");
            errorAlert.setVisible(true);
        } else {

            if(isUpdate) {

                final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 35%; " +
                        "color: rgb(47, 64, 80); font-weight: bold;\">Deleting interface</div><div class=\"whiteFilm\"></div>");
                repositoryInterfacesPanel.addStyleName("loading-big");
                repositoryInterfacesPanel.add(loadingWheel);

                RepositoryInterface repositoryInterface = interfaceFields.getRepositoryInterface(true);

                if(repositoryInterface!=null) {

                    repositoryService.deleteInterface(repositoryId, repositoryInterface, mode, new AsyncCallback<Void>() {

                        @Override
                        public void onFailure(Throwable caught) {

                            repositoryInterfacesPanel.removeStyleName("loading-big");
                            repositoryInterfacesPanel.remove(loadingWheel);

                            errorAlert.setText("System error deleting interface");
                            errorAlert.setVisible(true);
                        }

                        @Override
                        public void onSuccess(Void result) {

                            repositoryInterfacesPanel.removeStyleName("loading-big");
                            repositoryInterfacesPanel.remove(loadingWheel);

                            successAlert.setText("Interface deleted successfully");
                            successAlert.setVisible(true);

                            interfaceFieldsList.remove(interfaceFields);
                            repositoryInterfacesListPanel.remove(interfaceFields.asWidget());
                        }
                    });

                } else {

                    repositoryInterfacesPanel.removeStyleName("loading-big");
                    repositoryInterfacesPanel.remove(loadingWheel);

                    interfaceFieldsList.remove(interfaceFields);
                    repositoryInterfacesListPanel.remove(interfaceFields.asWidget());
                }

            } else {
                interfaceFieldsList.remove(interfaceFields);
                repositoryInterfacesListPanel.remove(interfaceFields.asWidget());
            }
        }
    }
}
