package eu.dnetlib.repo.manager.client.enrichcontent.advancedsearch;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.MyFormGroup;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.constants.FormType;
import org.gwtbootstrap3.client.ui.constants.IconType;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by stefania on 11/1/16.
 */
public class MultiTextBoxFieldSet implements IsWidget {

    private FlowPanel stringsPanel = new FlowPanel();

    private Form multipleStringsForm = new Form();

    private FlowPanel multipleStringPanel = new FlowPanel();
    private List<SingleTextBoxField> stringFieldsList = new ArrayList<SingleTextBoxField>();

//    private Label documentationLabel = new Label();

    private Anchor addMore = new Anchor();

    public MultiTextBoxFieldSet(String label) {

        stringsPanel.add(multipleStringsForm);

        multipleStringsForm.addStyleName("uk-form-horizontal");
//        multipleStringsForm.setType(FormType.HORIZONTAL);
        multipleStringsForm.add(new MyFormGroup(false, label, multipleStringPanel));

        final SingleTextBoxField stringField = new SingleTextBoxField();
        stringFieldsList.add(stringField);
        multipleStringPanel.add(stringField.asWidget());

        SingleTextBoxField.DeleteKeywordListener deleteKeywordListener = new SingleTextBoxField.DeleteKeywordListener() {
            @Override
            public void deleteKeyword() {
                stringFieldsList.remove(stringField);
                multipleStringPanel.remove(stringField.asWidget());
            }
        };
        stringField.setDeleteKeywordListener(deleteKeywordListener);

        addMore.setIcon(IconType.PLUS);
        addMore.setText("Add another");
        addMore.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent clickEvent) {

                final SingleTextBoxField stringField = new SingleTextBoxField();
                stringFieldsList.add(stringField);
                multipleStringPanel.insert(stringField.asWidget(), multipleStringPanel.getWidgetIndex(addMore));
                SingleTextBoxField.DeleteKeywordListener deleteKeywordListener = new SingleTextBoxField.DeleteKeywordListener() {
                    @Override
                    public void deleteKeyword() {
                        stringFieldsList.remove(stringField);
                        multipleStringPanel.remove(stringField.asWidget());
                    }
                };
                stringField.setDeleteKeywordListener(deleteKeywordListener);
            }
        });
        multipleStringPanel.add(addMore);

//        if(ModelDocumentation.documentationMap.get(ModelDocumentation.project + "." + ModelDocumentation.keywordSets + "." + ModelDocumentation.value)!=null) {
//            documentationLabel.setText(ModelDocumentation.documentationMap.get(ModelDocumentation.project + "." + ModelDocumentation.keywordSets + "."
//                    + ModelDocumentation.value));
//            multipleStringPanel.add(documentationLabel);
//        }
//        documentationLabel.addStyleName("comment");
//        documentationLabel.addStyleName("fontItalic");
    }

    @Override
    public Widget asWidget() {
        return stringsPanel;
    }

    public void clear() {

        multipleStringPanel.clear();
        stringFieldsList = new ArrayList<SingleTextBoxField>();

        final SingleTextBoxField stringField = new SingleTextBoxField();
        SingleTextBoxField.DeleteKeywordListener deleteKeywordListener = new SingleTextBoxField.DeleteKeywordListener() {
            @Override
            public void deleteKeyword() {
                stringFieldsList.remove(stringField);
                multipleStringPanel.remove(stringField.asWidget());
            }
        };
        stringField.setDeleteKeywordListener(deleteKeywordListener);

        stringFieldsList.add(stringField);
        multipleStringPanel.add(stringField.asWidget());
        multipleStringPanel.add(addMore);
//        multipleStringPanel.add(documentationLabel);
    }

    public void loadValues(List<String> values) {

        if(values !=null && !values.isEmpty()) {
            multipleStringPanel.clear();
            stringFieldsList = new ArrayList<SingleTextBoxField>();

            for (String value : values) {

                final SingleTextBoxField keywordField = new SingleTextBoxField();
                SingleTextBoxField.DeleteKeywordListener deleteKeywordListener = new SingleTextBoxField.DeleteKeywordListener() {
                    @Override
                    public void deleteKeyword() {
                        stringFieldsList.remove(keywordField);
                        multipleStringPanel.remove(keywordField.asWidget());
                    }
                };
                keywordField.setDeleteKeywordListener(deleteKeywordListener);
                keywordField.loadValue(value);
                stringFieldsList.add(keywordField);
                multipleStringPanel.add(keywordField.asWidget());
            }
            multipleStringPanel.add(addMore);
//            multipleStringPanel.add(documentationLabel);

        } else {
            clear();
        }
    }

    public List<String> getValues() {

        List<String> values = new ArrayList<String>();

        for(SingleTextBoxField stringField : stringFieldsList) {

            String value = stringField.getValue();
            if(value!=null)
                values.add(value);
        }

        return values;
    }
}
