package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.Rule;
import eu.dnetlib.repo.manager.shared.Vocabulary;
import org.gwtbootstrap3.client.ui.CheckBox;

import java.util.*;

/**
 * Created by stefania on 3/8/16.
 */
public class MultiSelectWidget implements IsWidget {

    private FlowPanel multiSelectPanel = new FlowPanel();
    private FlowPanel multiSelectInnerPanel = new FlowPanel();

    private CheckBox selectAllCheckBox;
    final private List<CheckBox> checkBoxes = new ArrayList<CheckBox>();

    private Map<CheckBox, Vocabulary> checkBoxRule = new HashMap<CheckBox, Vocabulary>();

    public MultiSelectWidget(List<Vocabulary> vocabularyList, String name) {

        multiSelectPanel.add(multiSelectInnerPanel);

        multiSelectInnerPanel.addStyleName("margin10");

        selectAllCheckBox = new CheckBox("Select / Deselect All " + name);
        selectAllCheckBox.setValue(true);
        selectAllCheckBox.addStyleName("selectAll");
        selectAllCheckBox.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {

                for(CheckBox checkBox : checkBoxes)
                    checkBox.setValue(selectAllCheckBox.getValue());
            }
        });
        multiSelectInnerPanel.add(selectAllCheckBox);

        for(Vocabulary vocabulary : vocabularyList) {
            CheckBox checkBox = new CheckBox(vocabulary.getName());
            checkBox.setValue(true);
            checkBoxes.add(checkBox);
            checkBoxRule.put(checkBox, vocabulary);
            multiSelectInnerPanel.add(checkBox);
        }
    }

    @Override
    public Widget asWidget() {
        return multiSelectPanel;
    }

    public List<String> getSelections() {

        List<String> selections = new ArrayList<String>();

        for(CheckBox checkBox : checkBoxes) {
            if (checkBox.getValue())
                selections.add(checkBoxRule.get(checkBox).getId());
        }

        return selections;
    }

    public void addStyleName(String styleName) {
        multiSelectPanel.addStyleName(styleName);
    }
}
