package eu.dnetlib.repo.manager.client;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.History;
import eu.dnetlib.domain.functionality.UserProfile;

/**
 * Created by stefania on 12/2/15.
 */
public class NavigationManager {

    private static NavigationManager instance = null;

    private NavigationManager() {

    }

    public static final NavigationManager getInstance() {

        if(instance==null)
            instance = new NavigationManager();

        return instance;
    }

    public void navigate(String token) {

        //TODO use role instead of email
        if(RepositoryManager.currentUserRole.equals("admin")) {
            Document.get().getElementById("adminMenuHeader").getStyle().setDisplay(Style.Display.BLOCK);
            Document.get().getElementById("adminMenuHelpTexts").getStyle().setDisplay(Style.Display.BLOCK);
            Document.get().getElementById("adminMenuMetrics").getStyle().setDisplay(Style.Display.BLOCK);

            Document.get().getElementById("admin1").getStyle().setDisplay(Style.Display.BLOCK);
        } else {
            Document.get().getElementById("adminMenuHeader").getStyle().setDisplay(Style.Display.NONE);
            Document.get().getElementById("adminMenuHelpTexts").getStyle().setDisplay(Style.Display.NONE);
            Document.get().getElementById("adminMenuMetrics").getStyle().setDisplay(Style.Display.NONE);

            Document.get().getElementById("admin1").getStyle().setDisplay(Style.Display.NONE);
        }

        RepositoryManager.previousToken = RepositoryManager.currentToken;
        RepositoryManager.currentToken = token;

        if (token.equals("landing")) {

            LandingPage.getInstance().showLandingPage();

        } else if (token.equals("login")) {

            LoginPage.getInstance().showLoginPage();
            LoginPage.LoginListener loginListener = new LoginPage.LoginListener() {
                @Override
                public void loginSucceeded(UserProfile userProfile) {

                    if (RepositoryManager.currentUser != null) {

                        String content = "<span class=\"uk-margin-small-right uk-icon\"><svg height=\"20\" ratio=\"1\" " +
                                "viewBox=\"0 0 20 20\" width=\"20\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"9.9\" " +
                                "cy=\"6.4\" fill=\"none\" r=\"4.4\" stroke=\"#000\" stroke-width=\"1.1\"></circle>" +
                                "<path d=\"M1.5,19 C2.3,14.5 5.8,11.2 10,11.2 C14.2,11.2 17.7,14.6 18.5,19.2\" fill=\"none\" " +
                                "stroke=\"#000\" stroke-width=\"1.1\"></path></svg></span>" +
                                RepositoryManager.currentUser.getFirstname() + " " + RepositoryManager.currentUser.getLastname();
                        Document.get().getElementById("currentUser").setInnerHTML(content);
                    }
                    History.newItem("dashboard");
                }
            };
            LoginPage.getInstance().setLoginListener(loginListener);

        } else if (token.equals("register")) {

            RegisterPage.getInstance().showRegisterPage();

        } else {

            RepositoryManagerPage.getInstance().showRepositoryManagerPage();

            //TODO add catch page not found exception
            RepositoryManagerController.getInstance().showWidget(token);
        }
    }
}
