package eu.dnetlib.repo.manager.client.datasources.update;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.functionality.validator.JobResultEntry;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.enrichcontent.EventsSubscriptionForm;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.*;
import eu.dnetlib.repo.manager.shared.DatasourceVocabularies;
import eu.dnetlib.repo.manager.shared.broker.OpenaireSubscription;
import eu.dnetlib.repo.manager.shared.broker.Subscription;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 1/14/16.
 */
public class UpdateRepositoryWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private static HTML title = new HTML();
    private FlowPanel updateRepositoryBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();
    private Alert successAlert = new Alert();

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);
    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    public UpdateRepositoryWidget() {

        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        updateRepositoryBoxContent.add(errorAlert);

        successAlert.setType(AlertType.SUCCESS);
        successAlert.setDismissable(false);
        successAlert.setVisible(false);
        updateRepositoryBoxContent.add(successAlert);

        contentPanel.add(updateRepositoryBoxContent);
    }

    @Override
    public void clear() {
        updateRepositoryBoxContent.clear();
        errorAlert.setVisible(false);
        successAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        updateRepositoryBoxContent.add(errorAlert);
        updateRepositoryBoxContent.add(successAlert);

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repository...</div>" +
                "<div class=\"whiteFilm\"></div>");
        updateRepositoryBoxContent.addStyleName("loading-big");
        updateRepositoryBoxContent.add(loadingWheel);

        helpService.getHelpById(parentToken + "_updateRepo", new HelpCallback(helpPanel, gridPanel));

        repositoryService.getRepository(restToken, new AsyncCallback<Repository>() {

            @Override
            public void onFailure(Throwable caught) {

                updateRepositoryBoxContent.removeStyleName("loading-big");
                updateRepositoryBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving repository");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(final Repository repository) {

                String logoURLSource = "";
                if(repository.getLogoUrl()==null || repository.getLogoUrl().isEmpty())
                    logoURLSource = "img/yourLogoHere.jpg";
                else
                    logoURLSource = repository.getLogoUrl();

                title.setHTML("<h1 class=\"uk-article-title\">" +
                        "<a id=\"updateLogoURL\" href=\"javascript:;\">" +
                        "<img src=\"" + logoURLSource + "\" alt=\"[Repo Logo]\" width=\"60px\" style=\"margin-right: 15px; margin-top:-8px\"></a>" +
                        repository.getOfficialName() + "</h1>");

//                RepositoryManager.pageHeader.clear();
//
//                String logoURLSource = "";
//                if(repository.getLogoUrl()==null || repository.getLogoUrl().isEmpty())
//                    logoURLSource = "img/yourLogoHere.jpg";
//                else
//                    logoURLSource = repository.getLogoUrl();
//
//                RepositoryManager.pageHeader.add(new HTML("<div class=\"col-sm-9\"><h2><img src=\"" + logoURLSource + "\" alt=[Repo Logo]" +
//                        "width=\"35px\" height=\"35px\" style=\"margin-right: 15px; margin-top:-2px\">" + repository.getOfficialName() + "</h2>" +
//                        "<ol class=\"breadcrumb\"><li><a href=\"#dashboard\">Home</a></li><li><a href=\"#" + parentToken +
//                        "\">Manage Datasources</a></li><li class=\"active\"><strong>" + repository.getOfficialName() +
//                        "</strong></li></ol></div><div class=\"col-sm-3\"><div class=\"nav navbar-top-links navbar-right\">" +
//                        "<button id=\"addLogoURL\" style=\"margin-top: 30px; margin-right: 20px\" type=\"button\" " +
//                        "class=\"btn btn-w-m btn-white\">Update Logo URL</button></div></div>"));

                repositoryService.getDatasourceVocabularies(repository.getDatasourceType(),
                        new AsyncCallback<DatasourceVocabularies>() {

                    @Override
                    public void onFailure(Throwable caught) {

                        updateRepositoryBoxContent.removeStyleName("loading-big");
                        updateRepositoryBoxContent.remove(loadingWheel);

                        errorAlert.setText("System error retrieving datasource vocabularies");
                        errorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(DatasourceVocabularies datasourceVocabularies) {

                        updateRepositoryBoxContent.removeStyleName("loading-big");
                        updateRepositoryBoxContent.remove(loadingWheel);

                        UpdateRepositoryForm updateRepositoryForm =
                                new UpdateRepositoryForm(repository.getDatasourceType(), datasourceVocabularies, repository);
                        updateRepositoryBoxContent.add(updateRepositoryForm.asWidget());

                        addHandlers(repository);
                    }
                });
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private void addHandlers(final Repository repository) {

        $("#updateLogoURL").click(new Function() {

            public boolean f(Event e) {

                errorAlert.setVisible(false);
                successAlert.setVisible(false);

                openModalToEnterLogoURL(repository);

                return true;
            }
        });
    }

    private void openModalToEnterLogoURL(final Repository repository) {

        final Modal updateLogoURLModal = new Modal();
        updateLogoURLModal.setDataBackdrop(ModalBackdrop.STATIC);

        FlowPanel modalContent = new FlowPanel();

        HTML title = new HTML("<h2 class=\"uk-modal-title\">Update Logo URL</h2>\n");
        modalContent.add(title);

        Form logoURLForm = new Form();

        final TextBox logoURLTextBox = new TextBox();
        if(repository.getLogoUrl()==null || repository.getLogoUrl().isEmpty())
            logoURLTextBox.setPlaceholder("Logo URL");
        else
            logoURLTextBox.setValue(repository.getLogoUrl());

        logoURLForm.addStyleName("uk-margin uk-grid");

        FlowPanel logoURLTextBoxWrapper = new FlowPanel();
        logoURLTextBoxWrapper.addStyleName("uk-width-1-1");
        logoURLTextBoxWrapper.add(logoURLTextBox);
        logoURLForm.add(logoURLTextBoxWrapper);

        modalContent.add(logoURLForm);

        FlowPanel actionButtons = new FlowPanel();
        actionButtons.addStyleName("uk-text-right uk-margin-bottom");
        modalContent.add(actionButtons);

        Button no = new Button("Cancel");
        no.addStyleName("uk-button uk-button-default");
        no.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                updateLogoURLModal.hide();
                updateLogoURLModal.removeFromParent();
            }
        });
        actionButtons.add(no);

        Button yes = new Button("Update");
        yes.addStyleName("uk-button uk-button-primary");
        yes.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                repository.setLogoUrl(logoURLTextBox.getValue().trim());
                repositoryService.updateRepositoryInformation(repository, new AsyncCallback<Void>() {

                    @Override
                    public void onFailure(Throwable throwable) {

                        errorAlert.setText("System error updating logo URL");
                        errorAlert.setVisible(true);

                        updateLogoURLModal.hide();
                        updateLogoURLModal.removeFromParent();
                    }

                    @Override
                    public void onSuccess(Void aVoid) {

                        successAlert.setVisible(true);
                        successAlert.setText("Logo updated successfully");

                        String logoURLSource = "";
                        if(repository.getLogoUrl()==null || repository.getLogoUrl().isEmpty())
                            logoURLSource = "img/yourLogoHere.jpg";
                        else
                            logoURLSource = repository.getLogoUrl();

                        UpdateRepositoryWidget.title.setHTML("<h1 class=\"uk-article-title\">" +
                                "<a id=\"updateLogoURL\" href=\"javascript:;\">" +
                                "<img src=\"" + logoURLSource + "\" alt=\"[Repo Logo]\" width=\"60px\" style=\"margin-right: 15px; margin-top:-8px\"></a>" +
                                repository.getOfficialName() + "</h1>");

                        addHandlers(repository);

                        updateLogoURLModal.hide();
                        updateLogoURLModal.removeFromParent();
                    }
                });
            }
        });
        actionButtons.add(yes);

        ModalBody modalBody = new ModalBody();
        modalBody.add(modalContent);
        updateLogoURLModal.add(modalBody);
        updateLogoURLModal.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();

        updateLogoURLModal.show();
    }
}
