package eu.dnetlib.repo.manager.client.datasources.utils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;
import com.google.gwt.user.client.ui.Label;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.*;
import eu.dnetlib.repo.manager.client.widgets.TextArea;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import eu.dnetlib.repo.manager.shared.Constants;
import eu.dnetlib.repo.manager.shared.DatasourceVocabularies;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.form.error.BasicEditorError;
import org.gwtbootstrap3.client.ui.form.validator.Validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by stefania on 12/21/15.
 */
public class RepositoryInformationFormWidget implements IsWidget {

    private FlowPanel repositoryInformationPanel = new FlowPanel();

    private Alert errorLabel = new Alert();
    private Alert successLabel = new Alert();

    private Form repositoryInformationForm = new Form();

    private HTML basicInfoWarningLabel = new HTML();

    private ListBox typologyListBox = new ListBox();
    private MyFormGroup typologyListFormGroup = new MyFormGroup(false, "Software Platform (*)", typologyListBox);
    private TextBox typologyTextBox = new TextBox();
    private MyFormGroup typologyTextFormGroup = new MyFormGroup(false, null, typologyTextBox);
    private TextBox officialName = new TextBox();
    private MyFormGroup officialNameFormGroup = new MyFormGroup(false, "Official Name (*)", officialName);
    private TextBox issn = new TextBox();
    private MyFormGroup issnFormGroup = new MyFormGroup(true, "ISSN (*)", issn);
    private TextBox eissn = new TextBox();
    private MyFormGroup eissnFormGroup = new MyFormGroup(true, "EISSN", eissn);
    private TextBox lissn = new TextBox();
    private MyFormGroup lissnFormGroup = new MyFormGroup(true, "LISSN", lissn);
    private TextArea description = new TextArea();
    private MyFormGroup descriptionFormGroup = new MyFormGroup(false, "Description (*)", description);
    private ListBox countryListBox = new ListBox();
    private MyFormGroup countryFormGroup = new MyFormGroup(false, "Country (*)", countryListBox);
    private TextBox longitude = new TextBox();
    private MyFormGroup longitudeFormGroup = new MyFormGroup(true, "Longitude (*)", longitude);
    private TextBox latitude = new TextBox();
    private MyFormGroup latitudeFormGroup = new MyFormGroup(true, "Latitude (*)", latitude);
    private TextBox entryURL = new TextBox();
    private MyFormGroup entryURLFormGroup = new MyFormGroup(false, "Entry URL (*)", entryURL);
    private TextBox institution = new TextBox();
    private MyFormGroup institutionFormGroup = new MyFormGroup(false, "Institution (*)", institution);

    private TextBox englishName = new TextBox();
    private MyFormGroup englishNameFormGroup = new MyFormGroup(false, "English Name (*)", englishName);
    private TextBox logoURL = new TextBox();
    private ListBox timezoneListBox = new ListBox();
    private MyFormGroup timezoneFormGroup = new MyFormGroup(false, "Timezone (*)", timezoneListBox);
    private ListBox datasourceClassListBox = new ListBox();
    private MyFormGroup datasourceClassFormGroup = new MyFormGroup(false, "Datasource Type (*)", datasourceClassListBox);

    private TextBox admin = new TextBox();
    private MyFormGroup adminFormGroup = new MyFormGroup(true, "Admin Email (*)", admin);

    private Map<String, Integer> typologyValuesMap = new HashMap<String, Integer>();
    private Map<String, Integer> countryValuesMap = new HashMap<String, Integer>();
    private Map<String, Integer> timezoneValuesMap = new HashMap<String, Integer>();
    private Map<String, Integer> datasourceClassValuesMap = new HashMap<String, Integer>();

    private String mode;

    private Repository repository;

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    public RepositoryInformationFormWidget(String mode, DatasourceVocabularies datasourceVocabularies, boolean isUpdate) {

        this.mode = mode;

        basicInfoWarningLabel.addStyleName("alert alert-warning");
        basicInfoWarningLabel.setVisible(false);

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setDismissable(false);
        errorLabel.setVisible(false);

        successLabel.setType(AlertType.SUCCESS);
        successLabel.setDismissable(false);
        successLabel.setVisible(false);

        repositoryInformationPanel.add(successLabel);
        repositoryInformationPanel.add(errorLabel);
        repositoryInformationPanel.add(repositoryInformationForm);

        typologyListBox.addItem("-- none selected --", "noneSelected");
        for(int i=1; i<datasourceVocabularies.getTypologies().size(); i++) {
            if(datasourceVocabularies.getTypologies().get(i-1).equals("[Other]")) {
                typologyListBox.addItem("[Other] (enter name below)", "[Other]");
                typologyValuesMap.put("[Other]", i);
            } else {
                typologyListBox.addItem(datasourceVocabularies.getTypologies().get(i - 1), datasourceVocabularies.getTypologies().get(i - 1));
                typologyValuesMap.put(datasourceVocabularies.getTypologies().get(i - 1), i);
            }
        }

        countryListBox.addItem("-- none selected --", "noneSelected");
        int counter1 = 1;
        for(String country : datasourceVocabularies.getCountries().keySet()) {
            countryListBox.addItem(datasourceVocabularies.getCountries().get(country), country);
            countryValuesMap.put(country, counter1);
            counter1++;
        }

        timezoneListBox.addItem("-- none selected --", "noneSelected");
        for(int i=1; i<datasourceVocabularies.getTimezones().size(); i++) {
            timezoneListBox.addItem(datasourceVocabularies.getTimezones().get(i-1).name, datasourceVocabularies.getTimezones().get(i-1).offset+"");
            timezoneValuesMap.put(datasourceVocabularies.getTimezones().get(i-1).offset+"", i);
        }

        datasourceClassListBox.addItem("-- none selected --", "noneSelected");
        int counter2 = 1;
        for(String datasourceClass : datasourceVocabularies.getDatasourceClasses().keySet()) {
            datasourceClassListBox.addItem(datasourceVocabularies.getDatasourceClasses().get(datasourceClass), datasourceClass);
            datasourceClassValuesMap.put(datasourceClass, counter2);
            counter2++;
        }

        typologyTextBox.setVisible(false);


        Label logoURLComment = new Label("Please make sure that the maximum size of the uploaded image is width=360px, height=240px");
        logoURLComment.addStyleName("comment");
        logoURLComment.addStyleName("fontItalic");

        HTML basicInfoLabel = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\">Basic information</h4>");
        repositoryInformationForm.add(basicInfoLabel);
        repositoryInformationForm.add(basicInfoWarningLabel);
        repositoryInformationForm.add(typologyListFormGroup);
        repositoryInformationForm.add(typologyTextFormGroup);
        repositoryInformationForm.add(officialNameFormGroup);
        if(mode.equals(Constants.REPOSITORY_MODE_JOURNAL)) {
            repositoryInformationForm.add(issnFormGroup);
            repositoryInformationForm.add(eissnFormGroup);
            repositoryInformationForm.add(lissnFormGroup);
        }
        repositoryInformationForm.add(descriptionFormGroup);
        repositoryInformationForm.add(countryFormGroup);
        repositoryInformationForm.add(longitudeFormGroup);
        repositoryInformationForm.add(latitudeFormGroup);
        repositoryInformationForm.add(entryURLFormGroup);
        repositoryInformationForm.add(institutionFormGroup);

        HTML extraInfoLabel = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\">Extra information</h4>");
        repositoryInformationForm.add(extraInfoLabel);
        repositoryInformationForm.add(englishNameFormGroup);
        repositoryInformationForm.add(new MyFormGroup(false, "Logo URL", logoURL, logoURLComment));
        repositoryInformationForm.add(timezoneFormGroup);
        repositoryInformationForm.add(datasourceClassFormGroup);

        if(mode.equals(Constants.REPOSITORY_MODE_JOURNAL))
            datasourceClassFormGroup.setLabelText("Journal Type (*)");
        else if(mode.equals(Constants.REPOSITORY_MODE_AGGREGATOR))
            datasourceClassFormGroup.setLabelText("Aggregator Type (*)");

        HTML adminInfoLabel = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\">Administrator & contact information</h4>");
        repositoryInformationForm.add(adminInfoLabel);
        repositoryInformationForm.add(adminFormGroup);

        if(mode.equals(Constants.REPOSITORY_MODE_OPENDOAR) || mode.equals(Constants.REPOSITORY_MODE_RE3DATA)) {
            typologyListBox.setEnabled(false);
            typologyTextBox.setEnabled(false);
            officialName.setEnabled(false);
            description.setEnabled(false);
            countryListBox.setEnabled(false);
            longitude.setEnabled(false);
            latitude.setEnabled(false);
            entryURL.setEnabled(false);
            institution.setEnabled(false);
        }

        if(isUpdate) {

            Button updateInfoButton = new Button("Update Information");
            updateInfoButton.setType(ButtonType.PRIMARY);
            updateInfoButton.addStyleName("updateRepoInfoButton");
            updateInfoButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {

                    errorLabel.setVisible(false);
                    successLabel.setVisible(false);

                    Repository repositoryToUpdate = getRepository();
                    if(repositoryToUpdate!=null) {

                        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 35%; " +
                                "color: rgb(47, 64, 80); font-weight: bold;\">Updating repository information</div>" +
                                "<div class=\"whiteFilm\"></div>");
                        repositoryInformationPanel.addStyleName("loading-big");
                        repositoryInformationPanel.add(loadingWheel);

                        repositoryService.updateRepositoryInformation(repositoryToUpdate, new AsyncCallback<Void>() {

                            @Override
                            public void onFailure(Throwable caught) {

                                repositoryInformationPanel.removeStyleName("loading-big");
                                repositoryInformationPanel.remove(loadingWheel);

                                errorLabel.setText("System error updating repository information");
                                errorLabel.setVisible(true);
                            }

                            @Override
                            public void onSuccess(Void result) {

                                repositoryInformationPanel.removeStyleName("loading-big");
                                repositoryInformationPanel.remove(loadingWheel);

                                successLabel.setText("Repository information updated successfully");
                                successLabel.setVisible(true);
                            }
                        });
                    }
                }
            });
            repositoryInformationForm.add(new MyFormGroup(false, null, updateInfoButton));
        }

        addValueChangeHandlersToFormFields();
        addFieldValidators();
    }

    @Override
    public Widget asWidget() {
        return repositoryInformationPanel;
    }

    public void loadRepository(Repository repository) {

        errorLabel.setVisible(false);
        successLabel.setVisible(false);

        this.repository = repository;

        if(mode.equals(Constants.REPOSITORY_MODE_OPENDOAR)) {
            basicInfoWarningLabel.setHTML("The following fields are completed by OpenDOAR.<br>" +
                    "If you want to edit them, you can do it by using this <a target=\"_blank\" " +
                    "href=\"http://www.opendoar.org/suggest.php?rID=" + repository.getId().split("::")[1] + "\">OpenDOAR link</a>");
            basicInfoWarningLabel.setVisible(true);
        } else if(mode.equals(Constants.REPOSITORY_MODE_RE3DATA)) {
            basicInfoWarningLabel.setHTML("The following fields are completed by Re3data.<br>" +
                    "If you want to edit them, you can do it by using this <a target=\"_blank\" " +
                    "href=\"http://service.re3data.org/repository/" + repository.getId().split("::")[1] + "\">Re3data link</a>");
            basicInfoWarningLabel.setVisible(true);
        }

        if (repository.getTypology() != null) {
            if(timezoneValuesMap.get(repository.getTypology())!=null)
                typologyListBox.setSelectedIndex(typologyValuesMap.get(repository.getTypology()));
            else if(typologyValuesMap.containsKey("[Other]")){
                typologyListBox.setSelectedIndex(typologyValuesMap.get("[Other]"));
                typologyTextBox.setVisible(true);
                typologyTextBox.setValue(repository.getTypology());
            }
        }

        if (repository.getOfficialName() != null)
            officialName.setValue(repository.getOfficialName());

        if (mode.equals(Constants.REPOSITORY_MODE_JOURNAL)) {
            if (repository.getIssn() != null)
                issn.setValue(repository.getIssn());
            if (repository.getEissn() != null)
                eissn.setValue(repository.getEissn());
            if (repository.getLissn() != null)
                lissn.setValue(repository.getLissn());
        }

        if (repository.getDescription() != null)
            description.setValue(repository.getDescription());
        if (repository.getCountryName() != null)
            countryListBox.setSelectedIndex(countryValuesMap.get(repository.getCountryName()));
        if (repository.getLongitude() != null)
            longitude.setValue(repository.getLongitude() + "");
        if (repository.getLatitude() != null)
            latitude.setValue(repository.getLatitude() + "");
        if (repository.getWebsiteUrl() != null)
            entryURL.setValue(repository.getWebsiteUrl());
        if (repository.getOrganization() != null)
            institution.setValue(repository.getOrganization());

        if (repository.getEnglishName() != null)
            englishName.setValue(repository.getEnglishName());
        if (repository.getLogoUrl() != null)
            logoURL.setValue(repository.getLogoUrl());
        if(repository.getTimezone()!=null)
            timezoneListBox.setSelectedIndex(timezoneValuesMap.get(repository.getTimezone()+""));
        if(repository.getDatasourceClass()!=null && datasourceClassValuesMap.containsKey(repository.getDatasourceClass()))
            datasourceClassListBox.setSelectedIndex(datasourceClassValuesMap.get(repository.getDatasourceClass()));

        if (repository.getContactEmail() != null)
            admin.setValue(repository.getContactEmail());
    }

    public Repository getRepository() {

        if(isComplete()) {

            if(repositoryInformationForm.validate()) {

                if (typologyListBox.getSelectedValue().equals("[Other]"))
                    repository.setTypology(typologyTextBox.getValue().trim());
                else
                    repository.setTypology(typologyListBox.getSelectedValue());

                repository.setOfficialName(officialName.getValue().trim());

                if (mode.equals(Constants.REPOSITORY_MODE_JOURNAL)) {
                    repository.setIssn(issn.getValue().trim());
                    if (eissn.getValue() != null && !eissn.getValue().trim().isEmpty())
                        repository.setEissn(eissn.getValue().trim());
                    if (lissn.getValue() != null && !lissn.getValue().trim().isEmpty())
                        repository.setLissn(lissn.getValue().trim());
                }

                repository.setDescription(description.getValue().trim());
                repository.setCountryName(countryListBox.getSelectedValue());
                repository.setLongitude(Double.parseDouble(longitude.getValue().trim()));
                repository.setLatitude(Double.parseDouble(latitude.getValue().trim()));
                repository.setWebsiteUrl(entryURL.getValue().trim());
                repository.setOrganization(institution.getValue().trim());

                repository.setEnglishName(englishName.getValue().trim());
                repository.setLogoUrl(logoURL.getValue().trim());
                repository.setTimezone(Double.parseDouble(timezoneListBox.getSelectedValue()));
                repository.setDatasourceClass(datasourceClassListBox.getSelectedValue());

                repository.setContactEmail(admin.getValue());

                return repository;
            }
        }

        return null;
    }

    private boolean isComplete() {

        boolean isComplete = true;

        errorLabel.setVisible(false);
        successLabel.setVisible(false);

        if(typologyListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            typologyListFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        } else if(typologyListBox.getSelectedValue().equals("[Other]")
                && (typologyTextBox.getValue()==null || typologyTextBox.getValue().trim().isEmpty())) {
            isComplete = false;
            typologyTextFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(officialName.getValue()==null || officialName.getValue().trim().isEmpty()) {
            isComplete = false;
            officialNameFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(mode.equals(Constants.REPOSITORY_MODE_JOURNAL)
                && (issn.getValue()==null || issn.getValue().trim().isEmpty())) {
            isComplete = false;
            issnFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(description.getValue()==null || description.getValue().trim().isEmpty()) {
            isComplete = false;
            descriptionFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(countryListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            countryFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(longitude.getValue()==null || longitude.getValue().trim().isEmpty()) {
            isComplete = false;
            longitudeFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(latitude.getValue()==null || latitude.getValue().trim().isEmpty()) {
            isComplete = false;
            latitudeFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(entryURL.getValue()==null || entryURL.getValue().trim().isEmpty()) {
            isComplete = false;
            entryURLFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(institution.getValue()==null || institution.getValue().trim().isEmpty()) {
            isComplete = false;
            institutionFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(englishName.getValue()==null || englishName.getValue().trim().isEmpty()) {
            isComplete = false;
            englishNameFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(timezoneListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            timezoneFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(datasourceClassListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            datasourceClassFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(admin.getValue()==null || admin.getValue().trim().isEmpty()) {
            isComplete = false;
            adminFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(!isComplete) {
            errorLabel.setText("All fields marked with * are mandatory.");
            errorLabel.setVisible(true);
        }

        return isComplete;
    }

    private void addFieldValidators() {

        longitude.addValidator(new Validator<String>() {

            @Override
            public int getPriority() {
                return 0;
            }

            @Override
            public List<EditorError> validate(Editor<String> editor, String value) {

                List<EditorError> result = new ArrayList<EditorError>();
                String valueStr = value == null ? "" : value.toString();

                RegExp regExp = RegExp.compile(Constants.LONGITUDE_PATTERN);
                if (!regExp.test(valueStr.trim().toLowerCase())) {

                    longitudeFormGroup.displayInlineError("Invalid longitude");
                    result.add(new BasicEditorError(longitude, value, "Invalid longitude"));
                    errorLabel.setText("Invalid fields!");
                    errorLabel.setVisible(true);
                }

                return result;
            }
        });

        latitude.addValidator(new Validator<String>() {

            @Override
            public int getPriority() {
                return 0;
            }

            @Override
            public List<EditorError> validate(Editor<String> editor, String value) {

                List<EditorError> result = new ArrayList<EditorError>();
                String valueStr = value == null ? "" : value.toString();

                RegExp regExp = RegExp.compile(Constants.LATITUDE_PATTERN);
                if (!regExp.test(valueStr.trim().toLowerCase())) {

                    latitudeFormGroup.displayInlineError("Invalid latitude");
                    result.add(new BasicEditorError(latitude, value, "Invalid latitude"));
                    errorLabel.setText("Invalid fields!");
                    errorLabel.setVisible(true);
                }

                return result;
            }
        });

        admin.addValidator(new Validator<String>() {

            @Override
            public int getPriority() {
                return 0;
            }

            @Override
            public List<EditorError> validate(Editor<String> editor, String value) {

                List<EditorError> result = new ArrayList<EditorError>();
                String valueStr = value == null ? "" : value.toString();

                RegExp regExp = RegExp.compile(Constants.EMAIL_PATTERN);
                if (!regExp.test(valueStr.trim().toLowerCase())) {

                    adminFormGroup.displayInlineError("Invalid email address");
                    result.add(new BasicEditorError(admin, value, "Invalid email address"));
                    errorLabel.setText("Invalid fields!");
                    errorLabel.setVisible(true);
                }

                return result;
            }
        });

        if(mode.equals(Constants.REPOSITORY_MODE_JOURNAL)) {

            issn.addValidator(new Validator<String>() {

                @Override
                public int getPriority() {
                    return 0;
                }

                @Override
                public List<EditorError> validate(Editor<String> editor, String value) {

                    List<EditorError> result = new ArrayList<EditorError>();
                    String valueStr = value == null ? "" : value.toString();

                    if (valueStr.length()!=8) {
                        issnFormGroup.displayInlineError("Issn length has to be 8 characters");
                        result.add(new BasicEditorError(issn, value, "Issn length has to be 8 characters"));
                        errorLabel.setText("Invalid fields!");
                        errorLabel.setVisible(true);
                    }

                    return result;
                }
            });

            eissn.addValidator(new Validator<String>() {

                @Override
                public int getPriority() {
                    return 0;
                }

                @Override
                public List<EditorError> validate(Editor<String> editor, String value) {

                    List<EditorError> result = new ArrayList<EditorError>();
                    String valueStr = value == null ? "" : value.toString();

                    if (valueStr.length()!=8) {
                        eissnFormGroup.displayInlineError("Eissn length has to be 8 characters");
                        result.add(new BasicEditorError(eissn, value, "Eissn length has to be 8 characters"));
                        errorLabel.setText("Invalid fields!");
                        errorLabel.setVisible(true);
                    }

                    return result;
                }
            });

            lissn.addValidator(new Validator<String>() {

                @Override
                public int getPriority() {
                    return 0;
                }

                @Override
                public List<EditorError> validate(Editor<String> editor, String value) {

                    List<EditorError> result = new ArrayList<EditorError>();
                    String valueStr = value == null ? "" : value.toString();

                    if (valueStr.length()!=8) {
                        lissnFormGroup.displayInlineError("Lissn length has to be 8 characters");
                        result.add(new BasicEditorError(lissn, value, "Lissn length has to be 8 characters"));
                        errorLabel.setText("Invalid fields!");
                        errorLabel.setVisible(true);
                    }

                    return result;
                }
            });

        }

    }

    private void addValueChangeHandlersToFormFields() {

        typologyListBox.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                typologyListFormGroup.setFormGroupValidationState(ValidationState.NONE);
                if(typologyListBox.getSelectedValue().equals("[Other]"))
                    typologyTextBox.setVisible(true);
                else
                    typologyTextBox.setVisible(false);
            }
        });

        typologyTextBox.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                typologyTextFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        officialName.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                officialNameFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        issn.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                issnFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        eissn.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                eissnFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        lissn.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                lissnFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        description.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                descriptionFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        countryListBox.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                countryFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        longitude.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                longitudeFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        latitude.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                latitudeFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        entryURL.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                entryURLFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        institution.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                institutionFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        englishName.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                englishNameFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        timezoneListBox.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                timezoneFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        datasourceClassListBox.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                datasourceClassFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        admin.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                adminFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });
    }
}
