package eu.dnetlib.repo.manager.client.browsehistory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import eu.dnetlib.repo.manager.shared.Constants;
import eu.dnetlib.repo.manager.shared.JobsOfUser;
import eu.dnetlib.repo.manager.shared.broker.EventsPage;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.UnorderedList;

import java.util.ArrayList;
import java.util.List;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 3/28/16.
 */
public class BrowseHistoryWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private Alert errorAlert = new Alert();
    private Alert successAlert = new Alert();
    private Alert warningAlert = new Alert();

    private FlowPanel myHistoryListBoxContent = new FlowPanel();
    private FlowPanel controlsPanel = new FlowPanel();
    private FlowPanel contentAndPagerPanel = new FlowPanel();

    private FlowPanel topPagerPanel = new FlowPanel();
    private Pager resultsPagerTop = new Pager();
    private Label pageNumberTop = new Label();

    private FlowPanel jobsListContentPanel = new FlowPanel();

    private FlowPanel bottomPagerPanel = new FlowPanel();
    private Pager resultsPagerBottom = new Pager();
    private Label pageNumberBottom = new Label();

    private ListBox validationJobTypesListBox = new ListBox();
    private ListBox jobsPerPageListBox = new ListBox();

    private int jobTypeSelectedIndex = 0;
    private int jobsPerPageSelectedIndex = 0;
    private String jobStatusSelected = "all";
    private int currentPage = 1;

    private List<StoredJob> storedJobs = new ArrayList<StoredJob>();
    private List<StoredJob> finishedStoredJobs = new ArrayList<StoredJob>();
    private List<StoredJob> failedStoredJobs = new ArrayList<StoredJob>();
    private List<StoredJob> pendingStoredJobs = new ArrayList<StoredJob>();

    private JobsOfUser jobsOfUser = null;

    private ValidationServiceAsync validationService = GWT.create(ValidationService.class);
    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    public BrowseHistoryWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Previous validations</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        contentPanel.add(myHistoryListBoxContent);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setVisible(false);
        errorAlert.setDismissable(false);
        myHistoryListBoxContent.add(errorAlert);

        successAlert.setType(AlertType.SUCCESS);
        successAlert.setVisible(false);
        successAlert.setDismissable(false);
        myHistoryListBoxContent.add(successAlert);

        warningAlert.setType(AlertType.WARNING);
        warningAlert.setVisible(false);
        warningAlert.setDismissable(false);
        myHistoryListBoxContent.add(warningAlert);

        myHistoryListBoxContent.add(controlsPanel);
        myHistoryListBoxContent.add(contentAndPagerPanel);

        contentAndPagerPanel.addStyleName("contentAndPagerPanel");

//        topPagerPanel.addStyleName("marginTop40");

        resultsPagerTop.addStyleName("resultsPager");
//        resultsPagerTop.setAligned(true);
//        resultsPagerTop.setArrows(true);
        resultsPagerTop.setAlignToSides(true);
        resultsPagerTop.setPreviousIcon(IconType.LONG_ARROW_LEFT);
        resultsPagerTop.setNextIcon(IconType.LONG_ARROW_RIGHT);
//        resultsPagerTop.setIPosition(IconPosition.RIGHT);

        resultsPagerTop.addPreviousClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent clickEvent) {
                previousPage();
            }
        });

        resultsPagerTop.addNextClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent clickEvent) {
                nextPage();
            }
        });

        resultsPagerBottom.addStyleName("resultsPager");
//        resultsPagerBottom.setAligned(true);
//        resultsPagerBottom.setArrows(true);
        resultsPagerBottom.setAlignToSides(true);
        resultsPagerBottom.setPreviousIcon(IconType.LONG_ARROW_LEFT);
        resultsPagerBottom.setNextIcon(IconType.LONG_ARROW_RIGHT);
//        resultsPagerBottom.getRight().setIconPosition(IconPosition.RIGHT);

        resultsPagerBottom.addPreviousClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent clickEvent) {
                previousPage();
            }
        });

        resultsPagerBottom.addNextClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent clickEvent) {
                nextPage();
            }
        });

        contentAndPagerPanel.add(topPagerPanel);
        contentAndPagerPanel.add(jobsListContentPanel);
        contentAndPagerPanel.add(bottomPagerPanel);

        controlsPanel.addStyleName("uk-grid");
        controlsPanel.addStyleName("page-controls");

        validationJobTypesListBox.addItem("-- none selected --", "noneSelected");
        validationJobTypesListBox.addItem(Constants.VALIDATION_JOB_TYPE_COMPATIBILITY_TEST, Constants.VALIDATION_JOB_TYPE_COMPATIBILITY_TEST);
        validationJobTypesListBox.addItem(Constants.VALIDATION_JOB_TYPE_REGISTRATION_REQUEST, Constants.VALIDATION_JOB_TYPE_REGISTRATION_REQUEST);
        validationJobTypesListBox.addItem(Constants.VALIDATION_JOB_TYPE_WORKFLOW_REQUEST, Constants.VALIDATION_JOB_TYPE_WORKFLOW_REQUEST);
        validationJobTypesListBox.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {

                jobTypeSelectedIndex = validationJobTypesListBox.getSelectedIndex();

                String validationType = null;
                if(!validationJobTypesListBox.getSelectedValue().equals("noneSelected"))
                    validationType = validationJobTypesListBox.getSelectedValue();

                String jobStatus = null;
                if(!jobStatusSelected.equals("all"))
                    jobStatus = jobStatusSelected;

                getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, 0,
                        Integer.parseInt(jobsPerPageListBox.getSelectedValue()), null,  null, jobStatus, true);

                currentPage = 1;
            }
        });

        jobsPerPageListBox.addItem("10", "10");
        jobsPerPageListBox.addItem("25", "25");
        jobsPerPageListBox.addItem("50", "50");
        jobsPerPageListBox.addItem("100", "100");
        jobsPerPageListBox.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {

                jobsPerPageSelectedIndex = jobsPerPageListBox.getSelectedIndex();

                String validationType = null;
                if(!validationJobTypesListBox.getSelectedValue().equals("noneSelected"))
                    validationType = validationJobTypesListBox.getSelectedValue();

                String jobStatus = null;
                if(!jobStatusSelected.equals("all"))
                    jobStatus = jobStatusSelected;

                getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, 0,
                        Integer.parseInt(jobsPerPageListBox.getSelectedValue()), null,  null, jobStatus, true);

                currentPage = 1;
            }
        });
    }

    @Override
    public void clear() {

        errorAlert.setVisible(false);
        successAlert.setVisible(false);
        warningAlert.setVisible(false);

        controlsPanel.clear();
        topPagerPanel.clear();
        jobsListContentPanel.clear();
        bottomPagerPanel.clear();
        gridPanel.remove(helpPanel);

        validationJobTypesListBox.setSelectedIndex(0);
        jobsPerPageListBox.setSelectedIndex(0);

        jobTypeSelectedIndex = 0;
        jobsPerPageSelectedIndex = 0;
        jobStatusSelected = "all";
        currentPage = 1;

        jobsOfUser = null;
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        helpService.getHelpById(parentToken, new HelpCallback(helpPanel, gridPanel));

        getStoredJobs(RepositoryManager.currentUser.getEmail(), null, 0, 10, null, null, null, true);
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private void getStoredJobs(String user, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo,
                               String jobStatus, boolean includeJobsTotal) {

        errorAlert.setVisible(false);
        successAlert.setVisible(false);
        warningAlert.setVisible(false);

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving validation history...</div>" +
                "<div class=\"whiteFilm\"></div>");
        myHistoryListBoxContent.addStyleName("loading-big");
        myHistoryListBoxContent.add(loadingWheel);

        validationService.getJobsOfUser(user, jobType, offset, limit, dateFrom, dateTo, jobStatus, includeJobsTotal,
                new AsyncCallback<JobsOfUser>() {

            @Override
            public void onFailure(Throwable caught) {

                jobsOfUser = null;

                myHistoryListBoxContent.removeStyleName("loading-big");
                myHistoryListBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving validation history.");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(JobsOfUser jobsOfUser) {

                BrowseHistoryWidget.this.jobsOfUser = jobsOfUser;

                myHistoryListBoxContent.removeStyleName("loading-big");
                myHistoryListBoxContent.remove(loadingWheel);

                FlowPanel titleRowPanel = new FlowPanel();
                titleRowPanel.addStyleName("row");
                myHistoryListBoxContent.add(titleRowPanel);

//                updateStoredJobs(true, null, null);
                updateControls(jobsOfUser);
                drawPager(topPagerPanel);
//                drawTopPager();
                updateContents(jobsOfUser.getJobs());
                drawPager(bottomPagerPanel);
//                drawBottomPager();

                Window.scrollTo(0, 0);
            }
        });
    }

    private void updateControls(JobsOfUser jobsOfUser) {

        controlsPanel.clear();

        FlowPanel firstRowFilters = new FlowPanel();
        firstRowFilters.addStyleName("uk-margin-bottom uk-width-1-1");
        firstRowFilters.addStyleName("filters");

        controlsPanel.add(firstRowFilters);

        FlowPanel jobTypeSelection = new FlowPanel();
        jobTypeSelection.addStyleName("links");

        firstRowFilters.add(jobTypeSelection);

        Label jobTypeFilterLabel = new Label("Filter by job type:");
        jobTypeFilterLabel.addStyleName("filterLabel");
        jobTypeSelection.add(jobTypeFilterLabel);

        FlowPanel jobTypeFilterListBoxPanel = new FlowPanel();
        jobTypeFilterListBoxPanel.addStyleName("inlineBlock");
        validationJobTypesListBox.setSelectedIndex(jobTypeSelectedIndex);
        jobTypeFilterListBoxPanel.add(validationJobTypesListBox);
        jobTypeSelection.add(jobTypeFilterListBoxPanel);

        FlowPanel secondRowFilters = new FlowPanel();
        secondRowFilters.addStyleName("uk-margin-bottom uk-width-1-1");
        secondRowFilters.addStyleName("filters");

        controlsPanel.add(secondRowFilters);

        FlowPanel links = new FlowPanel();
        links.addStyleName("links uk-inline");

        secondRowFilters.add(links);

        Label filterLabel = new Label("Filter validation jobs:");
        filterLabel.addStyleName("filterLabel");
        links.add(filterLabel);

        final Anchor allJobsLink = new Anchor();
        allJobsLink.setText("All Jobs (" + jobsOfUser.getTotalJobs() + ")");
        if(jobStatusSelected.equals("all"))
            allJobsLink.addStyleName("active");
        links.add(allJobsLink);

        final Anchor successfulQuestionsLink = new Anchor();
        successfulQuestionsLink.setText(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL + " (" + jobsOfUser.getTotalJobsSuccessful() + ")");
        if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
            successfulQuestionsLink.addStyleName("active");
        links.add(successfulQuestionsLink);

        final Anchor failedQuestionsLink = new Anchor();
        failedQuestionsLink.setText(Constants.VALIDATION_JOB_STATUS_FAILED + " (" + jobsOfUser.getTotalJobsFailed() + ")");
        if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_FAILED))
            failedQuestionsLink.addStyleName("active");
        links.add(failedQuestionsLink);

        final Anchor pendingQuestionsLink = new Anchor();
        pendingQuestionsLink.setText(Constants.VALIDATION_JOB_STATUS_ONGOING + " (" + jobsOfUser.getTotalJobsOngoing() + ")");
        if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_ONGOING))
            pendingQuestionsLink.addStyleName("active");
        links.add(pendingQuestionsLink);

        allJobsLink.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                jobStatusSelected = "all";

                allJobsLink.addStyleName("active");
                successfulQuestionsLink.removeStyleName("active");
                failedQuestionsLink.removeStyleName("active");
                pendingQuestionsLink.removeStyleName("active");

                String validationType = null;
                if(!validationJobTypesListBox.getSelectedValue().equals("noneSelected"))
                    validationType = validationJobTypesListBox.getSelectedValue();
                getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, 0,
                        Integer.parseInt(jobsPerPageListBox.getSelectedValue()), null,  null, null, true);

                currentPage = 1;
//                updateContents(allMatchingNews);
            }
        });

        successfulQuestionsLink.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                jobStatusSelected = Constants.VALIDATION_JOB_STATUS_SUCCESSFUL;

                allJobsLink.removeStyleName("active");
                successfulQuestionsLink.addStyleName("active");
                failedQuestionsLink.removeStyleName("active");
                pendingQuestionsLink.removeStyleName("active");

                String validationType = null;
                if(!validationJobTypesListBox.getSelectedValue().equals("noneSelected"))
                    validationType = validationJobTypesListBox.getSelectedValue();
                getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, 0,
                        Integer.parseInt(jobsPerPageListBox.getSelectedValue()), null,  null, jobStatusSelected, true);

                currentPage = 1;
//                updateContents(inactiveMatchingNews);
            }
        });

        failedQuestionsLink.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                jobStatusSelected = Constants.VALIDATION_JOB_STATUS_FAILED;

                allJobsLink.removeStyleName("active");
                successfulQuestionsLink.removeStyleName("active");
                failedQuestionsLink.addStyleName("active");
                pendingQuestionsLink.removeStyleName("active");

                String validationType = null;
                if(!validationJobTypesListBox.getSelectedValue().equals("noneSelected"))
                    validationType = validationJobTypesListBox.getSelectedValue();
                getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, 0,
                        Integer.parseInt(jobsPerPageListBox.getSelectedValue()), null,  null, jobStatusSelected, true);

                currentPage = 1;
//                updateContents(activeMatchingNews);
            }
        });

        pendingQuestionsLink.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                jobStatusSelected = Constants.VALIDATION_JOB_STATUS_ONGOING;

                allJobsLink.removeStyleName("active");
                successfulQuestionsLink.removeStyleName("active");
                failedQuestionsLink.removeStyleName("active");
                pendingQuestionsLink.addStyleName("active");

                String validationType = null;
                if(!validationJobTypesListBox.getSelectedValue().equals("noneSelected"))
                    validationType = validationJobTypesListBox.getSelectedValue();
                getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, 0,
                        Integer.parseInt(jobsPerPageListBox.getSelectedValue()), null,  null, jobStatusSelected, true);

                currentPage = 1;
//                updateContents(inactiveMatchingNews);
            }
        });

        FlowPanel actions = new FlowPanel();
        actions.addStyleName("show-options uk-inline");

        secondRowFilters.add(actions);

        Label jobsPerPageFilterLabel = new Label("Jobs per page:");
        jobsPerPageFilterLabel.addStyleName("filterLabel");
        actions.add(jobsPerPageFilterLabel);

        FlowPanel jobsPerPageListBoxPanel = new FlowPanel();
        jobsPerPageListBoxPanel.addStyleName("inlineBlock");
        jobsPerPageListBox.setSelectedIndex(jobsPerPageSelectedIndex);
        jobsPerPageListBoxPanel.add(jobsPerPageListBox);
        actions.add(jobsPerPageListBoxPanel);

    }

//    public void updateContents(List<StoredJob> storedJobs) {
//
//        jobsListContentPanel.clear();
//
//        String contents = "<div class=\"table-responsive jobs-table\"><table class=\"table jobs-list row\">" +
//                "<tr class=\"row job\">" +
//                "<th class=\"header\">Validation Type</th>" +
//                "<th class=\"header\">Status</th>" +
//                "<th class=\"header\">Score</th>" +
////                "<th class=\"header\">User</th>" +
//                "<th class=\"header\">Started</th>" +
////                "<th class=\"header\">Duration</th>" +
//                "<th class=\"header\">Repository</th>" +
//                "<th class=\"header\">Guidelines</th>" +
//                "<th class=\"header\">Actions</th>" +
//                "<th class=\"header\"></th>" +
//                "</tr>" ;
//
//        if(storedJobs==null || storedJobs.size()==0) {
//
//            contents += "<tr class=\"row job\">" +
//                    "<td colspan=\"10\"><div class=\"alert alert-warning\">No stored jobs found</div></td>" +
//                    "</tr>";
//
//        } else {
//
//            int counter = 1;
//            for (StoredJob storedJob : storedJobs) {
//
//                String parity = "";
//                if(counter%2==1)
//                    parity = "odd";
//                else
//                    parity = "even";
//
//                if(storedJob.getValidationType().equals("CU")) {
//
//                    contents += "<tr class=\"row job " + parity + "\">" +
//                            "<td><div class=\"type\">OAI Content</div></td>" +
//                            "<td><div class=\"status\">" + storedJob.getContentJobStatus() + "</div></td>" +
//                            "<td><div class=\"score\">" + storedJob.getContentJobScore() + "</div></td>" +
////                            "<td rowspan=\"2\"><div class=\"user\">" + storedJob.getUserEmail() + "</div></td>" +
//                            "<td rowspan=\"2\"><div class=\"started\">" + storedJob.getStarted() + "</div></td>" +
////                            "<td rowspan=\"2\"><div class=\"duration\">" + storedJob.getDuration() + "</div></td>" +
//                            "<td rowspan=\"2\"><div class=\"repository\">" + storedJob.getBaseUrl() + "</div></td>" +
//                            "<td rowspan=\"2\"><div class=\"guidelines\">" + storedJob.getGuidelinesShortName() + "</div></td>";
//
//
//                    contents += "<td rowspan=\"2\"><div class=\"actions\" href=\"#\">" +
//                            "<div class=\"viewDetailsLinkWrapper\"><a href=\"#" + parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() +
//                            "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-info\"></i><i class=\"fa fa-angle-right\"></i></a></div>" +
//                            "<div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"uk-button uk-button-primary resubmitJob\"><i></i>Resubmit</a></div>" +
//                            "</div></td>";
//
//                    if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
//                        contents += "<td rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";
//                    else if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_FAILED))
//                        contents += "<td rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/x-icon.png\"></td>";
////                    else
////                        contents += "<td rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" " +
////                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";
//
//                    contents += "</tr>";
//
//                    contents += "<tr class=\"row job " + parity + "\">" +
//                            "<td><div class=\"type\">OAI Usage</div></td>" +
//                            "<td><div class=\"status\">" + storedJob.getUsageJobStatus() + "</div></td>" +
//                            "<td><div class=\"score\">" + storedJob.getUsageJobScore() + "</div></td></tr>" ;
//
//                } else if(storedJob.getValidationType().equals("C")) {
//
//                    contents += "<tr class=\"row job " + parity + "\">" +
//                            "<td><div class=\"type\">OAI Content</div></td>" +
//                            "<td><div class=\"status\">" + storedJob.getContentJobStatus() + "</div></td>" +
//                            "<td><div class=\"score\">" + storedJob.getContentJobScore() + "</div></td>" +
////                            "<td><div class=\"user\">" + storedJob.getUserEmail() + "</div></td>" +
//                            "<td><div class=\"started\">" + storedJob.getStarted() + "</div></td>" +
////                            "<td><div class=\"duration\">" + storedJob.getDuration() + "</div></td>" +
//                            "<td><div class=\"repository\">" + storedJob.getBaseUrl() + "</div></td>" +
//                            "<td><div class=\"guidelines\">" + storedJob.getGuidelinesShortName() + "</div></td>";
//
//
//                    contents += "<td><div class=\"actions\" href=\"#\">" +
//                            "<div class=\"viewDetailsLinkWrapper\"><a href=\"#" + parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() +
//                            "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-info\"></i><i class=\"fa fa-angle-right\"></i></a></div>" +
//                            "<div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"uk-button uk-button-primary resubmitJob\"><i></i>Resubmit</a></div>" +
//                            "</div></td>";
//
//                    if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
//                        contents += "<td><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";
//                    else if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_FAILED))
//                        contents += "<td><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/x-icon.png\"></td>";
////                    else
////                        contents += "<td><input width=\"20\" type=\"image\" height=\"20\" " +
////                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";
//
//                    contents += "</tr>";
//
//                } else {
//
//                    contents += "<tr class=\"row job " + parity + "\">" +
//                            "<td><div class=\"type\">OAI Usage</div></td>" +
//                            "<td><div class=\"status\">" + storedJob.getUsageJobStatus() + "</div></td>" +
//                            "<td><div class=\"score\">" + storedJob.getUsageJobScore() + "</div></td>" +
////                            "<td><div class=\"user\">" + storedJob.getUserEmail() + "</div></td>" +
//                            "<td><div class=\"started\">" + storedJob.getStarted() + "</div></td>" +
////                            "<td><div class=\"duration\">" + storedJob.getDuration() + "</div></td>" +
//                            "<td><div class=\"repository\">" + storedJob.getBaseUrl() + "</div></td>" +
//                            "<td><div class=\"guidelines\">" + storedJob.getGuidelinesShortName() + "</div></td>";
//
//
//                    contents += "<td><div class=\"actions\" href=\"#\">" +
//                            "<div class=\"viewDetailsLinkWrapper\"><a href=\"#" + parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() +
//                            "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-info\"></i><i class=\"fa fa-angle-right\"></i></a></div>" +
//                            "<div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"uk-button uk-button-primary resubmitJob\"><i></i>Resubmit</a></div>" +
//                            "</div></td>";
//
//                    if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
//                        contents += "<td><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";
//                    else if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_FAILED))
//                        contents += "<td><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/x-icon.png\"></td>";
////                    else
////                        contents += "<td><input width=\"20\" type=\"image\" height=\"20\" " +
////                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";
//
//                    contents += "</tr>";
//                }
//
//                counter++;
//            }
//        }
//
//        contents += "</table></div>";
//
//        HTML questionsList = new HTML();
//        questionsList.setHTML(contents);
//
//        jobsListContentPanel.add(questionsList);
//
//        addHandlers();
//
//    }

    public void updateContents(List<StoredJob> storedJobs) {

        jobsListContentPanel.clear();

        String contents = "<div class=\"uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium uk-margin-top uk-margin-bottom\">" +
                "<table class=\"uk-table uk-table-middle jobs-list\"><thead>" +
                "<tr>" +
                "<th class=\"\">Repository</th>" +
                "<th class=\"\">Validation Type</th>" +
                "<th class=\"\">Status</th>" +
                "<th class=\"\">Score</th>" +
//                "<th class=\"header\">User</th>" +
                "<th class=\"\">Started</th>" +
//                "<th class=\"header\">Duration</th>" +
                "<th class=\"\">Guidelines</th>" +
                "<th class=\"\">Actions</th>" +
                "<th class=\"\"></th>" +
                "</tr></thead>" ;

        if(storedJobs==null || storedJobs.size()==0) {

            contents += "<tbody><tr class=\"el-item\">" +
                    "<td colspan=\"10\"><div class=\"alert alert-warning\">No stored jobs found</div></td>" +
                    "</tr></tbody>";

        } else {

            contents += "<tbody>";
            int counter = 1;
            for (StoredJob storedJob : storedJobs) {

                String parity = "";
                if(counter%2==1)
                    parity = "odd";
                else
                    parity = "even";

                if(storedJob.getValidationType().equals("CU")) {

                    contents += "<tr class=\"el-item " + parity + "\">" +
                            "<td class=\"uk-table-shrink\" rowspan=\"2\"><div class=\"el-title\">" + storedJob.getBaseUrl() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">OAI Content</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getContentJobStatus() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getContentJobScore() + "</div></td>" +
//                            "<td rowspan=\"2\"><div class=\"user\">" + storedJob.getUserEmail() + "</div></td>" +
                            "<td class=\"uk-table-shrink\" rowspan=\"2\"><div class=\"el-title\">" + storedJob.getStarted() + "</div></td>" +
//                            "<td rowspan=\"2\"><div class=\"duration\">" + storedJob.getDuration() + "</div></td>" +
                            "<td class=\"uk-table-shrink\" rowspan=\"2\"><div class=\"el-title\">" + storedJob.getGuidelinesShortName() + "</div></td>";


                    contents += "<td class=\"uk-table-shrink\" rowspan=\"2\"><div class=\"el-link actions\" href=\"#\">" +
                            "<div class=\"viewDetailsLinkWrapper\"><a href=\"#" + parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() +
                            "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-angle-right\"></i></a></div>" +
                            "<div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"resubmitJob\">Resubmit<i class=\"fa fa-repeat\" aria-hidden=\"true\"></i>" +
                            "</a></div>" +
                            "</div></td>";

                    if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
                        contents += "<td class=\"uk-table-shrink\" rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" " +
                                "title=\"Successfull\" src=\"img/icon_colours-check.jpg\"></td>";
                    else if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_FAILED))
                        contents += "<td class=\"uk-table-shrink\" rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" " +
                                "title=\"Successfull\" src=\"img/icon_colours-x.jpg\"></td>";
                    else if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_ONGOING))
                        contents += "<td class=\"uk-table-shrink\" rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" " +
                                "title=\"Ongoing\" src=\"img/icon_colours-question.jpg\"></td>";
//                    else
//                        contents += "<td rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";

                    contents += "</tr>";

                    contents += "<tr class=\"el-item " + parity + "\">" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">OAI Usage</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getUsageJobStatus() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getUsageJobScore() + "</div></td></tr>" ;

                } else if(storedJob.getValidationType().equals("C")) {

                    contents += "<tr class=\"el-item " + parity + "\">" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">OAI Content</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getContentJobStatus() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getContentJobScore() + "</div></td>" +
//                            "<td><div class=\"user\">" + storedJob.getUserEmail() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getStarted() + "</div></td>" +
//                            "<td><div class=\"duration\">" + storedJob.getDuration() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getBaseUrl() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getGuidelinesShortName() + "</div></td>";


                    contents += "<td class=\"uk-table-shrink\"><div class=\"el-link\" href=\"#\">" +
                            "<div class=\"viewDetailsLinkWrapper\"><a href=\"#" + parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() +
                            "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-info\"></i><i class=\"fa fa-angle-right\"></i></a></div>" +
                            "<div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"uk-button uk-button-primary resubmitJob\"><i></i>Resubmit</a></div>" +
                            "</div></td>";

                    if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
                        contents += "<td class=\"uk-table-shrink\"><input width=\"20\" type=\"image\" height=\"20\" " +
                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";
                    else if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_FAILED))
                        contents += "<td class=\"uk-table-shrink\"><input width=\"20\" type=\"image\" height=\"20\" " +
                                "title=\"Successfull\" src=\"img/x-icon.png\"></td>";
//                    else
//                        contents += "<td><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";

                    contents += "</tr>";

                } else {

                    contents += "<tr class=\"el-item " + parity + "\">" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">OAI Usage</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getUsageJobStatus() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getUsageJobScore() + "</div></td>" +
//                            "<td><div class=\"user\">" + storedJob.getUserEmail() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getStarted() + "</div></td>" +
//                            "<td><div class=\"duration\">" + storedJob.getDuration() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getBaseUrl() + "</div></td>" +
                            "<td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getGuidelinesShortName() + "</div></td>";


                    contents += "<td class=\"uk-table-shrink\"><div class=\"el-link\" href=\"#\">" +
                            "<div class=\"viewDetailsLinkWrapper\"><a href=\"#" + parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() +
                            "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-info\"></i><i class=\"fa fa-angle-right\"></i></a></div>" +
                            "<div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"uk-button uk-button-primary resubmitJob\"><i></i>Resubmit</a></div>" +
                            "</div></td>";

                    if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
                        contents += "<td class=\"uk-table-shrink\"><input width=\"20\" type=\"image\" height=\"20\" " +
                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";
                    else if(storedJob.getValidationStatus().equals(Constants.VALIDATION_JOB_STATUS_FAILED))
                        contents += "<td class=\"uk-table-shrink\"><input width=\"20\" type=\"image\" height=\"20\" " +
                                "title=\"Successfull\" src=\"img/x-icon.png\"></td>";
//                    else
//                        contents += "<td><input width=\"20\" type=\"image\" height=\"20\" " +
//                                "title=\"Successfull\" src=\"img/check-icon.png\"></td>";

                    contents += "</tr>";
                }

                counter++;
            }

            contents += "</tbody>";
        }

        contents += "</table></div>";

        HTML questionsList = new HTML();
        questionsList.setHTML(contents);

        jobsListContentPanel.add(questionsList);

        addHandlers();

    }

    private void addHandlers() {

        $(".resubmitJob").click(new Function() {

            public boolean f(Event e) {

                errorAlert.setVisible(false);
                successAlert.setVisible(false);
                warningAlert.setVisible(false);

                String[] idParts = $(e).get(0).getId().split("#");
                final String storedJobId = idParts[0];

                validationService.reSubmitValidationJob(Integer.parseInt(storedJobId), new AsyncCallback<Void>() {

                    @Override
                    public void onFailure(Throwable caught) {
                        errorAlert.setText("System error resubmitting job with id = " + storedJobId);
                        errorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(Void result) {
                        successAlert.setText("Job with id = " + storedJobId + " has been resubmitted successfully");
                        successAlert.setVisible(true);
                    }
                });

                return true;
            }
        });
    }

    private void drawPager(FlowPanel pagerPanel) {

        pagerPanel.clear();

        int totalNoOfPages = 0;
        if(jobStatusSelected.equals("all"))
            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobs() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
        else if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsSuccessful() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
        else if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_FAILED))
            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsFailed() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
        else
            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsOngoing() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));

        UnorderedList pager = new UnorderedList();
        pager.addStyleName("uk-pagination");

        final ListItem listItemPrevious = new ListItem();
        Anchor previous = new Anchor();
        previous.setHTML("<span class=\"uk-margin-small-right\" uk-pagination-previous></span> Previous");
        previous.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                previousPage();
            }
        });
        listItemPrevious.add(previous);
        pager.add(listItemPrevious);

        ListItem listItemNext = new ListItem();
        listItemNext.addStyleName("uk-margin-auto-left");
        Anchor next = new Anchor();
        next.setHTML("Next <span class=\"uk-margin-small-left\" uk-pagination-next></span>");
        next.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                nextPage();
            }
        });
        listItemNext.add(next);
        pager.add(listItemNext);


        if((currentPage-1)==0) {
            previous.setEnabled(false);
            listItemPrevious.addStyleName("uk-disabled");
        } else {
            previous.setEnabled(true);
            listItemPrevious.removeStyleName("uk-disabled");
        }

        if(currentPage==totalNoOfPages) {
            next.setEnabled(false);
            listItemNext.addStyleName("uk-disabled");
        } else {
            next.setEnabled(true);
            listItemNext.removeStyleName("uk-disabled");
        }

        pagerPanel.add(pager);

        Label pageNumber = new Label();

        pageNumber.setText("page " + currentPage + " of " + totalNoOfPages);
        pageNumber.addStyleName("resultsPageLabel");
        pagerPanel.add(pageNumber);
    }

//    private void drawTopPager() {
//
//        int totalNoOfPages = 0;
//        if(jobStatusSelected.equals("all"))
//            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobs() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
//        else if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
//            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsSuccessful() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
//        else if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_FAILED))
//            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsFailed() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
//        else
//            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsOngoing() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
//
//        if(currentPage ==1)
//            resultsPagerTop.setPreviousEnabled(false);
//        else
//            resultsPagerTop.setPreviousEnabled(true);
//
//        if(currentPage ==totalNoOfPages)
//            resultsPagerTop.setNextEnabled(false);
//        else
//            resultsPagerTop.setNextEnabled(true);
//
//        topPagerPanel.add(resultsPagerTop);
//
//        pageNumberTop.setText("page " + currentPage + " of " + totalNoOfPages);
//        pageNumberTop.addStyleName("resultsPageLabel");
//        topPagerPanel.add(pageNumberTop);
//    }
//
//    private void drawBottomPager() {
//
//        int totalNoOfPages = 0;
//        if(jobStatusSelected.equals("all"))
//            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobs() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
//        else if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_SUCCESSFUL))
//            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsSuccessful() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
//        else if(jobStatusSelected.equals(Constants.VALIDATION_JOB_STATUS_FAILED))
//            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsFailed() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
//        else
//            totalNoOfPages = (int) Math.ceil(jobsOfUser.getTotalJobsOngoing() / (Integer.parseInt(jobsPerPageListBox.getSelectedValue())*1.0));
//
//        if(currentPage==1)
//            resultsPagerBottom.setPreviousEnabled(false);
//        else
//            resultsPagerBottom.setPreviousEnabled(true);
//
//        if(currentPage==totalNoOfPages)
//            resultsPagerBottom.setNextEnabled(false);
//        else
//            resultsPagerBottom.setNextEnabled(true);
//
//        bottomPagerPanel.add(resultsPagerBottom);
//
//        pageNumberBottom.setText("page " + currentPage + " of " + totalNoOfPages);
//        pageNumberBottom.addStyleName("resultsPageLabel");
//        bottomPagerPanel.add(pageNumberBottom);
//    }

    private void previousPage() {

        String validationType = null;
        if(!validationJobTypesListBox.getSelectedValue().equals("noneSelected"))
            validationType = validationJobTypesListBox.getSelectedValue();

        String jobStatus = null;
        if(!jobStatusSelected.equals("all"))
            jobStatus = jobStatusSelected;

        currentPage--;
        int limit = Integer.parseInt(jobsPerPageListBox.getSelectedValue());
        int offset = (currentPage - 1) * limit;

        getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, offset,
                limit, null,  null, jobStatus, true);
    }

    private void nextPage() {

        String validationType = null;
        if(!validationJobTypesListBox.getSelectedValue().equals("noneSelected"))
            validationType = validationJobTypesListBox.getSelectedValue();

        String jobStatus = null;
        if(!jobStatusSelected.equals("all"))
            jobStatus = jobStatusSelected;

        currentPage++;
        int limit = Integer.parseInt(jobsPerPageListBox.getSelectedValue());
        int offset = (currentPage - 1) * limit;

        getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, offset,
                limit, null,  null, jobStatus, true);
    }
}
