package eu.dnetlib.repo.manager.client.datasources.update;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.*;
import com.google.gwt.user.client.ui.Anchor;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.repo.manager.client.datasources.utils.RepositoryInformationFormWidget;
import eu.dnetlib.repo.manager.client.datasources.utils.RepositoryInterfacesFormWidget;
import eu.dnetlib.repo.manager.shared.DatasourceVocabularies;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.TabPanel;
import org.gwtbootstrap3.client.ui.html.OrderedList;
import org.gwtbootstrap3.client.ui.html.UnorderedList;

/**
 * Created by stefania on 1/15/16.
 */
public class UpdateRepositoryForm implements IsWidget {

    private FlowPanel updateRepositoryFormPanel = new FlowPanel();

    ListItem listItem1 = new ListItem();
    ListItem listItem2 = new ListItem();

    ListItem updateInformationContent = new ListItem();
    ListItem updateInterfacesContent = new ListItem();

    private RepositoryInformationFormWidget repositoryInformationFormWidget;
    private RepositoryInterfacesFormWidget repositoryInterfacesFormWidget;

    public UpdateRepositoryForm(String mode, DatasourceVocabularies datasourceVocabularies, Repository repository) {

        UnorderedList tabTitles = new UnorderedList();
        tabTitles.addStyleName("uk-margin el-nav uk-tab");

        listItem1.addStyleName("uk-active");
        Anchor anchor1 = new Anchor("Update Information");
        anchor1.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                listItem1.addStyleName("uk-active");
                listItem2.removeStyleName("uk-active");
                updateInformationContent.addStyleName("uk-active");
                updateInterfacesContent.removeStyleName("uk-active");
            }
        });
        listItem1.add(anchor1);
        tabTitles.add(listItem1);

        Anchor anchor2 = new Anchor("Update Interfaces");
        anchor2.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                listItem2.addStyleName("uk-active");
                listItem1.removeStyleName("uk-active");
                updateInterfacesContent.addStyleName("uk-active");
                updateInformationContent.removeStyleName("uk-active");
            }
        });
        listItem2.add(anchor2);
        tabTitles.add(listItem2);

        updateRepositoryFormPanel.add(tabTitles);


        UnorderedList tabContent = new UnorderedList();
        tabContent.addStyleName("uk-switcher");

        updateInformationContent.addStyleName("el-item uk-active");
        tabContent.add(updateInformationContent);

        updateInterfacesContent.addStyleName("el-item");
        tabContent.add(updateInterfacesContent);

        updateRepositoryFormPanel.add(tabContent);

        repositoryInformationFormWidget = new RepositoryInformationFormWidget(mode, datasourceVocabularies, true);
        repositoryInformationFormWidget.loadRepository(repository);
        updateInformationContent.add(repositoryInformationFormWidget.asWidget());

        repositoryInterfacesFormWidget = new RepositoryInterfacesFormWidget(mode, true, datasourceVocabularies.getCompatibilityLevels(), true);
        repositoryInterfacesFormWidget.setRepositoryId(repository.getId());
        repositoryInterfacesFormWidget.loadRepositoryInterfaces(repository.getInterfaces(), repository.getId());
        updateInterfacesContent.add(repositoryInterfacesFormWidget.asWidget());
    }

    @Override
    public Widget asWidget() {
        return updateRepositoryFormPanel;
    }
}
