package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.Vocabulary;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.RadioButton;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.FormType;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Created by stefania on 3/8/16.
 */
public class SelectCrisParametersWidget implements IsWidget {

    private FlowPanel selectCrisParametersWidgetPanel = new FlowPanel();

    private Alert errorLabel = new Alert();

    private FlowPanel crisEntitiesPanel = new FlowPanel();
    private HTML crisEntitiesLabel = new HTML();
    private MultiSelectWidget multiSelectWidget;

    private FlowPanel referentialIntegrityPanel = new FlowPanel();
    private HTML referentialIntegrityLabel = new HTML();
    private Form referentialIntegrityForm = new Form();
    private FlowPanel referentialIntegrityInlinePanel = new FlowPanel();
    private RadioButton yesReferentialIntegrityRadio = new RadioButton("referentialIntegrity", "Yes", false);
    private RadioButton noReferentialIntegrityRadio = new RadioButton("referentialIntegrity", "No", false);

    public SelectCrisParametersWidget(List<String> crisEntities) {

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setDismissable(false);
        errorLabel.setVisible(false);

        selectCrisParametersWidgetPanel.add(errorLabel);
        selectCrisParametersWidgetPanel.add(crisEntitiesPanel);
        selectCrisParametersWidgetPanel.add(referentialIntegrityPanel);

        // CRIS ENTITIES
        crisEntitiesLabel.setHTML("<label>Cris Entities</label>");

        List<Vocabulary> crisEntitiesVocabulary = new ArrayList<Vocabulary>();
        for(String crisEntity : crisEntities)
            crisEntitiesVocabulary.add(new Vocabulary(crisEntity, crisEntity));
        multiSelectWidget = new MultiSelectWidget(crisEntitiesVocabulary, "Entities");

        crisEntitiesPanel.addStyleName("marginBottom20 uk-margin-top");
        crisEntitiesPanel.add(crisEntitiesLabel);
        crisEntitiesPanel.add(multiSelectWidget);

        // REFERENTIAL INTEGRITY
        referentialIntegrityLabel.setHTML("<label>Check Referential Integrity</label>");

        referentialIntegrityPanel.addStyleName("marginBottom20");
        referentialIntegrityPanel.add(referentialIntegrityLabel);
        referentialIntegrityPanel.add(referentialIntegrityForm);

        referentialIntegrityForm.addStyleName("uk-grid");
        referentialIntegrityForm.setType(FormType.INLINE);

        referentialIntegrityInlinePanel.addStyleName("uk-width-1-1");
        referentialIntegrityForm.add(referentialIntegrityInlinePanel);

        yesReferentialIntegrityRadio.setType(ButtonType.LINK);
        yesReferentialIntegrityRadio.setValue(true);
        referentialIntegrityInlinePanel.add(yesReferentialIntegrityRadio);

        noReferentialIntegrityRadio.setType(ButtonType.LINK);
        referentialIntegrityInlinePanel.add(noReferentialIntegrityRadio);
    }

    @Override
    public Widget asWidget() {
        return selectCrisParametersWidgetPanel;
    }

    public Tuple<Set<String>, Boolean> getParameters() {

        errorLabel.setVisible(false);

        Tuple<Set<String>, Boolean> parameters = new Tuple<Set<String>, Boolean>();

        if(multiSelectWidget.getSelections().isEmpty()) {
            errorLabel.setText("You need to select at least one entity");
            errorLabel.setVisible(true);
            parameters.setFirst(null);
        } else {
            Set<String> selectedEntities = new HashSet<String>();
            for(String selection : multiSelectWidget.getSelections())
                selectedEntities.add(selection);
            parameters.setFirst(selectedEntities);
        }

        parameters.setSecond(yesReferentialIntegrityRadio.getValue());

        return parameters;
    }
}
