package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.shared.Tuple;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.gwtbootstrap3.client.ui.constants.IconType;

import java.util.*;

/**
 * Created by stefania on 2/12/16.
 */
public class SelectGuidelinesWidget implements IsWidget {

    private FlowPanel selectGuidelinesWidgetPanel = new FlowPanel();

    private Alert errorLabel = new Alert();

    private Form guidelinesForm = new Form();
    private Button showAdvanced = new Button();

    private FlowPanel selectRulesPanel = new FlowPanel();

    private Map<RadioButton, SelectRulesWidget> contentRulesWidgetMap = new HashMap<RadioButton, SelectRulesWidget>();
    private Map<RadioButton, SelectRulesWidget> usageRulesWidgetMap = new HashMap<RadioButton, SelectRulesWidget>();

    private boolean areRulesShown = false;

    private RuleSet selectedRuleSet;
    private RadioButton selectedRadioButton;

    public SelectGuidelinesWidget(List<RuleSet> ruleSets) {

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setDismissable(false);
        errorLabel.setVisible(false);

        selectGuidelinesWidgetPanel.add(errorLabel);
        selectGuidelinesWidgetPanel.add(guidelinesForm);

        int counter = 0;
        for(final RuleSet ruleSet : ruleSets) {

            final RadioButton ruleSetRadio = new RadioButton("rulesetRadio", ruleSet.getName(), false);
            ruleSetRadio.setId(ruleSet.getGuidelinesAcronym());

            final SelectRulesWidget selectContentRulesWidget = new SelectRulesWidget(ruleSet.getContentRules(), "Content Rules");
            contentRulesWidgetMap.put(ruleSetRadio, selectContentRulesWidget);

            final SelectRulesWidget selectUsageRulesWidget = new SelectRulesWidget(ruleSet.getUsageRules(), "Usage Rules");
            usageRulesWidgetMap.put(ruleSetRadio, selectUsageRulesWidget);

            if(counter==0) {
                ruleSetRadio.setValue(true);
                selectedRuleSet = ruleSet;
                selectedRadioButton = ruleSetRadio;
                selectRulesPanel.add(selectContentRulesWidget.asWidget());
                selectRulesPanel.add(selectUsageRulesWidget.asWidget());
            }

            ruleSetRadio.setType(ButtonType.LINK);
            ruleSetRadio.addChangeHandler(new ChangeHandler() {
                @Override
                public void onChange(ChangeEvent event) {
                    if(ruleSetRadio.getValue()) {
                        selectedRuleSet = ruleSet;
                        selectedRadioButton = ruleSetRadio;
                        selectRulesPanel.clear();
                        selectRulesPanel.add(selectContentRulesWidget.asWidget());
                        selectRulesPanel.add(selectUsageRulesWidget.asWidget());
                    }
                }
            });

            guidelinesForm.add(new MyFormGroup(false, null, ruleSetRadio));
            counter++;
        }

        showAdvanced.setText("Show Content and Usage Rules");
        showAdvanced.setIcon(IconType.ANGLE_DOWN);
        showAdvanced.setIconPosition(IconPosition.LEFT);
        showAdvanced.addStyleName("showAdvanced");
        showAdvanced.setType(ButtonType.LINK);
        showAdvanced.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if(areRulesShown) {
                    areRulesShown = false;
                    showAdvanced.setText("Show Content and Usage Rules");
                    showAdvanced.setIcon(IconType.ANGLE_DOWN);
                    selectGuidelinesWidgetPanel.remove(selectRulesPanel);
                } else {
                    areRulesShown = true;
                    showAdvanced.setText("Hide Content and Usage Rules");
                    showAdvanced.setIcon(IconType.ANGLE_UP);
                    selectGuidelinesWidgetPanel.add(selectRulesPanel);
                }
            }
        });
        selectGuidelinesWidgetPanel.add(showAdvanced);

        selectRulesPanel.addStyleName("uk-grid");
}

    @Override
    public Widget asWidget() {
        return selectGuidelinesWidgetPanel;
    }

    public String getDesiredCompatibilityLevel() {
        return selectedRuleSet.getGuidelinesAcronym();
    }

    public Tuple<Set<Integer>, Set<Integer>> getSelectedRules() {

        errorLabel.setVisible(false);

        Tuple<Set<Integer>, Set<Integer>> selectedRules = new Tuple<Set<Integer>, Set<Integer>>();
        selectedRules.setFirst(contentRulesWidgetMap.get(selectedRadioButton).getSelectedRules());
        selectedRules.setSecond(usageRulesWidgetMap.get(selectedRadioButton).getSelectedRules());

        if(selectedRules.getFirst().isEmpty() && selectedRules.getSecond().isEmpty()) {
            errorLabel.setText("At least one content or one usage rule must be selected");
            errorLabel.setVisible(true);
        }

        return selectedRules;
    }
}
