package eu.dnetlib.repo.manager.client.widgets.wizard;

import com.google.gwt.user.client.ui.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by stefania on 12/17/15.
 */
public class BreadcrumbWidget implements IsWidget {

    private FlowPanel breadcrumbPanel = new FlowPanel();
    private FlowPanel wizardStepsPanel = new FlowPanel();

    private List<FlowPanel> wizardSteps = new ArrayList<FlowPanel>();

    public BreadcrumbWidget(List<String> wizardStepNames) {

        breadcrumbPanel.addStyleName("wizardBreadcrumbs");

        wizardStepsPanel.addStyleName("steps clearfix");
        breadcrumbPanel.add(wizardStepsPanel);

        for(int i=0; i<wizardStepNames.size(); i++) {

            FlowPanel step = new FlowPanel();
            step.addStyleName("step");

            step.add(new HTML(wizardStepNames.get(i) + " <span></span>"));
            if(i==0)
                step.addStyleName("active");

            wizardSteps.add(step);
            wizardStepsPanel.add(step);
        }
    }

    @Override
    public Widget asWidget() {
        return breadcrumbPanel;
    }

    public void setActiveStep(int stepNumber) {

        for(int i=0; i<wizardSteps.size(); i++) {
            if(i<=stepNumber)
                wizardSteps.get(i).addStyleName("active");
            else
                wizardSteps.get(i).removeStyleName("active");
        }
    }
}
