/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.client.validator.test.MultiSelectWidget;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.Vocabulary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.RadioButton;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.FormType;

public class SelectCrisParametersWidget
implements IsWidget {
    private FlowPanel selectCrisParametersWidgetPanel = new FlowPanel();
    private Alert errorLabel = new Alert();
    private FlowPanel crisEntitiesPanel = new FlowPanel();
    private HTML crisEntitiesLabel = new HTML();
    private MultiSelectWidget multiSelectWidget;
    private FlowPanel referentialIntegrityPanel = new FlowPanel();
    private HTML referentialIntegrityLabel = new HTML();
    private Form referentialIntegrityForm = new Form();
    private FlowPanel referentialIntegrityInlinePanel = new FlowPanel();
    private RadioButton yesReferentialIntegrityRadio = new RadioButton("referentialIntegrity", "Yes", false);
    private RadioButton noReferentialIntegrityRadio = new RadioButton("referentialIntegrity", "No", false);

    public SelectCrisParametersWidget(List<String> crisEntities) {
        this.errorLabel.setType(AlertType.DANGER);
        this.errorLabel.setDismissable(false);
        this.errorLabel.setVisible(false);
        this.selectCrisParametersWidgetPanel.add((Widget)this.errorLabel);
        this.selectCrisParametersWidgetPanel.add((Widget)this.crisEntitiesPanel);
        this.selectCrisParametersWidgetPanel.add((Widget)this.referentialIntegrityPanel);
        this.crisEntitiesLabel.setHTML("<label>Cris Entities</label>");
        ArrayList<Vocabulary> crisEntitiesVocabulary = new ArrayList<Vocabulary>();
        for (String crisEntity : crisEntities) {
            crisEntitiesVocabulary.add(new Vocabulary(crisEntity, crisEntity));
        }
        this.multiSelectWidget = new MultiSelectWidget(crisEntitiesVocabulary, "Entities");
        this.crisEntitiesPanel.addStyleName("marginBottom20 uk-margin-top");
        this.crisEntitiesPanel.add((Widget)this.crisEntitiesLabel);
        this.crisEntitiesPanel.add((IsWidget)this.multiSelectWidget);
        this.referentialIntegrityLabel.setHTML("<label>Check Referential Integrity</label>");
        this.referentialIntegrityPanel.addStyleName("marginBottom20");
        this.referentialIntegrityPanel.add((Widget)this.referentialIntegrityLabel);
        this.referentialIntegrityPanel.add((Widget)this.referentialIntegrityForm);
        this.referentialIntegrityForm.addStyleName("uk-grid");
        this.referentialIntegrityForm.setType(FormType.INLINE);
        this.referentialIntegrityInlinePanel.addStyleName("uk-width-1-1");
        this.referentialIntegrityForm.add((Widget)this.referentialIntegrityInlinePanel);
        this.yesReferentialIntegrityRadio.setType(ButtonType.LINK);
        this.yesReferentialIntegrityRadio.setValue(Boolean.valueOf(true));
        this.referentialIntegrityInlinePanel.add((Widget)this.yesReferentialIntegrityRadio);
        this.noReferentialIntegrityRadio.setType(ButtonType.LINK);
        this.referentialIntegrityInlinePanel.add((Widget)this.noReferentialIntegrityRadio);
    }

    public Widget asWidget() {
        return this.selectCrisParametersWidgetPanel;
    }

    public Tuple<Set<String>, Boolean> getParameters() {
        this.errorLabel.setVisible(false);
        Tuple parameters = new Tuple();
        if (this.multiSelectWidget.getSelections().isEmpty()) {
            this.errorLabel.setText("You need to select at least one entity");
            this.errorLabel.setVisible(true);
            parameters.setFirst(null);
        } else {
            HashSet<String> selectedEntities = new HashSet<String>();
            for (String selection : this.multiSelectWidget.getSelections()) {
                selectedEntities.add(selection);
            }
            parameters.setFirst(selectedEntities);
        }
        parameters.setSecond((Object)this.yesReferentialIntegrityRadio.getValue());
        return parameters;
    }
}

